/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.license;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class JavaUtilities {

    public static class StringSplitter {
        private final String delimiter;
        private boolean trim = false;
        private boolean uniqueHandling = false;

        public StringSplitter(String delimiter) {
            this.delimiter = delimiter;
        }

        public StringSplitter withTrim() {
            this.trim = true;
            return this;
        }

        public StringSplitter withUniqueHandling() {
            this.uniqueHandling = true;
            return this;
        }

        public List<String> split(String elements) {
            if (elements == null || elements.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<String> list = new ArrayList<String>();
            for (String element : elements.split(this.delimiter)) {
                String elementForAdding;
                String string = elementForAdding = this.trim ? element.trim() : element;
                if (this.uniqueHandling && list.contains(elementForAdding) || elementForAdding.isEmpty()) continue;
                list.add(elementForAdding);
            }
            return list;
        }
    }

    public static class StringJoiner {
        private final String delimiter;

        public StringJoiner(String delimiter) {
            this.delimiter = delimiter;
        }

        public String join(List<String> elements) {
            if (elements == null || elements.isEmpty()) {
                return "";
            }
            StringBuilder builder = new StringBuilder();
            for (String element : elements) {
                if (builder.length() != 0) {
                    builder.append(this.delimiter);
                }
                builder.append(element);
            }
            return builder.toString();
        }
    }
}

