/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.license;

import com.modelengineers.license.ExecuteCommanding;
import com.modelengineers.license.LicenseManagerUI;
import com.modelengineers.lismo3_0.api.LismoSettings;
import com.sun.jna.Platform;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FlexeraInformation {
    public static final String LMUTIL_WIN = "lmutil.exe";
    public static final String LMUTIL_LINUX = "lmutil";
    private static final String GET_HOST_ID_COMMAND = "lmhostid -all";
    private static final String GET_DONGLE_ID_COMMAND = "lmhostid -flexid -all";
    private static final String CHECK_LICENSE_SERVER_COMMAND = "lmstat -S MES -c ";
    private ProgressListener progressListener;
    private File lmUtilFile;
    private LmUtilInformer informer;

    public FlexeraInformation(ProgressListener progressListener, LmUtilInformer informer) {
        this.checkLMUtilFile();
        this.progressListener = progressListener;
        this.informer = informer;
    }

    private void checkLMUtilFile() {
        String lmUtilFilename = null;
        if (Platform.isWindows()) {
            lmUtilFilename = LMUTIL_WIN;
        } else if (Platform.isLinux()) {
            lmUtilFilename = LMUTIL_LINUX;
        } else {
            LicenseManagerUI.logCrit("Lmutil not supported for " + Platform.getOSType(), null);
            return;
        }
        Path lismoLibraryDir = Paths.get(LismoSettings.getLismoLibraryDirectory(), new String[0]);
        Path lmUtilPath = lismoLibraryDir.resolve(lmUtilFilename);
        this.lmUtilFile = lmUtilPath.toFile();
        if (!this.lmUtilFile.isFile()) {
            this.extractLmUtil(lmUtilPath);
        }
    }

    private void extractLmUtil(Path lmUtilPath) {
        String lmUtilFilename = lmUtilPath.getFileName().toString();
        try (InputStream in = FlexeraInformation.class.getClassLoader().getResourceAsStream(lmUtilFilename);){
            if (in != null) {
                Files.copy(in, lmUtilPath, StandardCopyOption.REPLACE_EXISTING);
            } else {
                LicenseManagerUI.logCrit("Lmutil not found in lismo.jar file.", null);
            }
            if (this.lmUtilFile.isFile() && Platform.isLinux()) {
                HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>(Arrays.asList(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.GROUP_READ, PosixFilePermission.GROUP_EXECUTE));
                Files.setPosixFilePermissions(this.lmUtilFile.toPath(), perms);
            }
        }
        catch (IOException ioe) {
            LicenseManagerUI.logCrit("Lmutil could not be extracted.", ioe);
        }
    }

    public void getHostIds() throws LmUtilFileNotFoundException {
        if (this.lmUtilFile == null || !this.lmUtilFile.canRead()) {
            throw new LmUtilFileNotFoundException();
        }
        this.getCommandOutput(new GetHostIdCommand(this.informer));
    }

    public void testLicenseServer(String server) throws LmUtilFileNotFoundException {
        if (this.lmUtilFile == null || !this.lmUtilFile.canRead()) {
            throw new LmUtilFileNotFoundException();
        }
        this.getCommandOutput(new TestServerCommand(this.informer, server));
    }

    private void getCommandOutput(LmUtilCommand command) {
        ExecuteLmUtilCommand runningCommand = new ExecuteLmUtilCommand(command);
        ExecutionWithProgressWatching commandThread = new ExecutionWithProgressWatching(runningCommand);
        commandThread.start();
    }

    public static interface LmUtilInformer {
        public void showHostIds(String var1);

        public void showResultOfTestServer(String var1);
    }

    public static interface ProgressListener {
        public void showProgressBar();

        public void hideProgressBar();
    }

    public static class LmUtilFileNotFoundException
    extends Exception {
        private static final long serialVersionUID = 3464913706628256447L;
    }

    private static enum LmstatLinesOfInterest {
        ERROR_LINE("Error getting status"),
        SERVER_STATUS_LINE("License server status"),
        LICENSE_SERVER_VERSION_LINE("license server"),
        MES_VENDOR_VERSION_LINE("MES: "),
        MES_FEATURE_LINE("Users of ");

        private final String lineMarker;

        private LmstatLinesOfInterest(String lineMarker) {
            this.lineMarker = lineMarker;
        }

        private static LmstatLinesOfInterest parse(String line) {
            if (line == null) {
                return null;
            }
            for (LmstatLinesOfInterest lineOfInterest : LmstatLinesOfInterest.values()) {
                if (!line.contains(lineOfInterest.lineMarker)) continue;
                return lineOfInterest;
            }
            return null;
        }
    }

    private class ExecuteLmUtilCommand
    extends ExecuteCommanding {
        private final LmUtilCommand lmutilCommand;

        public ExecuteLmUtilCommand(LmUtilCommand lmutilCommand) {
            this.lmutilCommand = lmutilCommand;
        }

        @Override
        protected List<String> getCommands() {
            return this.lmutilCommand.createCommands();
        }

        @Override
        protected String getWholeCommand() {
            return this.lmutilCommand.toString();
        }

        @Override
        protected void informSomeone(List<String> text) {
            this.lmutilCommand.inform(text);
        }
    }

    private class TestServerCommand
    implements LmUtilCommand {
        private final String server;
        private LmUtilInformer informer;

        private TestServerCommand(LmUtilInformer informer, String server) {
            this.informer = informer;
            this.server = server.replace(" ", "");
        }

        @Override
        public List<String> createCommands() {
            return Arrays.asList(FlexeraInformation.this.lmUtilFile + " " + FlexeraInformation.CHECK_LICENSE_SERVER_COMMAND + this.server);
        }

        @Override
        public void inform(List<String> output) {
            this.informer.showResultOfTestServer(this.addErrorInfoIfNeccessary(this.parseOutput(output)));
        }

        private String parseOutput(List<String> output) {
            StringBuilder parsed = new StringBuilder();
            for (String line : output) {
                LmstatLinesOfInterest lineOfInterest = LmstatLinesOfInterest.parse(line);
                if (lineOfInterest == null) continue;
                parsed.append(line).append(System.lineSeparator());
            }
            if (parsed.length() == 0) {
                for (String line : output) {
                    parsed.append(line).append(System.lineSeparator());
                }
            }
            return parsed.toString();
        }

        private String addErrorInfoIfNeccessary(String output) {
            StringBuilder builder = new StringBuilder();
            if (output.startsWith(LmstatLinesOfInterest.ERROR_LINE.lineMarker)) {
                builder.append("Error connecting to server '" + this.server + "'. Flexera message: ").append(System.lineSeparator()).append(System.lineSeparator());
            }
            builder.append(output);
            return builder.toString();
        }
    }

    private class GetHostIdCommand
    implements LmUtilCommand {
        private static final String REG_MAC_ADDRESS = "[0-9A-Fa-f]{12}";
        private static final String REG_DONGLE_ID = "FLEXID=\\d{2}-[0-9A-Fa-f]{8}";
        private LmUtilInformer informer;

        private GetHostIdCommand(LmUtilInformer informer) {
            this.informer = informer;
        }

        @Override
        public List<String> createCommands() {
            return Arrays.asList(FlexeraInformation.this.lmUtilFile + " " + FlexeraInformation.GET_HOST_ID_COMMAND, FlexeraInformation.this.lmUtilFile + " " + FlexeraInformation.GET_DONGLE_ID_COMMAND);
        }

        @Override
        public void inform(List<String> output) {
            this.informer.showHostIds(this.parseOutput(output));
        }

        private String parseOutput(List<String> output) {
            return this.parseHostIds(output);
        }

        private String parseHostIds(List<String> output) {
            StringBuilder parsed = new StringBuilder();
            for (String line : output) {
                this.addHostids(line, REG_MAC_ADDRESS, parsed);
                this.addHostids(line, REG_DONGLE_ID, parsed);
            }
            return parsed.toString();
        }

        private void addHostids(String line, String regex, StringBuilder builder) {
            Pattern p = Pattern.compile(regex);
            Matcher m = p.matcher(line);
            while (m.find()) {
                builder.append(m.group(0)).append(System.lineSeparator());
            }
        }
    }

    private static interface LmUtilCommand {
        public List<String> createCommands();

        public void inform(List<String> var1);
    }

    private class ExecutionWithProgressWatching
    extends Thread {
        private final ExecuteLmUtilCommand runningCommand;

        ExecutionWithProgressWatching(ExecuteLmUtilCommand runningCommand) {
            this.runningCommand = runningCommand;
        }

        @Override
        public void run() {
            try {
                new Thread(this.runningCommand).start();
                FlexeraInformation.this.progressListener.showProgressBar();
                while (!this.runningCommand.isFinished()) {
                    Thread.sleep(500L);
                }
                FlexeraInformation.this.progressListener.hideProgressBar();
            }
            catch (InterruptedException e) {
                LicenseManagerUI.logCrit("Interrupting command '" + this.runningCommand + "'", e);
                Thread.currentThread().interrupt();
            }
        }
    }
}

