/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import matlabcontrol.MatlabConnectionException;
import matlabcontrol.MatlabInvocationException;
import matlabcontrol.MatlabProxy;
import matlabcontrol.MatlabProxyFactory;

public class SelectBlockAndInportAndPortName
extends JFrame {
    public String fullPathOfSelectedBlock;
    public boolean freePortSelected;
    public int selectedNumberOfFreePort;
    public String selectedPortName;
    private MatlabProxy matlabControlProxy;
    private JPanel OuterEmptyBorderPanel;
    private JPanel blockPanel;
    private JTextField blockPathTextField;
    private JPanel buttonPanel;
    private JButton cancelButton;
    private JPanel contentPanel;
    private JRadioButton createNewPortRadioButton;
    private JRadioButton freePortRadioButton;
    private JButton getSelectedBlockButton;
    private JPanel innerPortNamePanel;
    private JPanel innerPortPanel;
    private JPanel jPanel1;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JButton okButton;
    private ButtonGroup portButtonGroup;
    private JPanel portNamePanel;
    private JTextField portNameTextField;
    private JPanel portPanel;
    private JComboBox selectFreePortComboBox;

    public SelectBlockAndInportAndPortName(String initialPortName) throws MatlabConnectionException {
        this.initMatlabProxy();
        this.initComponents();
        this.customizeComponents(initialPortName);
    }

    private void initMatlabProxy() throws MatlabConnectionException {
        MatlabProxyFactory matlabProxyFactory = new MatlabProxyFactory();
        this.matlabControlProxy = matlabProxyFactory.getProxy();
    }

    private void customizeComponents(String initialPortName) {
        this.blockPathTextField.getDocument().addDocumentListener(new BlockPathTextFieldListener());
        this.portNameTextField.setText(initialPortName);
        this.addFocusListener(new MyFocusListener());
        this.setFrameIcon();
    }

    private void setFrameIcon() {
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("toolIcon.png"));
        this.setIconImage(imageIcon.getImage());
    }

    private void saveSelectionAndCloseFrame() {
        this.saveSelection();
        this.dispose();
    }

    private void saveSelection() {
        this.fullPathOfSelectedBlock = this.blockPathTextField.getText();
        this.freePortSelected = this.freePortRadioButton.isSelected();
        if (this.freePortSelected) {
            this.selectedNumberOfFreePort = (Integer)this.selectFreePortComboBox.getSelectedItem();
        }
        this.selectedPortName = this.portNameTextField.getText();
    }

    private boolean isExistingBlock(String fullPathOfBlock) throws MatlabInvocationException {
        Object[] retArray = this.matlabControlProxy.returningFeval("mes.more.dialogs.SelectBlockAndInportAndPortName.isExistingBlock", 1, new Object[]{fullPathOfBlock});
        return ((boolean[])retArray[0])[0];
    }

    private int[] getNumbersOfFreeInportsOfBlock(String fullPathOfBlock, boolean isExistingBlock) throws MatlabInvocationException {
        int[] numbersOfFreeInports = null;
        if (isExistingBlock) {
            Object[] retArray = this.matlabControlProxy.returningFeval("mes.more.dialogs.SelectBlockAndInportAndPortName.getNumbersOfFreeInports", 1, new Object[]{fullPathOfBlock});
            double[] numbersOfFreeInportsAsDouble = (double[])retArray[0];
            numbersOfFreeInports = new int[numbersOfFreeInportsAsDouble.length];
            for (int i = 0; i < numbersOfFreeInportsAsDouble.length; ++i) {
                numbersOfFreeInports[i] = (int)numbersOfFreeInportsAsDouble[i];
            }
            return numbersOfFreeInports;
        }
        return numbersOfFreeInports;
    }

    private boolean blockIsSubsystem(String fullPathOfBlock, boolean isExistingBlock) throws MatlabInvocationException {
        boolean blockIsSubsystem = false;
        if (isExistingBlock) {
            Object[] retArray = this.matlabControlProxy.returningFeval("mes.more.dialogs.SelectBlockAndInportAndPortName.blockIsSubsystem", 1, new Object[]{fullPathOfBlock});
            blockIsSubsystem = ((boolean[])retArray[0])[0];
        }
        return blockIsSubsystem;
    }

    private void updateControlsAfterBlockHasChanged(boolean isExistingBlock, int[] numbersOfFreeInports, boolean blockIsSubsystem) {
        if (isExistingBlock && (numbersOfFreeInports.length > 0 || blockIsSubsystem)) {
            this.enableControlsAfterBlockHasChanged(numbersOfFreeInports, blockIsSubsystem);
        } else {
            this.disableControlsAfterBlockHasChanged();
        }
    }

    private void enableControlsAfterBlockHasChanged(int[] numbersOfFreeInports, boolean blockIsSubsystem) {
        this.portPanel.setEnabled(true);
        boolean freePortsAvailable = numbersOfFreeInports.length > 0;
        this.freePortRadioButton.setEnabled(freePortsAvailable);
        this.selectFreePortComboBox.setEnabled(freePortsAvailable);
        this.selectFreePortComboBox.removeAllItems();
        for (int i : numbersOfFreeInports) {
            this.selectFreePortComboBox.addItem(i);
        }
        this.freePortRadioButton.setSelected(freePortsAvailable);
        this.createNewPortRadioButton.setEnabled(blockIsSubsystem);
        this.createNewPortRadioButton.setSelected(!freePortsAvailable);
        this.portNamePanel.setEnabled(true);
        this.portNameTextField.setEnabled(true);
        this.okButton.setEnabled(true);
    }

    private void disableControlsAfterBlockHasChanged() {
        this.portPanel.setEnabled(false);
        this.freePortRadioButton.setEnabled(false);
        this.selectFreePortComboBox.setEnabled(false);
        this.createNewPortRadioButton.setEnabled(false);
        this.portNamePanel.setEnabled(false);
        this.portNameTextField.setEnabled(false);
        this.okButton.setEnabled(false);
    }

    private void initComponents() {
        this.portButtonGroup = new ButtonGroup();
        this.OuterEmptyBorderPanel = new JPanel();
        this.contentPanel = new JPanel();
        this.blockPanel = new JPanel();
        this.jPanel1 = new JPanel();
        this.blockPathTextField = new JTextField();
        this.getSelectedBlockButton = new JButton();
        this.portPanel = new JPanel();
        this.innerPortPanel = new JPanel();
        this.jPanel3 = new JPanel();
        this.freePortRadioButton = new JRadioButton();
        this.selectFreePortComboBox = new JComboBox();
        this.jPanel4 = new JPanel();
        this.createNewPortRadioButton = new JRadioButton();
        this.portNamePanel = new JPanel();
        this.innerPortNamePanel = new JPanel();
        this.portNameTextField = new JTextField();
        this.buttonPanel = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Select Target Block and Port");
        this.setLocationByPlatform(true);
        this.setResizable(false);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                SelectBlockAndInportAndPortName.this.keyPressedGeneral(evt);
            }
        });
        this.getContentPane().setLayout(new BorderLayout(0, 5));
        this.OuterEmptyBorderPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.OuterEmptyBorderPanel.setName("");
        this.OuterEmptyBorderPanel.setLayout(new BorderLayout(0, 5));
        this.contentPanel.setLayout(new BoxLayout(this.contentPanel, 3));
        this.blockPanel.setBorder(BorderFactory.createTitledBorder("Block Path"));
        this.blockPanel.setName("");
        this.blockPanel.setLayout(new BorderLayout(5, 0));
        this.jPanel1.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.jPanel1.setLayout(new BorderLayout(5, 0));
        this.blockPathTextField.setMinimumSize(new Dimension(150, 20));
        this.blockPathTextField.setPreferredSize(new Dimension(300, 20));
        this.jPanel1.add((Component)this.blockPathTextField, "Center");
        this.getSelectedBlockButton.setText("Get Selected Block");
        this.getSelectedBlockButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SelectBlockAndInportAndPortName.this.getSelectedBlockButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.getSelectedBlockButton, "East");
        this.blockPanel.add((Component)this.jPanel1, "First");
        this.contentPanel.add(this.blockPanel);
        this.portPanel.setBorder(BorderFactory.createTitledBorder("Port"));
        this.portPanel.setEnabled(false);
        this.portPanel.setLayout(new BorderLayout());
        this.innerPortPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.innerPortPanel.setLayout(new BoxLayout(this.innerPortPanel, 3));
        this.jPanel3.setLayout(new BorderLayout());
        this.portButtonGroup.add(this.freePortRadioButton);
        this.freePortRadioButton.setText("Free");
        this.freePortRadioButton.setEnabled(false);
        this.freePortRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SelectBlockAndInportAndPortName.this.freePortRadioButtonActionPerformed(evt);
            }
        });
        this.freePortRadioButton.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                SelectBlockAndInportAndPortName.this.keyPressedGeneral(evt);
            }
        });
        this.jPanel3.add((Component)this.freePortRadioButton, "West");
        this.selectFreePortComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.selectFreePortComboBox.setEnabled(false);
        this.selectFreePortComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SelectBlockAndInportAndPortName.this.selectFreePortComboBoxActionPerformed(evt);
            }
        });
        this.selectFreePortComboBox.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                SelectBlockAndInportAndPortName.this.keyPressedGeneral(evt);
            }
        });
        this.jPanel3.add((Component)this.selectFreePortComboBox, "Center");
        this.innerPortPanel.add(this.jPanel3);
        this.jPanel4.setLayout(new BorderLayout());
        this.portButtonGroup.add(this.createNewPortRadioButton);
        this.createNewPortRadioButton.setText("Create new");
        this.createNewPortRadioButton.setEnabled(false);
        this.createNewPortRadioButton.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                SelectBlockAndInportAndPortName.this.keyPressedGeneral(evt);
            }
        });
        this.jPanel4.add((Component)this.createNewPortRadioButton, "West");
        this.innerPortPanel.add(this.jPanel4);
        this.portPanel.add((Component)this.innerPortPanel, "Center");
        this.contentPanel.add(this.portPanel);
        this.portNamePanel.setBorder(BorderFactory.createTitledBorder("Name of Created Ports"));
        this.portNamePanel.setEnabled(false);
        this.portNamePanel.setLayout(new BorderLayout());
        this.innerPortNamePanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.innerPortNamePanel.setLayout(new BoxLayout(this.innerPortNamePanel, 3));
        this.portNameTextField.setEnabled(false);
        this.portNameTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SelectBlockAndInportAndPortName.this.portNameTextFieldActionPerformed(evt);
            }
        });
        this.portNameTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                SelectBlockAndInportAndPortName.this.keyPressedGeneral(evt);
            }
        });
        this.innerPortNamePanel.add(this.portNameTextField);
        this.portNamePanel.add((Component)this.innerPortNamePanel, "First");
        this.contentPanel.add(this.portNamePanel);
        this.OuterEmptyBorderPanel.add((Component)this.contentPanel, "Center");
        this.buttonPanel.setLayout(new GridLayout(1, 0, 5, 0));
        this.okButton.setText("Ok");
        this.okButton.setEnabled(false);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SelectBlockAndInportAndPortName.this.okButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.okButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.setMaximumSize(new Dimension(45, 23));
        this.cancelButton.setMinimumSize(new Dimension(45, 23));
        this.cancelButton.setPreferredSize(new Dimension(45, 23));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SelectBlockAndInportAndPortName.this.cancelButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.cancelButton);
        this.OuterEmptyBorderPanel.add((Component)this.buttonPanel, "South");
        this.getContentPane().add((Component)this.OuterEmptyBorderPanel, "Center");
        this.pack();
    }

    private void freePortRadioButtonActionPerformed(ActionEvent evt) {
    }

    private void selectFreePortComboBoxActionPerformed(ActionEvent evt) {
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void keyPressedGeneral(KeyEvent evt) {
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.saveSelectionAndCloseFrame();
    }

    private void getSelectedBlockButtonActionPerformed(ActionEvent evt) {
        try {
            Object[] retArray = this.matlabControlProxy.returningFeval("gcb", 1, new Object[0]);
            String fullPathOfSelBlock = (String)retArray[0];
            this.blockPathTextField.setText(fullPathOfSelBlock);
        }
        catch (MatlabInvocationException ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage());
        }
    }

    private void portNameTextFieldActionPerformed(ActionEvent evt) {
    }

    class BlockPathTextFieldListener
    implements DocumentListener {
        BlockPathTextFieldListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.contentChanged(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.contentChanged(e);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.contentChanged(e);
        }

        private void contentChanged(DocumentEvent e) {
            String fullPathOfBlock = SelectBlockAndInportAndPortName.this.blockPathTextField.getText();
            try {
                boolean isExistingBlock = SelectBlockAndInportAndPortName.this.isExistingBlock(fullPathOfBlock);
                int[] numbersOfFreeInports = SelectBlockAndInportAndPortName.this.getNumbersOfFreeInportsOfBlock(fullPathOfBlock, isExistingBlock);
                boolean blockIsSubsystem = SelectBlockAndInportAndPortName.this.blockIsSubsystem(fullPathOfBlock, isExistingBlock);
                SelectBlockAndInportAndPortName.this.updateControlsAfterBlockHasChanged(isExistingBlock, numbersOfFreeInports, blockIsSubsystem);
            }
            catch (MatlabInvocationException ex) {
                JOptionPane.showMessageDialog(SelectBlockAndInportAndPortName.this, ex.getMessage());
            }
        }
    }

    class MyFocusListener
    implements FocusListener {
        MyFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            SelectBlockAndInportAndPortName.this.blockPathTextField.requestFocusInWindow();
        }

        @Override
        public void focusLost(FocusEvent e) {
        }
    }
}

