/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe;

import com.modelengineers.MoRe.FrameUtils;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class RenameSignalAndPortsForward
extends JFrame {
    private static final boolean DEFAULT_RENAME_GOTOFROMS = false;
    private static final boolean DEFAULT_APPLY_PREFERENCES = false;
    private static final boolean DEFAULT_START_FROM_SELECTION = true;
    private static final boolean DEFAULT_START_FROM_SOURCE_OF_SIGNAL = false;
    private static final Preferences USER_PREFERENCES = Preferences.userRoot().node(RenameSignalAndPortsForward.class.getName());
    private final String defaultSignalName;
    private boolean closedWithOk;
    private JCheckBox applyPreferencesCheckBox;
    private ButtonGroup buttonGroup1;
    private JPanel buttonPanel;
    private JButton cancelButton;
    private JPanel checkBoxPanel;
    private JPanel contentPanel;
    private JTextField newNameTextField;
    private JButton okButton;
    private JPanel outerCheckBoxPanel;
    private JPanel outerEmptyBorderPanel;
    private JPanel radioButtonPanel;
    private JCheckBox renameGotoFromCheckBox;
    private JRadioButton selectionRadioButton;
    private JPanel signalNamePanel;
    private JRadioButton sourceOfSignalRadioButton;

    public RenameSignalAndPortsForward(String defaultSignalName) {
        this.defaultSignalName = defaultSignalName;
        this.initComponents();
        this.setUpComponents();
        this.setFrameIcon();
    }

    public boolean closedWithOk() {
        return this.closedWithOk;
    }

    public boolean isSelectionRadioButtonSelected() {
        return this.selectionRadioButton.isSelected();
    }

    public boolean isSourceOfSignalRadioButtonSelected() {
        return this.sourceOfSignalRadioButton.isSelected();
    }

    public boolean isRenameGotoFromCheckBoxSelected() {
        return this.renameGotoFromCheckBox.isSelected();
    }

    public boolean isApplyPreferencesCheckBoxSelected() {
        return this.applyPreferencesCheckBox.isSelected();
    }

    public String getNewName() {
        return this.newNameTextField.getText();
    }

    private void setUpComponents() {
        this.setUpNameField(this.defaultSignalName);
        this.setUpUserSelectionsAreStoredOnCloseAndRestoredOnOpen();
        this.setUpFrameIsClosedWithOkWhenEnterKeyIsPressedInNameFieldOrOnOkButton();
        this.setUpFrameIsClosedWithCancelWhenEscKeyIsPressed();
        this.updateOkButton();
    }

    private void setUpNameField(String initialValue) {
        this.setInitialValueOfNameField(initialValue);
        this.setUpFocusOnNameFieldWhenWindowIsOpened();
    }

    private void setInitialValueOfNameField(String initialValue) {
        this.newNameTextField.setText(initialValue);
        this.newNameTextField.selectAll();
    }

    private void setUpFocusOnNameFieldWhenWindowIsOpened() {
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                RenameSignalAndPortsForward.this.newNameTextField.requestFocusInWindow();
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
    }

    private void setUpFrameIsClosedWithOkWhenEnterKeyIsPressedInNameFieldOrOnOkButton() {
        CloseFrameWithOkOnEnterKeyListener closeFrameWithOkOnEnterKeyListener = new CloseFrameWithOkOnEnterKeyListener();
        this.newNameTextField.addKeyListener(closeFrameWithOkOnEnterKeyListener);
        this.okButton.addKeyListener(closeFrameWithOkOnEnterKeyListener);
    }

    private void storeUserPreferences() {
        USER_PREFERENCES.putBoolean("renameGotoFromCheckBox", this.isRenameGotoFromCheckBoxSelected());
        USER_PREFERENCES.putBoolean("applyPreferencesCheckBox", this.isApplyPreferencesCheckBoxSelected());
        USER_PREFERENCES.putBoolean("selectionRadioButton", this.isSelectionRadioButtonSelected());
        USER_PREFERENCES.putBoolean("sourceOfSignalRadioButton", this.isSourceOfSignalRadioButtonSelected());
    }

    private void restoreUserPreferences() {
        this.renameGotoFromCheckBox.setSelected(USER_PREFERENCES.getBoolean("renameGotoFromCheckBox", false));
        this.applyPreferencesCheckBox.setSelected(USER_PREFERENCES.getBoolean("applyPreferencesCheckBox", false));
        this.selectionRadioButton.setSelected(USER_PREFERENCES.getBoolean("selectionRadioButton", true));
        this.sourceOfSignalRadioButton.setSelected(USER_PREFERENCES.getBoolean("sourceOfSignalRadioButton", false));
    }

    public static void removeUserPreferences() throws BackingStoreException {
        USER_PREFERENCES.clear();
    }

    private void setUpUserSelectionsAreStoredOnCloseAndRestoredOnOpen() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                RenameSignalAndPortsForward.this.restoreUserPreferences();
            }

            @Override
            public void windowClosing(WindowEvent e) {
                RenameSignalAndPortsForward.this.storeUserPreferences();
            }
        });
    }

    private void setUpFrameIsClosedWithCancelWhenEscKeyIsPressed() {
        AbstractAction closeFrameWithCancelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RenameSignalAndPortsForward.this.closeFrameWithCancel();
            }
        };
        FrameUtils.bindKeyStrokeInFrameToAction(this, 27, "ESCAPE", closeFrameWithCancelAction);
    }

    private void closeFrameWithOk() {
        this.closeFrame(true);
    }

    private void closeFrameWithCancel() {
        this.closeFrame(false);
    }

    private void closeFrame(boolean closeWithOk) {
        this.closedWithOk = closeWithOk;
        this.storeUserPreferences();
        this.dispose();
    }

    private boolean newNameTextFieldContainsValidName() {
        return !this.newNameTextField.getText().isEmpty() && this.doesNotStartOrEndWithSlash(this.newNameTextField.getText());
    }

    private boolean doesNotStartOrEndWithSlash(String newName) {
        return !newName.startsWith("/") && !newName.endsWith("/");
    }

    private void updateOkButton() {
        if (this.newNameTextFieldContainsValidName()) {
            this.okButton.setEnabled(true);
        } else {
            this.okButton.setEnabled(false);
        }
    }

    private void setFrameIcon() {
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("toolIcon.png"));
        this.setIconImage(imageIcon.getImage());
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.outerEmptyBorderPanel = new JPanel();
        this.contentPanel = new JPanel();
        this.signalNamePanel = new JPanel();
        this.newNameTextField = new JTextField();
        this.radioButtonPanel = new JPanel();
        this.selectionRadioButton = new JRadioButton();
        this.sourceOfSignalRadioButton = new JRadioButton();
        this.outerCheckBoxPanel = new JPanel();
        this.checkBoxPanel = new JPanel();
        this.renameGotoFromCheckBox = new JCheckBox();
        this.applyPreferencesCheckBox = new JCheckBox();
        this.buttonPanel = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.outerEmptyBorderPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.outerEmptyBorderPanel.setLayout(new BoxLayout(this.outerEmptyBorderPanel, 1));
        this.contentPanel.setLayout(new BoxLayout(this.contentPanel, 1));
        this.signalNamePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("New Name"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.signalNamePanel.setLayout(new BoxLayout(this.signalNamePanel, 1));
        this.newNameTextField.setName("newNameTextField");
        this.newNameTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                RenameSignalAndPortsForward.this.newNameTextFieldKeyReleased(evt);
            }
        });
        this.signalNamePanel.add(this.newNameTextField);
        this.contentPanel.add(this.signalNamePanel);
        this.radioButtonPanel.setBorder(BorderFactory.createTitledBorder("Start At:"));
        this.radioButtonPanel.setLayout(new FlowLayout(0, 5, 0));
        this.buttonGroup1.add(this.selectionRadioButton);
        this.selectionRadioButton.setText("Selection");
        this.selectionRadioButton.setName("selectionRadioButton");
        this.radioButtonPanel.add(this.selectionRadioButton);
        this.buttonGroup1.add(this.sourceOfSignalRadioButton);
        this.sourceOfSignalRadioButton.setText("Source of Signal");
        this.sourceOfSignalRadioButton.setName("sourceOfSignalRadioButton");
        this.radioButtonPanel.add(this.sourceOfSignalRadioButton);
        this.contentPanel.add(this.radioButtonPanel);
        this.outerCheckBoxPanel.setLayout(new FlowLayout(0));
        this.checkBoxPanel.setLayout(new BoxLayout(this.checkBoxPanel, 1));
        this.renameGotoFromCheckBox.setText("Rename Goto/From Tags");
        this.renameGotoFromCheckBox.setName("renameGotoFrom");
        this.checkBoxPanel.add(this.renameGotoFromCheckBox);
        this.applyPreferencesCheckBox.setText("Apply MoRe Preferences to Blocks and Lines ");
        this.applyPreferencesCheckBox.setName("applyPreferences");
        this.checkBoxPanel.add(this.applyPreferencesCheckBox);
        this.outerCheckBoxPanel.add(this.checkBoxPanel);
        this.contentPanel.add(this.outerCheckBoxPanel);
        this.outerEmptyBorderPanel.add(this.contentPanel);
        this.buttonPanel.setLayout(new GridLayout(1, 0, 5, 0));
        this.okButton.setText("Ok");
        this.okButton.setEnabled(false);
        this.okButton.setName("ok");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RenameSignalAndPortsForward.this.okButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.okButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.setName("cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RenameSignalAndPortsForward.this.cancelButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.cancelButton);
        this.outerEmptyBorderPanel.add(this.buttonPanel);
        this.getContentPane().add((Component)this.outerEmptyBorderPanel, "Center");
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.closeFrameWithOk();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.closeFrameWithCancel();
    }

    private void newNameTextFieldKeyReleased(KeyEvent evt) {
        this.updateOkButton();
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(RenameSignalAndPortsForward.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(RenameSignalAndPortsForward.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(RenameSignalAndPortsForward.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(RenameSignalAndPortsForward.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                String defaultSignalName = "default signal name";
                new RenameSignalAndPortsForward(defaultSignalName).setVisible(true);
            }
        });
    }

    class CloseFrameWithOkOnEnterKeyListener
    implements KeyListener {
        CloseFrameWithOkOnEnterKeyListener() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10 && RenameSignalAndPortsForward.this.newNameTextFieldContainsValidName()) {
                RenameSignalAndPortsForward.this.closeFrameWithOk();
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }
    }
}

