/*
 * Decompiled with CFR 0.152.
 */
package mes.eula;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class EulaDialog
extends JDialog {
    public boolean accepted = false;
    private JCheckBox jAcceptCheckbox;
    private JPanel jButtonPanel;
    private JButton jCancelButton;
    private JTextArea jEulaText;
    private JLabel jLabel1;
    private JComboBox jLanguageChooser;
    private JButton jOkButton;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JPanel jTopPanel;

    public EulaDialog() {
        this.initComponents();
        this.customizeComponents();
        this.setLocationRelativeTo(null);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
    }

    private void customizeComponents() {
        this.jOkButton.setEnabled(false);
        this.initLanguageChooser();
        this.selectDefaultLanguageAndUpdateText();
        this.setFrameIcon();
    }

    private void initLanguageChooser() {
        String[] languages;
        this.jLanguageChooser.removeAllItems();
        for (String language : languages = this.getLanguagesAsOptions()) {
            this.jLanguageChooser.addItem(language);
        }
    }

    private void setFrameIcon() {
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("MES_Logo-Favicon.gif"));
        this.setIconImage(imageIcon.getImage());
    }

    private String[] getLanguagesAsOptions() {
        Language[] values = Language.values();
        String[] optionTexts = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            optionTexts[i] = values[i].name;
        }
        return optionTexts;
    }

    private void updateEulaText() {
        Language language = this.getSelectedLanguage();
        if (language != null) {
            this.jEulaText.setText(language.getEulaText());
            this.jEulaText.setSelectionStart(0);
            this.jEulaText.setSelectionEnd(0);
        }
    }

    private Language getSelectedLanguage() {
        int ixSelectedLanguage = this.jLanguageChooser.getSelectedIndex();
        if (0 <= ixSelectedLanguage && ixSelectedLanguage < Language.values().length) {
            return Language.values()[this.jLanguageChooser.getSelectedIndex()];
        }
        return null;
    }

    private void selectDefaultLanguageAndUpdateText() {
        this.selectDefaultLanguage();
        this.updateEulaText();
    }

    private void selectDefaultLanguage() {
        String currentLocaleLanguage = Locale.getDefault().getLanguage();
        for (Language language : Language.values()) {
            if (!currentLocaleLanguage.equals(language.languageCode)) continue;
            this.jLanguageChooser.setSelectedItem(language.ordinal());
            return;
        }
        this.jLanguageChooser.setSelectedItem(Language.values()[0].ordinal());
    }

    private void initComponents() {
        this.jTopPanel = new JPanel();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLanguageChooser = new JComboBox();
        this.jScrollPane1 = new JScrollPane();
        this.jEulaText = new JTextArea();
        this.jPanel3 = new JPanel();
        this.jAcceptCheckbox = new JCheckBox();
        this.jButtonPanel = new JPanel();
        this.jPanel1 = new JPanel();
        this.jOkButton = new JButton();
        this.jCancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("End-User License Agreement");
        this.setPreferredSize(new Dimension(800, 600));
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        this.jTopPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        this.jTopPanel.setLayout(new BorderLayout());
        this.jPanel2.setLayout(new FlowLayout(0));
        this.jLabel1.setText("Please choose your language:");
        this.jPanel2.add(this.jLabel1);
        this.jLanguageChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EulaDialog.this.jLanguageChooserActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.jLanguageChooser);
        this.jTopPanel.add((Component)this.jPanel2, "North");
        this.jEulaText.setEditable(false);
        this.jEulaText.setColumns(20);
        this.jEulaText.setLineWrap(true);
        this.jEulaText.setRows(5);
        this.jEulaText.setText("Hello Text");
        this.jScrollPane1.setViewportView(this.jEulaText);
        this.jTopPanel.add((Component)this.jScrollPane1, "Center");
        this.jPanel3.setLayout(new FlowLayout(0));
        this.jAcceptCheckbox.setText("I accept the End-User License Agreement");
        this.jAcceptCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EulaDialog.this.jAcceptCheckboxActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.jAcceptCheckbox);
        this.jTopPanel.add((Component)this.jPanel3, "South");
        this.getContentPane().add((Component)this.jTopPanel, "Center");
        this.jButtonPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        this.jButtonPanel.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new GridLayout(1, 0, 5, 0));
        this.jOkButton.setText("Ok");
        this.jOkButton.setPreferredSize(new Dimension(100, 23));
        this.jOkButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EulaDialog.this.jOkButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jOkButton);
        this.jCancelButton.setText("Cancel");
        this.jCancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EulaDialog.this.jCancelButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jCancelButton);
        this.jButtonPanel.add((Component)this.jPanel1, "East");
        this.getContentPane().add((Component)this.jButtonPanel, "South");
        this.pack();
    }

    private void jOkButtonActionPerformed(ActionEvent evt) {
        this.accepted = true;
        this.dispose();
    }

    private void jCancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jAcceptCheckboxActionPerformed(ActionEvent evt) {
        AbstractButton abstractButton = (AbstractButton)evt.getSource();
        boolean checkboxSelected = abstractButton.getModel().isSelected();
        this.jOkButton.setEnabled(checkboxSelected);
    }

    private void jLanguageChooserActionPerformed(ActionEvent evt) {
        this.updateEulaText();
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(EulaDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(EulaDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(EulaDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(EulaDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new EulaDialog().setVisible(true);
            }
        });
    }

    private static enum Language {
        ENGLISH("English", Locale.ENGLISH, "MES_EULA_UTF8_EN.txt"),
        CHINESE("Chinese", Locale.CHINESE, "MES_EULA_UTF8_CN.txt");

        private final String languageCode;
        private final String eulaText;
        private final String name;

        private Language(String name, Locale locale, String eulaTextFilename) {
            this.name = name;
            this.languageCode = locale.getLanguage();
            this.eulaText = this.readEulaTextFromFile(eulaTextFilename);
        }

        public String getEulaText() {
            return this.eulaText;
        }

        private String readEulaTextFromFile(String fileName) {
            InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream(fileName);
            StringBuilder strBuilder = new StringBuilder();
            try {
                String inputLine;
                BufferedReader in = new BufferedReader(new InputStreamReader(inputStream, "UTF8"));
                while ((inputLine = in.readLine()) != null) {
                    strBuilder.append(inputLine);
                    strBuilder.append("\n");
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
            return strBuilder.toString();
        }
    }
}

