/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg.cycle;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jgrapht.Graph;
import org.jgrapht.GraphTests;
import org.jgrapht.Graphs;
import org.jgrapht.alg.cycle.DirectedSimpleCycles;

public class HawickJamesSimpleCycles<V, E>
implements DirectedSimpleCycles<V, E> {
    private Graph<V, E> graph;
    private int nVertices = 0;
    private long nCycles = 0L;
    private List<List<V>> cycles = null;
    private Integer start = 0;
    private List<Integer>[] Ak = null;
    private List<Integer>[] B = null;
    private boolean[] blocked = null;
    private ArrayDeque<Integer> stack = null;
    private V[] iToV = null;
    private Map<V, Integer> vToI = null;
    private int pathLimit = 0;
    private boolean hasLimit = false;
    private Runnable operation;

    public HawickJamesSimpleCycles() {
    }

    public HawickJamesSimpleCycles(Graph<V, E> graph) throws IllegalArgumentException {
        this.graph = GraphTests.requireDirected(graph, "Graph must be directed");
    }

    private void initState() {
        int i;
        this.nCycles = 0L;
        this.nVertices = this.graph.vertexSet().size();
        this.blocked = new boolean[this.nVertices];
        this.stack = new ArrayDeque(this.nVertices);
        this.B = new ArrayList[this.nVertices];
        for (i = 0; i < this.nVertices; ++i) {
            this.B[i] = new ArrayList<Integer>();
        }
        this.iToV = this.graph.vertexSet().toArray();
        this.vToI = new HashMap<V, Integer>();
        for (i = 0; i < this.iToV.length; ++i) {
            this.vToI.put((Integer)this.iToV[i], i);
        }
        this.Ak = this.buildAdjacencyList();
        this.stack.clear();
    }

    private List<Integer>[] buildAdjacencyList() {
        ArrayList[] Ak = new ArrayList[this.nVertices];
        for (int j = 0; j < this.nVertices; ++j) {
            V v = this.iToV[j];
            List<V> s = Graphs.successorListOf(this.graph, v);
            Ak[j] = new ArrayList(s.size());
            for (V value : s) {
                Ak[j].add(this.vToI.get(value));
            }
        }
        return Ak;
    }

    private void clearState() {
        this.Ak = null;
        this.nVertices = 0;
        this.blocked = null;
        this.stack = null;
        this.iToV = null;
        this.vToI = null;
        this.B = null;
        this.operation = () -> {};
    }

    private boolean circuit(Integer v, int steps) {
        boolean f = false;
        this.stack.push(v);
        this.blocked[v.intValue()] = true;
        for (Integer w : this.Ak[v]) {
            if (w < this.start) continue;
            if (Objects.equals(w, this.start)) {
                this.operation.run();
                f = true;
                continue;
            }
            if (this.blocked[w] || !this.limitReached(steps) && !this.circuit(w, steps + 1)) continue;
            f = true;
        }
        if (f) {
            this.unblock(v);
        } else {
            for (Integer w : this.Ak[v]) {
                if (w < this.start || this.B[w].contains(v)) continue;
                this.B[w].add(v);
            }
        }
        this.stack.pop();
        return f;
    }

    private void unblock(Integer u) {
        this.blocked[u.intValue()] = false;
        for (int wPos = 0; wPos < this.B[u].size(); ++wPos) {
            Integer w = this.B[u].get(wPos);
            int sizeBeforeRemove = this.B[u].size();
            this.B[u].removeAll(Collections.singletonList(w));
            wPos -= sizeBeforeRemove - this.B[u].size();
            if (!this.blocked[w]) continue;
            this.unblock(w);
        }
    }

    public Graph<V, E> getGraph() {
        return this.graph;
    }

    public void setGraph(Graph<V, E> graph) {
        this.graph = GraphTests.requireDirected(graph, "Graph must be directed");
    }

    @Override
    public List<List<V>> findSimpleCycles() throws IllegalArgumentException {
        if (this.graph == null) {
            throw new IllegalArgumentException("Null graph.");
        }
        this.initState();
        this.cycles = new ArrayList<List<V>>();
        this.operation = () -> this.cycles.add(this.stack.stream().map(v -> this.iToV[v]).collect(Collectors.toList()));
        this.analyzeCircuits();
        List<List<V>> result = this.cycles;
        this.clearState();
        return result;
    }

    public void printSimpleCycles() {
        if (this.graph == null) {
            throw new IllegalArgumentException("Null graph.");
        }
        this.initState();
        this.operation = () -> {
            this.stack.stream().map(i -> this.iToV[i].toString() + " ").forEach(System.out::print);
            System.out.println();
        };
        this.analyzeCircuits();
        this.clearState();
    }

    public long countSimpleCycles() {
        if (this.graph == null) {
            throw new IllegalArgumentException("Null graph.");
        }
        this.initState();
        this.nCycles = 0L;
        this.operation = () -> ++this.nCycles;
        this.analyzeCircuits();
        this.clearState();
        return this.nCycles;
    }

    private void analyzeCircuits() {
        for (int i = 0; i < this.nVertices; ++i) {
            for (int j = 0; j < this.nVertices; ++j) {
                this.blocked[j] = false;
                this.B[j].clear();
            }
            this.start = this.vToI.get(this.iToV[i]);
            this.circuit(this.start, 0);
        }
    }

    public void setPathLimit(int pathLimit) {
        this.pathLimit = pathLimit - 1;
        this.hasLimit = true;
    }

    public void clearPathLimit() {
        this.hasLimit = false;
    }

    private boolean limitReached(int steps) {
        return this.hasLimit && steps >= this.pathLimit;
    }
}

