/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.graph.text.ui.layout;

import com.modelengineers.MoRe_elk.core.service.IDiagramLayoutConnector;
import com.modelengineers.MoRe_elk.core.service.LayoutMapping;
import com.modelengineers.MoRe_elk.core.ui.rendering.GraphRenderingConfigurator;
import com.modelengineers.MoRe_elk.core.ui.rendering.LayoutGraphDialog;
import com.modelengineers.MoRe_elk.graph.ElkNode;
import com.modelengineers.MoRe_elk.graph.properties.IPropertyHolder;
import com.modelengineers.MoRe_emf.ecore.EObject;
import com.modelengineers.MoRe_emf.ecore.util.EcoreUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtext.ui.editor.XtextEditor;

public class TextLayoutConnector
implements IDiagramLayoutConnector {
    @Override
    public LayoutMapping buildLayoutGraph(IWorkbenchPart workbenchPart, Object diagramPart) {
        if (workbenchPart instanceof XtextEditor) {
            XtextEditor xtextEditor = (XtextEditor)workbenchPart;
            return (LayoutMapping)xtextEditor.getDocument().readOnly(resource -> {
                EObject content;
                EObject eObject = content = resource.getContents().isEmpty() ? null : (EObject)resource.getContents().get(0);
                if (content instanceof ElkNode) {
                    return this.buildLayoutGraph(xtextEditor, (ElkNode)content);
                }
                throw new IllegalArgumentException("Not supported by this layout connector: " + content);
            });
        }
        throw new IllegalArgumentException("Not supported by this layout connector: " + workbenchPart);
    }

    protected LayoutMapping buildLayoutGraph(XtextEditor xtextEditor, ElkNode rootNode) {
        LayoutMapping mapping = new LayoutMapping((IWorkbenchPart)xtextEditor);
        mapping.setParentElement(rootNode);
        mapping.setLayoutGraph(EcoreUtil.copy(rootNode));
        return mapping;
    }

    @Override
    public void applyLayout(LayoutMapping mapping, IPropertyHolder settings) {
        Display display = PlatformUI.getWorkbench().getDisplay();
        display.asyncExec(() -> {
            EObject parentElement = (EObject)mapping.getParentElement();
            GraphRenderingConfigurator configurator = new GraphRenderingConfigurator(display);
            LayoutGraphDialog dialog = new LayoutGraphDialog(mapping.getLayoutGraph(), parentElement.eResource(), configurator, display.getActiveShell());
            dialog.open();
        });
    }
}

