/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.graph.text.ui;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.inject.Inject;
import com.modelengineers.MoRe_elk.core.data.LayoutAlgorithmData;
import com.modelengineers.MoRe_elk.core.data.LayoutMetaDataService;
import com.modelengineers.MoRe_elk.core.data.LayoutOptionData;
import com.modelengineers.MoRe_elk.core.options.CoreOptions;
import com.modelengineers.MoRe_elk.core.service.util.ProgressMonitorAdapter;
import com.modelengineers.MoRe_elk.core.util.IElkProgressMonitor;
import com.modelengineers.MoRe_elk.core.validation.GraphIssue;
import com.modelengineers.MoRe_elk.core.validation.LayoutOptionValidator;
import com.modelengineers.MoRe_elk.graph.EMapPropertyHolder;
import com.modelengineers.MoRe_elk.graph.ElkEdge;
import com.modelengineers.MoRe_elk.graph.ElkEdgeSection;
import com.modelengineers.MoRe_elk.graph.ElkGraphElement;
import com.modelengineers.MoRe_elk.graph.ElkLabel;
import com.modelengineers.MoRe_elk.graph.ElkNode;
import com.modelengineers.MoRe_elk.graph.ElkPort;
import com.modelengineers.MoRe_elk.graph.impl.ElkPropertyToValueMapEntryImpl;
import com.modelengineers.MoRe_elk.graph.properties.IProperty;
import com.modelengineers.MoRe_elk.graph.properties.IPropertyValueProxy;
import com.modelengineers.MoRe_elk.graph.text.ElkGraphTextUtil;
import com.modelengineers.MoRe_elk.graph.util.GraphIdentifierGenerator;
import com.modelengineers.MoRe_emf.common.util.EList;
import com.modelengineers.MoRe_emf.common.util.URI;
import com.modelengineers.MoRe_emf.ecore.EObject;
import com.modelengineers.MoRe_emf.ecore.resource.Resource;
import com.modelengineers.MoRe_emf.ecore.resource.impl.ResourceSetImpl;
import com.modelengineers.MoRe_emf.ecore.util.EcoreUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class ConvertGraphHandler
extends AbstractHandler {
    private static final String PARAM_TARGET_EXT = "com.modelengineers.MoRe_elk.graph.text.convert.targetExtension";
    private static final String EXT_ELK_TEXT = "elkt";
    private static final String EXT_ELK_XMI = "elkg";
    private String targetExtension;
    @Inject
    private LayoutOptionValidator layoutOptionValidator;
    private static final List<? extends IProperty<?>> EXCLUDED_OPTIONS = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new IProperty[]{CoreOptions.POSITION, CoreOptions.BEND_POINTS, CoreOptions.JUNCTION_POINTS}));

    public final Object execute(ExecutionEvent event) throws ExecutionException {
        boolean _not;
        this.targetExtension = event.getParameter(PARAM_TARGET_EXT);
        boolean _isValidTargetExtension = this.isValidTargetExtension(this.targetExtension);
        boolean bl = _not = !_isValidTargetExtension;
        if (_not) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Invalid target extension: ");
            _builder.append(this.targetExtension);
            Status status = new Status(4, "com.modelengineers.MoRe_elk.graph.text.ui", _builder.toString());
            StatusManager.getManager().handle((IStatus)status, 3);
            return null;
        }
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            final Iterable files = Iterables.filter((Iterable)((IStructuredSelection)selection).toList(), IFile.class);
            Job job = new Job("Convert models"){

                protected IStatus run(IProgressMonitor monitor) {
                    final ProgressMonitorAdapter elkMonitor = new ProgressMonitorAdapter(monitor);
                    elkMonitor.begin("Convert models", IterableExtensions.size((Iterable)files));
                    Consumer<IFile> _function = new Consumer<IFile>(){

                        @Override
                        public void accept(IFile file) {
                            boolean _not;
                            boolean _isCanceled = elkMonitor.isCanceled();
                            boolean bl = _not = !_isCanceled;
                            if (_not) {
                                ConvertGraphHandler.this.convert(file, elkMonitor.subTask(1.0f));
                            }
                        }
                    };
                    files.forEach(_function);
                    elkMonitor.done();
                    return Status.OK_STATUS;
                }
            };
            job.setUser(true);
            job.schedule();
        }
        return null;
    }

    private boolean isValidTargetExtension(String targetExtension) {
        return Objects.equal((Object)targetExtension, (Object)EXT_ELK_TEXT) || Objects.equal((Object)targetExtension, (Object)EXT_ELK_XMI);
    }

    public void convert(IFile file, IElkProgressMonitor monitor) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Convert ");
        String _name = file.getName();
        _builder.append(_name);
        monitor.begin(_builder.toString(), 3.0f);
        try {
            try {
                EList<EObject> sourceModels = this.readModel(URI.createPlatformResourceURI(file.getFullPath().toString(), false));
                monitor.worked(1.0f);
                Functions.Function1<EObject, EObject> _function = new Functions.Function1<EObject, EObject>(){

                    public EObject apply(EObject it) {
                        return ConvertGraphHandler.this.transform(it);
                    }
                };
                List targetModels = IterableExtensions.toList((Iterable)IterableExtensions.map(sourceModels, (Functions.Function1)_function));
                monitor.worked(1.0f);
                this.saveModel(targetModels, this.createTarget(file));
            }
            catch (Throwable _t) {
                if (!(_t instanceof Exception)) {
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
                Exception exception = (Exception)_t;
                Status status = new Status(4, "com.modelengineers.MoRe_elk.graph.text.ui", "Error while converting the selected graph.", (Throwable)exception);
                StatusManager.getManager().handle((IStatus)status, 3);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    protected EObject transform(EObject model) {
        EObject copy = EcoreUtil.copy(model);
        if (this.targetExtension.equals(EXT_ELK_TEXT) && copy instanceof ElkNode) {
            ElkNode graph = (ElkNode)copy;
            GraphIdentifierGenerator.forGraph(graph).assertValid().assertExists().assertUnique().execute();
        }
        return copy;
    }

    private URI createTarget(IFile file) {
        IPath basePath = file.getFullPath();
        String name = basePath.removeFileExtension().lastSegment();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(name);
        _builder.append(".");
        _builder.append(this.targetExtension);
        Path targetPath = new Path(_builder.toString());
        int i = 0;
        IContainer parent = file.getParent();
        while (parent.exists((IPath)targetPath)) {
            Path _path;
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append(name);
            int _plusPlus = i++;
            _builder_1.append((Object)_plusPlus);
            _builder_1.append(".");
            _builder_1.append(this.targetExtension);
            targetPath = _path = new Path(_builder_1.toString());
        }
        targetPath = parent.getFullPath().append((IPath)targetPath);
        return URI.createPlatformResourceURI(targetPath.toString(), false);
    }

    private EList<EObject> readModel(URI uri) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.getResource(uri, true);
        return resource.getContents();
    }

    private void saveModel(List<EObject> models, URI uri) throws IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.createResource(uri);
        resource.getContents().addAll(models);
        resource.save(Collections.EMPTY_MAP);
    }

    protected void removeInvalidProperties(ElkNode graph) {
        final ArrayList toRemove = CollectionLiterals.newArrayList();
        Procedures.Procedure1<EMapPropertyHolder> _function = new Procedures.Procedure1<EMapPropertyHolder>(){

            public void apply(final EMapPropertyHolder element) {
                Consumer _function = new Consumer<Map.Entry<IProperty<?>, Object>>(){

                    @Override
                    public void accept(Map.Entry<IProperty<?>, Object> entry) {
                        boolean _not;
                        boolean _isValid = ConvertGraphHandler.this.isValid(entry.getKey(), entry.getValue(), element);
                        boolean bl = _not = !_isValid;
                        if (_not) {
                            toRemove.add((ElkPropertyToValueMapEntryImpl)entry);
                        }
                    }
                };
                element.getProperties().forEach(_function);
            }
        };
        IteratorExtensions.forEach((Iterator)Iterators.filter(graph.eAllContents(), EMapPropertyHolder.class), (Procedures.Procedure1)_function);
        Consumer<ElkPropertyToValueMapEntryImpl> _function_1 = new Consumer<ElkPropertyToValueMapEntryImpl>(){

            @Override
            public void accept(ElkPropertyToValueMapEntryImpl it) {
                EcoreUtil.remove(it);
            }
        };
        toRemove.forEach(_function_1);
    }

    private boolean isValid(IProperty<?> property, Object value, EMapPropertyHolder container) {
        LayoutOptionData _xifexpression = null;
        _xifexpression = property instanceof LayoutOptionData ? (LayoutOptionData)property : LayoutMetaDataService.getInstance().getOptionData(property.getId());
        LayoutOptionData option = _xifexpression;
        if (option == null) {
            return false;
        }
        boolean _contains = EXCLUDED_OPTIONS.contains(option);
        if (_contains) {
            return false;
        }
        Object _xifexpression_1 = null;
        if (value instanceof String) {
            _xifexpression_1 = option.parseValue((String)value);
        } else {
            Object _xifexpression_2 = null;
            _xifexpression_2 = value instanceof IPropertyValueProxy ? ((IPropertyValueProxy)value).resolveValue(option) : value;
            _xifexpression_1 = _xifexpression_2;
        }
        Object parsedValue = _xifexpression_1;
        if (parsedValue == null) {
            return false;
        }
        if (container instanceof ElkGraphElement) {
            List<GraphIssue> issues;
            boolean _isEmpty;
            boolean _not_2;
            boolean _not;
            boolean _contains_1;
            boolean _matched = false;
            if (container instanceof ElkNode) {
                boolean _not2;
                _matched = true;
                boolean bl = _not2 = !option.getTargets().contains((Object)LayoutOptionData.Target.NODES) && (((ElkNode)container).getChildren().isEmpty() || !option.getTargets().contains((Object)LayoutOptionData.Target.PARENTS));
                if (_not2) {
                    return false;
                }
            }
            if (!_matched && container instanceof ElkEdge) {
                _matched = true;
                _contains_1 = option.getTargets().contains((Object)LayoutOptionData.Target.EDGES);
                boolean bl = _not = !_contains_1;
                if (_not) {
                    return false;
                }
            }
            if (!_matched && container instanceof ElkPort) {
                _matched = true;
                _contains_1 = option.getTargets().contains((Object)LayoutOptionData.Target.PORTS);
                boolean bl = _not = !_contains_1;
                if (_not) {
                    return false;
                }
            }
            if (!_matched && container instanceof ElkLabel) {
                _matched = true;
                _contains_1 = option.getTargets().contains((Object)LayoutOptionData.Target.LABELS);
                boolean bl = _not = !_contains_1;
                if (_not) {
                    return false;
                }
            }
            if (container instanceof ElkNode && option.getTargets().contains((Object)LayoutOptionData.Target.NODES)) {
                boolean _isSupportedByAlgorithm = this.isSupportedByAlgorithm(option, ((ElkNode)container).getParent());
                boolean bl = _not = !_isSupportedByAlgorithm;
                if (_not) {
                    return false;
                }
            } else {
                boolean _not_1;
                boolean _isSupportedByAlgorithm_1 = this.isSupportedByAlgorithm(option, (ElkGraphElement)container);
                boolean bl = _not_1 = !_isSupportedByAlgorithm_1;
                if (_not_1) {
                    return false;
                }
            }
            boolean bl = _not_2 = !(_isEmpty = (issues = this.layoutOptionValidator.checkProperty(option, parsedValue, (ElkGraphElement)container)).isEmpty());
            return !_not_2;
        }
        return false;
    }

    private boolean isSupportedByAlgorithm(LayoutOptionData option, ElkGraphElement element) {
        boolean _equals = Objects.equal((Object)option, CoreOptions.ALGORITHM);
        if (_equals) {
            return true;
        }
        LayoutAlgorithmData algorithm = ElkGraphTextUtil.getAlgorithm(element);
        if (algorithm != null && algorithm.knowsOption(option)) {
            return true;
        }
        ElkNode parent = (ElkNode)EcoreUtil2.getContainerOfType((EObject)element, ElkNode.class);
        while (parent != null) {
            algorithm = ElkGraphTextUtil.getAlgorithm(parent);
            if (algorithm != null && algorithm.knowsOption(option)) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    protected void removeUnnecessaryLayouts(ElkNode graph) {
        final ArrayList toRemove = CollectionLiterals.newArrayList();
        Procedures.Procedure1<ElkEdge> _function = new Procedures.Procedure1<ElkEdge>(){

            public void apply(ElkEdge edge) {
                EList<ElkEdgeSection> _sections = edge.getSections();
                Iterables.addAll((Collection)toRemove, _sections);
            }
        };
        IteratorExtensions.forEach((Iterator)Iterators.filter(graph.eAllContents(), ElkEdge.class), (Procedures.Procedure1)_function);
        Consumer<ElkEdgeSection> _function_1 = new Consumer<ElkEdgeSection>(){

            @Override
            public void accept(ElkEdgeSection it) {
                EcoreUtil.remove(it);
            }
        };
        toRemove.forEach(_function_1);
    }
}

