/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.graph.properties;

import com.modelengineers.MoRe_elk.graph.properties.IProperty;
import com.modelengineers.MoRe_elk.graph.util.ElkReflect;

public class Property<T>
implements IProperty<T>,
Comparable<IProperty<?>> {
    private final String id;
    private T defaultValue;
    private Comparable<? super T> lowerBound = NEGATIVE_INFINITY;
    private Comparable<? super T> upperBound = POSITIVE_INFINITY;
    public static final Comparable<Object> NEGATIVE_INFINITY = new Comparable<Object>(){

        @Override
        public int compareTo(Object other) {
            return -1;
        }

        public String toString() {
            return "-\u221e";
        }
    };
    public static final Comparable<Object> POSITIVE_INFINITY = new Comparable<Object>(){

        @Override
        public int compareTo(Object other) {
            return 1;
        }

        public String toString() {
            return "+\u221e";
        }
    };

    public Property(String theid) {
        this.id = theid;
    }

    public Property(String theid, T thedefaultValue) {
        this(theid);
        this.defaultValue = thedefaultValue;
    }

    public Property(IProperty<T> other, T thedefaultValue) {
        this(other.getId(), thedefaultValue);
    }

    public Property(String theid, T thedefaultValue, Comparable<? super T> thelowerBound) {
        this(theid, thedefaultValue);
        if (thelowerBound != null) {
            this.lowerBound = thelowerBound;
        }
    }

    public Property(String theid, T thedefaultValue, Comparable<? super T> thelowerBound, Comparable<? super T> theupperBound) {
        this(theid, (T)thedefaultValue, thelowerBound);
        if (theupperBound != null) {
            this.upperBound = theupperBound;
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof IProperty) {
            return this.id.equals(((IProperty)obj).getId());
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return this.id;
    }

    @Override
    public T getDefault() {
        if (this.defaultValue instanceof Cloneable) {
            T clone = ElkReflect.clone(this.defaultValue);
            if (clone == null) {
                throw new IllegalStateException("Couldn't clone property '" + this.id + "'. " + "Make sure its type is registered with the " + ElkReflect.class.getSimpleName() + " utility class.");
            }
            return clone;
        }
        return this.defaultValue;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Comparable<? super T> getLowerBound() {
        return this.lowerBound;
    }

    @Override
    public Comparable<? super T> getUpperBound() {
        return this.upperBound;
    }

    @Override
    public int compareTo(IProperty<?> other) {
        return this.id.compareTo(other.getId());
    }
}

