/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.graph.json.text.conversion;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.modelengineers.MoRe_elk.core.data.LayoutMetaDataService;
import com.modelengineers.MoRe_elk.core.data.LayoutOptionData;
import com.modelengineers.MoRe_elk.graph.json.text.services.ElkGraphJsonGrammarAccess;
import com.modelengineers.MoRe_elk.graph.properties.IProperty;
import com.modelengineers.MoRe_elk.graph.properties.Property;
import java.util.List;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.conversion.impl.AbstractValueConverter;
import org.eclipse.xtext.conversion.impl.IDValueConverter;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class PropertyKeyValueConverter
extends AbstractValueConverter<IProperty<?>> {
    private IDValueConverter idValueConverter;

    @Inject
    public void initialize(Provider<IDValueConverter> idValueConverterProvider, final ElkGraphJsonGrammarAccess grammarAccess) {
        IDValueConverter _doubleArrow;
        IDValueConverter _get = (IDValueConverter)idValueConverterProvider.get();
        Procedures.Procedure1<IDValueConverter> _function = new Procedures.Procedure1<IDValueConverter>(){

            public void apply(IDValueConverter it) {
                it.setRule((AbstractRule)grammarAccess.getIDRule());
            }
        };
        this.idValueConverter = _doubleArrow = (IDValueConverter)ObjectExtensions.operator_doubleArrow((Object)_get, (Procedures.Procedure1)_function);
    }

    public String toString(IProperty<?> value) throws ValueConverterException {
        String _plus;
        if (value == null) {
            throw new ValueConverterException("IProperty value may not be null.", null, null);
        }
        LayoutMetaDataService metaDataService = LayoutMetaDataService.getInstance();
        List split = Strings.split((String)value.getId(), (String)".");
        String suffix = null;
        int _size = split.size();
        int i = _size - 1;
        while (i >= 0) {
            if (suffix == null) {
                int _minusMinus = i--;
                suffix = this.idValueConverter.toString((Object)((String)split.get(_minusMinus)));
            } else {
                String _plus_1;
                int _minusMinus_1 = i--;
                String _string = this.idValueConverter.toString((Object)((String)split.get(_minusMinus_1)));
                _plus = String.valueOf(_string) + ".";
                suffix = _plus_1 = String.valueOf(_plus) + suffix;
            }
            LayoutOptionData knownOption = metaDataService.getOptionDataBySuffix(suffix);
            if (knownOption == null || !StringExtensions.isNullOrEmpty((String)knownOption.getGroup()) && !suffix.contains(knownOption.getGroup())) continue;
            return suffix;
        }
        Functions.Function1<String, String> _function = new Functions.Function1<String, String>(){

            public String apply(String it) {
                return PropertyKeyValueConverter.this.idValueConverter.toString((Object)it);
            }
        };
        String _join = IterableExtensions.join((Iterable)ListExtensions.map((List)split, (Functions.Function1)_function), (CharSequence)".");
        _plus = "\"" + _join;
        return String.valueOf(_plus) + "\"";
    }

    public IProperty<?> toValue(String string, final INode node) throws ValueConverterException {
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)string);
        if (_isNullOrEmpty) {
            throw new ValueConverterException("Cannot convert empty string to a property identifier.", node, null);
        }
        Functions.Function1<String, String> _function = new Functions.Function1<String, String>(){

            public String apply(String it) {
                return PropertyKeyValueConverter.this.idValueConverter.toValue(it, node);
            }
        };
        String idSuffix = IterableExtensions.join((Iterable)ListExtensions.map((List)Strings.split((String)this.unquoteIfNecessary(string), (String)"."), (Functions.Function1)_function), (CharSequence)".");
        LayoutOptionData optionData = LayoutMetaDataService.getInstance().getOptionDataBySuffix(idSuffix);
        if (optionData == null) {
            return new Property(string);
        }
        return optionData;
    }

    private String unquoteIfNecessary(String s) {
        if (s.length() >= 2 && (s.startsWith("\"") && s.endsWith("\"") || s.startsWith("'") && s.endsWith("'"))) {
            int _length = s.length();
            int _minus = _length - 1;
            return s.substring(1, _minus);
        }
        return s;
    }
}

