/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.graph.json;

import com.google.common.base.Objects;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.modelengineers.MoRe_elk.core.data.LayoutMetaDataService;
import com.modelengineers.MoRe_elk.core.data.LayoutOptionData;
import com.modelengineers.MoRe_elk.core.math.KVector;
import com.modelengineers.MoRe_elk.core.math.KVectorChain;
import com.modelengineers.MoRe_elk.core.options.CoreOptions;
import com.modelengineers.MoRe_elk.core.util.IndividualSpacings;
import com.modelengineers.MoRe_elk.graph.EMapPropertyHolder;
import com.modelengineers.MoRe_elk.graph.ElkBendPoint;
import com.modelengineers.MoRe_elk.graph.ElkConnectableShape;
import com.modelengineers.MoRe_elk.graph.ElkEdge;
import com.modelengineers.MoRe_elk.graph.ElkEdgeSection;
import com.modelengineers.MoRe_elk.graph.ElkGraphElement;
import com.modelengineers.MoRe_elk.graph.ElkLabel;
import com.modelengineers.MoRe_elk.graph.ElkNode;
import com.modelengineers.MoRe_elk.graph.ElkPort;
import com.modelengineers.MoRe_elk.graph.ElkShape;
import com.modelengineers.MoRe_elk.graph.json.JsonAdapter;
import com.modelengineers.MoRe_elk.graph.properties.IPropertyHolder;
import com.modelengineers.MoRe_elk.graph.util.ElkGraphUtil;
import com.modelengineers.MoRe_emf.common.util.EList;
import com.modelengineers.MoRe_emf.ecore.EObject;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public final class JsonImporter {
    @Extension
    private JsonAdapter _jsonAdapter = new JsonAdapter();
    private final BiMap<Object, ElkNode> nodeIdMap = HashBiMap.create();
    private final BiMap<Object, ElkPort> portIdMap = HashBiMap.create();
    private final Map<Object, ElkEdge> edgeIdMap = Maps.newHashMap();
    private final BiMap<Object, ElkEdgeSection> edgeSectionIdMap = HashBiMap.create();
    private final BiMap<ElkNode, Object> nodeJsonMap = HashBiMap.create();
    private final Map<ElkPort, Object> portJsonMap = Maps.newHashMap();
    private final Map<ElkEdge, Object> edgeJsonMap = Maps.newHashMap();
    private final Map<ElkEdgeSection, Object> edgeSectionJsonMap = Maps.newHashMap();
    private final Map<ElkLabel, Object> labelJsonMap = Maps.newHashMap();
    private Object inputModel;

    public ElkNode transform(Object graph) {
        this.inputModel = graph;
        this.clearMaps();
        ElkNode root = this.transformNode(graph, null);
        this.transformEdges(graph);
        return root;
    }

    public Object getInputModel() {
        return this.inputModel;
    }

    private void clearMaps() {
        this.nodeIdMap.clear();
        this.portIdMap.clear();
        this.edgeIdMap.clear();
        this.edgeSectionIdMap.clear();
        this.nodeJsonMap.clear();
        this.portJsonMap.clear();
        this.edgeJsonMap.clear();
        this.edgeSectionJsonMap.clear();
    }

    private JsonArray transformChildNodes(Object jsonNodeA, final ElkNode parent) {
        JsonArray _xblockexpression = null;
        JsonObject jsonNode = this._jsonAdapter.toJsonObject(jsonNodeA);
        JsonArray _optJSONArray = this._jsonAdapter.optJSONArray(jsonNode, "children");
        Procedures.Procedure1<JsonArray> _function = new Procedures.Procedure1<JsonArray>(){

            public void apply(JsonArray children) {
                if (children != null) {
                    int _sizeJsonArr = JsonImporter.this._jsonAdapter.sizeJsonArr(children);
                    ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _sizeJsonArr, true);
                    for (Integer i : _doubleDotLessThan) {
                        JsonObject _optJSONObject = JsonImporter.this._jsonAdapter.optJSONObject(children, i);
                        if (_optJSONObject == null) continue;
                        JsonImporter.this.transformNode(_optJSONObject, parent);
                    }
                }
            }
        };
        _xblockexpression = (JsonArray)ObjectExtensions.operator_doubleArrow((Object)_optJSONArray, (Procedures.Procedure1)_function);
        return _xblockexpression;
    }

    private ElkNode transformNode(Object jsonNode, ElkNode parent) {
        ElkNode node = this.register(ElkGraphUtil.createNode(parent), jsonNode);
        node.setIdentifier(this._jsonAdapter.getIdSave(this._jsonAdapter.toJsonObject(jsonNode)));
        this.transformProperties(jsonNode, node);
        this.transformIndividualSpacings(jsonNode, node);
        this.transformShapeLayout(jsonNode, node);
        this.transformPorts(jsonNode, node);
        this.transformLabels(jsonNode, node);
        this.transformChildNodes(jsonNode, node);
        return node;
    }

    private void transformEdges(Object jsonObjA) {
        JsonObject jsonObj = this._jsonAdapter.toJsonObject(jsonObjA);
        final ElkNode node = (ElkNode)this.nodeJsonMap.inverse().get((Object)jsonObj);
        if (node == null) {
            String _idSave = this._jsonAdapter.getIdSave(jsonObj);
            String _plus = "Unable to find elk node for json object '" + _idSave;
            String _plus_1 = String.valueOf(_plus) + "' Panic!";
            throw this._jsonAdapter.formatError(_plus_1);
        }
        JsonArray _optJSONArray = this._jsonAdapter.optJSONArray(jsonObj, "edges");
        Procedures.Procedure1<JsonArray> _function = new Procedures.Procedure1<JsonArray>(){

            public void apply(JsonArray edges) {
                if (edges != null) {
                    int _sizeJsonArr = JsonImporter.this._jsonAdapter.sizeJsonArr(edges);
                    ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _sizeJsonArr, true);
                    for (Integer i : _doubleDotLessThan) {
                        JsonObject edge = JsonImporter.this._jsonAdapter.optJSONObject(edges, i);
                        if (JsonImporter.this._jsonAdapter.hasJsonObj(edge, "sources") || JsonImporter.this._jsonAdapter.hasJsonObj(edge, "targets")) {
                            JsonImporter.this.transformEdge(edge, node);
                        } else {
                            JsonImporter.this.transformPrimitiveEdge(edge, node);
                        }
                        ElkGraphUtil.updateContainment((ElkEdge)JsonImporter.this.edgeIdMap.get(JsonImporter.this._jsonAdapter.getId(edge)));
                    }
                }
            }
        };
        ObjectExtensions.operator_doubleArrow((Object)_optJSONArray, (Procedures.Procedure1)_function);
        JsonArray _optJSONArray_1 = this._jsonAdapter.optJSONArray(jsonObj, "children");
        Procedures.Procedure1<JsonArray> _function_1 = new Procedures.Procedure1<JsonArray>(){

            public void apply(JsonArray children) {
                if (children != null) {
                    int _sizeJsonArr = JsonImporter.this._jsonAdapter.sizeJsonArr(children);
                    ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _sizeJsonArr, true);
                    for (Integer i : _doubleDotLessThan) {
                        JsonObject _optJSONObject = JsonImporter.this._jsonAdapter.optJSONObject(children, i);
                        if (_optJSONObject == null) continue;
                        JsonImporter.this.transformEdges(_optJSONObject);
                    }
                }
            }
        };
        ObjectExtensions.operator_doubleArrow((Object)_optJSONArray_1, (Procedures.Procedure1)_function_1);
    }

    private JsonArray transformPrimitiveEdge(Object jsonObjA, ElkNode parent) {
        JsonArray _xblockexpression = null;
        JsonObject jsonObj = this._jsonAdapter.toJsonObject(jsonObjA);
        ElkEdge edge = this.register(ElkGraphUtil.createEdge(parent), (Object)jsonObj);
        edge.setIdentifier(this._jsonAdapter.getIdSave(jsonObj));
        ElkNode srcNode = (ElkNode)this.nodeIdMap.get(this._jsonAdapter.asId(this._jsonAdapter.getJsonObj(jsonObj, "source")));
        JsonElement _jsonObj = this._jsonAdapter.getJsonObj(jsonObj, "sourcePort");
        Object _asId = null;
        if (_jsonObj != null) {
            _asId = this._jsonAdapter.asId(_jsonObj);
        }
        ElkPort srcPort = (ElkPort)this.portIdMap.get(_asId);
        if (srcNode == null) {
            Object _id = this._jsonAdapter.getId(jsonObj);
            String _plus = "An edge must have a source node (edge id: '" + _id;
            String _plus_1 = String.valueOf(_plus) + "').";
            throw this._jsonAdapter.formatError(_plus_1);
        }
        if (srcPort != null && !Objects.equal((Object)srcPort.getParent(), (Object)srcNode)) {
            String _idSave = this._jsonAdapter.getIdSave(jsonObj);
            String _plus_2 = "The source port of an edge must be a port of the edge's source node (edge id: '" + _idSave;
            String _plus_3 = String.valueOf(_plus_2) + "').";
            throw this._jsonAdapter.formatError(_plus_3);
        }
        EList<ElkConnectableShape> _sources = edge.getSources();
        ElkConnectableShape _elvis = null;
        _elvis = srcPort != null ? srcPort : srcNode;
        _sources.add(_elvis);
        ElkNode tgtNode = (ElkNode)this.nodeIdMap.get(this._jsonAdapter.asId(this._jsonAdapter.getJsonObj(jsonObj, "target")));
        JsonElement _jsonObj_1 = this._jsonAdapter.getJsonObj(jsonObj, "targetPort");
        Object _asId_1 = null;
        if (_jsonObj_1 != null) {
            _asId_1 = this._jsonAdapter.asId(_jsonObj_1);
        }
        ElkPort tgtPort = (ElkPort)this.portIdMap.get(_asId_1);
        if (tgtNode == null) {
            Object _id_1 = this._jsonAdapter.getId(jsonObj);
            String _plus_4 = "An edge must have a target node (edge id: '" + _id_1;
            String _plus_5 = String.valueOf(_plus_4) + "').";
            throw this._jsonAdapter.formatError(_plus_5);
        }
        if (tgtPort != null && !Objects.equal((Object)tgtPort.getParent(), (Object)tgtNode)) {
            String _idSave_1 = this._jsonAdapter.getIdSave(jsonObj);
            String _plus_6 = "The target port of an edge must be a port of the edge's target node (edge id: '" + _idSave_1;
            String _plus_7 = String.valueOf(_plus_6) + "').";
            throw this._jsonAdapter.formatError(_plus_7);
        }
        EList<ElkConnectableShape> _targets = edge.getTargets();
        ElkConnectableShape _elvis_1 = null;
        _elvis_1 = tgtPort != null ? tgtPort : tgtNode;
        _targets.add(_elvis_1);
        if (edge.getSources().isEmpty() || edge.getTargets().isEmpty()) {
            String _idSave_2 = this._jsonAdapter.getIdSave(jsonObj);
            String _plus_8 = "An edge must have at least one source and one target (edge id: '" + _idSave_2;
            String _plus_9 = String.valueOf(_plus_8) + "').";
            throw this._jsonAdapter.formatError(_plus_9);
        }
        this.transformProperties(jsonObj, edge);
        this.transformPrimitiveEdgeLayout(jsonObj, edge);
        _xblockexpression = this.transformLabels(jsonObj, edge);
        return _xblockexpression;
    }

    private JsonArray transformPrimitiveEdgeLayout(Object jsonObjA, ElkEdge edge) {
        JsonArray _xblockexpression = null;
        JsonObject jsonObj = this._jsonAdapter.toJsonObject(jsonObjA);
        JsonArray _xifexpression = null;
        if (this._jsonAdapter.hasJsonObj(jsonObj, "sourcePoint") || this._jsonAdapter.hasJsonObj(jsonObj, "targetPoint") || this._jsonAdapter.hasJsonObj(jsonObj, "bendPoints")) {
            JsonArray _xblockexpression_1 = null;
            final ElkEdgeSection section = ElkGraphUtil.createEdgeSection(edge);
            JsonObject _optJSONObject = this._jsonAdapter.optJSONObject(jsonObj, "sourcePoint");
            Procedures.Procedure1<JsonObject> _function = new Procedures.Procedure1<JsonObject>(){

                public void apply(JsonObject srcPnt) {
                    if (srcPnt != null) {
                        Double _optDouble = JsonImporter.this._jsonAdapter.optDouble(srcPnt, "x");
                        Procedures.Procedure1<Double> _function = new Procedures.Procedure1<Double>(){

                            public void apply(Double it) {
                                section.setStartX(it);
                            }
                        };
                        ObjectExtensions.operator_doubleArrow((Object)_optDouble, (Procedures.Procedure1)_function);
                        Double _optDouble_1 = JsonImporter.this._jsonAdapter.optDouble(srcPnt, "y");
                        Procedures.Procedure1<Double> _function_1 = new Procedures.Procedure1<Double>(){

                            public void apply(Double it) {
                                section.setStartY(it);
                            }
                        };
                        ObjectExtensions.operator_doubleArrow((Object)_optDouble_1, (Procedures.Procedure1)_function_1);
                    }
                }
            };
            ObjectExtensions.operator_doubleArrow((Object)_optJSONObject, (Procedures.Procedure1)_function);
            JsonObject _optJSONObject_1 = this._jsonAdapter.optJSONObject(jsonObj, "targetPoint");
            Procedures.Procedure1<JsonObject> _function_1 = new Procedures.Procedure1<JsonObject>(){

                public void apply(JsonObject tgtPnt) {
                    if (tgtPnt != null) {
                        Double _optDouble = JsonImporter.this._jsonAdapter.optDouble(tgtPnt, "x");
                        Procedures.Procedure1<Double> _function = new Procedures.Procedure1<Double>(){

                            public void apply(Double it) {
                                section.setEndX(it);
                            }
                        };
                        ObjectExtensions.operator_doubleArrow((Object)_optDouble, (Procedures.Procedure1)_function);
                        Double _optDouble_1 = JsonImporter.this._jsonAdapter.optDouble(tgtPnt, "y");
                        Procedures.Procedure1<Double> _function_1 = new Procedures.Procedure1<Double>(){

                            public void apply(Double it) {
                                section.setEndY(it);
                            }
                        };
                        ObjectExtensions.operator_doubleArrow((Object)_optDouble_1, (Procedures.Procedure1)_function_1);
                    }
                }
            };
            ObjectExtensions.operator_doubleArrow((Object)_optJSONObject_1, (Procedures.Procedure1)_function_1);
            JsonArray _optJSONArray = this._jsonAdapter.optJSONArray(jsonObj, "bendPoints");
            Procedures.Procedure1<JsonArray> _function_2 = new Procedures.Procedure1<JsonArray>(){

                public void apply(JsonArray bendPoints) {
                    if (bendPoints != null) {
                        int _sizeJsonArr = JsonImporter.this._jsonAdapter.sizeJsonArr(bendPoints);
                        ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _sizeJsonArr, true);
                        for (Integer i : _doubleDotLessThan) {
                            JsonObject _optJSONObject = JsonImporter.this._jsonAdapter.optJSONObject(bendPoints, i);
                            Procedures.Procedure1<JsonObject> _function = new Procedures.Procedure1<JsonObject>(){

                                public void apply(JsonObject bendPoint) {
                                    ElkGraphUtil.createBendPoint(section, JsonImporter.this._jsonAdapter.optDouble(bendPoint, "x"), JsonImporter.this._jsonAdapter.optDouble(bendPoint, "y"));
                                }
                            };
                            ObjectExtensions.operator_doubleArrow((Object)_optJSONObject, (Procedures.Procedure1)_function);
                        }
                    }
                }
            };
            _xifexpression = _xblockexpression_1 = (JsonArray)ObjectExtensions.operator_doubleArrow((Object)_optJSONArray, (Procedures.Procedure1)_function_2);
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private JsonArray transformEdge(Object jsonObjA, ElkNode parent) {
        JsonArray _xblockexpression = null;
        JsonObject jsonObj = this._jsonAdapter.toJsonObject(jsonObjA);
        final ElkEdge edge = this.register(ElkGraphUtil.createEdge(parent), (Object)jsonObj);
        edge.setIdentifier(this._jsonAdapter.getIdSave(jsonObj));
        JsonArray _optJSONArray = this._jsonAdapter.optJSONArray(jsonObj, "sources");
        Procedures.Procedure1<JsonArray> _function = new Procedures.Procedure1<JsonArray>(){

            public void apply(JsonArray sources) {
                if (sources != null) {
                    int _sizeJsonArr = JsonImporter.this._jsonAdapter.sizeJsonArr(sources);
                    ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _sizeJsonArr, true);
                    for (Integer i : _doubleDotLessThan) {
                        ElkConnectableShape sourceElement = JsonImporter.this.shapeById(JsonImporter.this._jsonAdapter.asId(JsonImporter.this._jsonAdapter.getJsonArr(sources, i)));
                        if (sourceElement == null) continue;
                        EList<ElkConnectableShape> _sources = edge.getSources();
                        _sources.add(sourceElement);
                    }
                }
            }
        };
        ObjectExtensions.operator_doubleArrow((Object)_optJSONArray, (Procedures.Procedure1)_function);
        JsonArray _optJSONArray_1 = this._jsonAdapter.optJSONArray(jsonObj, "targets");
        Procedures.Procedure1<JsonArray> _function_1 = new Procedures.Procedure1<JsonArray>(){

            public void apply(JsonArray targets) {
                if (targets != null) {
                    int _sizeJsonArr = JsonImporter.this._jsonAdapter.sizeJsonArr(targets);
                    ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _sizeJsonArr, true);
                    for (Integer i : _doubleDotLessThan) {
                        ElkConnectableShape targetElement = JsonImporter.this.shapeById(JsonImporter.this._jsonAdapter.asId(JsonImporter.this._jsonAdapter.getJsonArr(targets, i)));
                        if (targetElement == null) continue;
                        EList<ElkConnectableShape> _targets = edge.getTargets();
                        _targets.add(targetElement);
                    }
                }
            }
        };
        ObjectExtensions.operator_doubleArrow((Object)_optJSONArray_1, (Procedures.Procedure1)_function_1);
        if (edge.getSources().isEmpty() || edge.getTargets().isEmpty()) {
            String _idSave = this._jsonAdapter.getIdSave(jsonObj);
            String _plus = "An edge must have at least one source and one target (edge id: '" + _idSave;
            String _plus_1 = String.valueOf(_plus) + "').";
            throw this._jsonAdapter.formatError(_plus_1);
        }
        this.transformProperties(jsonObj, edge);
        this.transformEdgeSections(jsonObj, edge);
        _xblockexpression = this.transformLabels(jsonObj, edge);
        return _xblockexpression;
    }

    private void transformEdgeSections(Object jsonObjA, final ElkEdge edge) {
        ElkEdgeSection section_2;
        JsonObject jsonObj = this._jsonAdapter.toJsonObject(jsonObjA);
        HashMultimap incomingSectionIdentifiers = HashMultimap.create();
        HashMultimap outgoingSectionIdentifiers = HashMultimap.create();
        JsonArray _optJSONArray = this._jsonAdapter.optJSONArray(jsonObj, "sections");
        Procedures.Procedure1<JsonArray> _function = new Procedures.Procedure1<JsonArray>((Multimap)incomingSectionIdentifiers, (Multimap)outgoingSectionIdentifiers){
            private final /* synthetic */ Multimap val$incomingSectionIdentifiers;
            private final /* synthetic */ Multimap val$outgoingSectionIdentifiers;
            {
                this.val$incomingSectionIdentifiers = multimap;
                this.val$outgoingSectionIdentifiers = multimap2;
            }

            public void apply(JsonArray sections) {
                if (sections != null) {
                    int _sizeJsonArr = JsonImporter.this._jsonAdapter.sizeJsonArr(sections);
                    ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _sizeJsonArr, true);
                    for (Integer i : _doubleDotLessThan) {
                        JsonObject _optJSONObject = JsonImporter.this._jsonAdapter.optJSONObject(sections, i);
                        Procedures.Procedure1<JsonObject> _function = new Procedures.Procedure1<JsonObject>(){

                            public void apply(JsonObject jsonSection) {
                                final ElkEdgeSection elkSection = JsonImporter.this.register(ElkGraphUtil.createEdgeSection(edge), jsonSection);
                                elkSection.setIdentifier(JsonImporter.this._jsonAdapter.getIdSave(jsonSection));
                                JsonImporter.this.fillEdgeSectionCoordinates(jsonSection, elkSection);
                                String _optString = JsonImporter.this._jsonAdapter.optString(jsonSection, "incomingShape");
                                Procedures.Procedure1<String> _function = new Procedures.Procedure1<String>(){

                                    public void apply(String jsonShapeId) {
                                        if (jsonShapeId != null) {
                                            elkSection.setIncomingShape(JsonImporter.this.shapeById(jsonShapeId));
                                        }
                                    }
                                };
                                ObjectExtensions.operator_doubleArrow((Object)_optString, (Procedures.Procedure1)_function);
                                String _optString_1 = JsonImporter.this._jsonAdapter.optString(jsonSection, "outgoingShape");
                                Procedures.Procedure1<String> _function_1 = new Procedures.Procedure1<String>(){

                                    public void apply(String jsonShapeId) {
                                        if (jsonShapeId != null) {
                                            elkSection.setOutgoingShape(JsonImporter.this.shapeById(jsonShapeId));
                                        }
                                    }
                                };
                                ObjectExtensions.operator_doubleArrow((Object)_optString_1, (Procedures.Procedure1)_function_1);
                                JsonArray _optJSONArray = JsonImporter.this._jsonAdapter.optJSONArray(jsonSection, "incomingSections");
                                Procedures.Procedure1<JsonArray> _function_2 = new Procedures.Procedure1<JsonArray>(){

                                    public void apply(JsonArray jsonSectionIds) {
                                        if (jsonSectionIds != null) {
                                            int _sizeJsonArr = JsonImporter.this._jsonAdapter.sizeJsonArr(jsonSectionIds);
                                            ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _sizeJsonArr, true);
                                            for (Integer j : _doubleDotLessThan) {
                                                val$incomingSectionIdentifiers.put((Object)elkSection, JsonImporter.this._jsonAdapter.asId(JsonImporter.this._jsonAdapter.getJsonArr(jsonSectionIds, j)));
                                            }
                                        }
                                    }
                                };
                                ObjectExtensions.operator_doubleArrow((Object)_optJSONArray, (Procedures.Procedure1)_function_2);
                                JsonArray _optJSONArray_1 = JsonImporter.this._jsonAdapter.optJSONArray(jsonSection, "outgoingSections");
                                Procedures.Procedure1<JsonArray> _function_3 = new Procedures.Procedure1<JsonArray>(){

                                    public void apply(JsonArray jsonSectionIds) {
                                        if (jsonSectionIds != null) {
                                            int _sizeJsonArr = JsonImporter.this._jsonAdapter.sizeJsonArr(jsonSectionIds);
                                            ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _sizeJsonArr, true);
                                            for (Integer j : _doubleDotLessThan) {
                                                val$outgoingSectionIdentifiers.put((Object)elkSection, JsonImporter.this._jsonAdapter.asId(JsonImporter.this._jsonAdapter.getJsonArr(jsonSectionIds, j)));
                                            }
                                        }
                                    }
                                };
                                ObjectExtensions.operator_doubleArrow((Object)_optJSONArray_1, (Procedures.Procedure1)_function_3);
                            }
                        };
                        ObjectExtensions.operator_doubleArrow((Object)_optJSONObject, (Procedures.Procedure1)_function);
                    }
                }
            }
        };
        ObjectExtensions.operator_doubleArrow((Object)_optJSONArray, (Procedures.Procedure1)_function);
        Set _keySet = incomingSectionIdentifiers.keySet();
        for (ElkEdgeSection section : _keySet) {
            Collection _get = incomingSectionIdentifiers.get((Object)section);
            for (Object id : _get) {
                ElkEdgeSection referencedSection = (ElkEdgeSection)this.edgeSectionIdMap.get(id);
                if (referencedSection != null) {
                    EList<ElkEdgeSection> _incomingSections = section.getIncomingSections();
                    _incomingSections.add(referencedSection);
                    continue;
                }
                String _idSave = this._jsonAdapter.getIdSave(jsonObj);
                String _plus = "Referenced edge section does not exist: " + id + " (edge id: '" + _idSave;
                String _plus_1 = String.valueOf(_plus) + "').";
                throw this._jsonAdapter.formatError(_plus_1);
            }
        }
        Set _keySet_1 = outgoingSectionIdentifiers.keySet();
        for (ElkEdgeSection section_1 : _keySet_1) {
            Collection _get_1 = outgoingSectionIdentifiers.get((Object)section_1);
            for (Object id_1 : _get_1) {
                ElkEdgeSection referencedSection = (ElkEdgeSection)this.edgeSectionIdMap.get(id_1);
                if (referencedSection != null) {
                    EList<ElkEdgeSection> _outgoingSections = section_1.getOutgoingSections();
                    _outgoingSections.add(referencedSection);
                    continue;
                }
                String _idSave = this._jsonAdapter.getIdSave(jsonObj);
                String _plus = "Referenced edge section does not exist: " + id_1 + " (edge id: '" + _idSave;
                String _plus_1 = String.valueOf(_plus) + "').";
                throw this._jsonAdapter.formatError(_plus_1);
            }
        }
        if (edge.isConnected() && !edge.isHyperedge() && edge.getSections().size() == 1 && (section_2 = (ElkEdgeSection)edge.getSections().get(0)).getIncomingShape() == null && section_2.getOutgoingShape() == null) {
            section_2.setIncomingShape((ElkConnectableShape)edge.getSources().get(0));
            section_2.setOutgoingShape((ElkConnectableShape)edge.getTargets().get(0));
        }
    }

    private JsonArray fillEdgeSectionCoordinates(Object jsonObjA, final ElkEdgeSection section) {
        JsonArray _xblockexpression = null;
        JsonObject jsonObj = this._jsonAdapter.toJsonObject(jsonObjA);
        JsonObject _optJSONObject = this._jsonAdapter.optJSONObject(jsonObj, "startPoint");
        Procedures.Procedure1<JsonObject> _function = new Procedures.Procedure1<JsonObject>(){

            public void apply(JsonObject startPoint) {
                if (startPoint == null) {
                    throw JsonImporter.this._jsonAdapter.formatError("All edge sections need a start point.");
                }
                Double _optDouble = JsonImporter.this._jsonAdapter.optDouble(startPoint, "x");
                Procedures.Procedure1<Double> _function = new Procedures.Procedure1<Double>(){

                    public void apply(Double it) {
                        section.setStartX(it);
                    }
                };
                ObjectExtensions.operator_doubleArrow((Object)_optDouble, (Procedures.Procedure1)_function);
                Double _optDouble_1 = JsonImporter.this._jsonAdapter.optDouble(startPoint, "y");
                Procedures.Procedure1<Double> _function_1 = new Procedures.Procedure1<Double>(){

                    public void apply(Double it) {
                        section.setStartY(it);
                    }
                };
                ObjectExtensions.operator_doubleArrow((Object)_optDouble_1, (Procedures.Procedure1)_function_1);
            }
        };
        ObjectExtensions.operator_doubleArrow((Object)_optJSONObject, (Procedures.Procedure1)_function);
        JsonObject _optJSONObject_1 = this._jsonAdapter.optJSONObject(jsonObj, "endPoint");
        Procedures.Procedure1<JsonObject> _function_1 = new Procedures.Procedure1<JsonObject>(){

            public void apply(JsonObject endPoint) {
                if (endPoint == null) {
                    throw JsonImporter.this._jsonAdapter.formatError("All edge sections need an end point.");
                }
                Double _optDouble = JsonImporter.this._jsonAdapter.optDouble(endPoint, "x");
                Procedures.Procedure1<Double> _function = new Procedures.Procedure1<Double>(){

                    public void apply(Double it) {
                        section.setEndX(it);
                    }
                };
                ObjectExtensions.operator_doubleArrow((Object)_optDouble, (Procedures.Procedure1)_function);
                Double _optDouble_1 = JsonImporter.this._jsonAdapter.optDouble(endPoint, "y");
                Procedures.Procedure1<Double> _function_1 = new Procedures.Procedure1<Double>(){

                    public void apply(Double it) {
                        section.setEndY(it);
                    }
                };
                ObjectExtensions.operator_doubleArrow((Object)_optDouble_1, (Procedures.Procedure1)_function_1);
            }
        };
        ObjectExtensions.operator_doubleArrow((Object)_optJSONObject_1, (Procedures.Procedure1)_function_1);
        JsonArray _optJSONArray = this._jsonAdapter.optJSONArray(jsonObj, "bendPoints");
        Procedures.Procedure1<JsonArray> _function_2 = new Procedures.Procedure1<JsonArray>(){

            public void apply(JsonArray bendPoints) {
                if (bendPoints != null) {
                    int _sizeJsonArr = JsonImporter.this._jsonAdapter.sizeJsonArr(bendPoints);
                    ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _sizeJsonArr, true);
                    for (Integer i : _doubleDotLessThan) {
                        JsonObject _optJSONObject = JsonImporter.this._jsonAdapter.optJSONObject(bendPoints, i);
                        Procedures.Procedure1<JsonObject> _function = new Procedures.Procedure1<JsonObject>(){

                            public void apply(JsonObject bendPoint) {
                                ElkGraphUtil.createBendPoint(section, JsonImporter.this._jsonAdapter.optDouble(bendPoint, "x"), JsonImporter.this._jsonAdapter.optDouble(bendPoint, "y"));
                            }
                        };
                        ObjectExtensions.operator_doubleArrow((Object)_optJSONObject, (Procedures.Procedure1)_function);
                    }
                }
            }
        };
        _xblockexpression = (JsonArray)ObjectExtensions.operator_doubleArrow((Object)_optJSONArray, (Procedures.Procedure1)_function_2);
        return _xblockexpression;
    }

    private void transformProperties(Object jsonObjA, final IPropertyHolder layoutData) {
        JsonObject jsonObj = this._jsonAdapter.toJsonObject(jsonObjA);
        JsonObject layoutOptions = this._jsonAdapter.optJSONObject(jsonObj, "layoutOptions");
        if (layoutOptions == null) {
            layoutOptions = this._jsonAdapter.optJSONObject(jsonObj, "properties");
        }
        if (layoutOptions != null) {
            final JsonObject opts = layoutOptions;
            Iterable<String> _keysJsonObj = null;
            if (opts != null) {
                _keysJsonObj = this._jsonAdapter.keysJsonObj(opts);
            }
            if (_keysJsonObj != null) {
                Consumer<String> _function = new Consumer<String>(){

                    @Override
                    public void accept(String k) {
                        JsonElement _jsonObj = JsonImporter.this._jsonAdapter.getJsonObj(opts, k);
                        String _stringVal = null;
                        if (_jsonObj != null) {
                            _stringVal = JsonImporter.this._jsonAdapter.stringVal(_jsonObj);
                        }
                        String value = _stringVal;
                        JsonImporter.this.setOption(layoutData, k, value);
                    }
                };
                _keysJsonObj.forEach(_function);
            }
        }
    }

    private void transformIndividualSpacings(Object jsonObjA, IPropertyHolder layoutData) {
        JsonObject jsonObj = this._jsonAdapter.toJsonObject(jsonObjA);
        JsonObject jsonIndividualSpacings = this._jsonAdapter.optJSONObject(jsonObj, "individualSpacings");
        if (jsonIndividualSpacings != null) {
            boolean _not;
            boolean _hasProperty = layoutData.hasProperty(CoreOptions.SPACING_INDIVIDUAL);
            boolean bl = _not = !_hasProperty;
            if (_not) {
                IndividualSpacings _individualSpacings = new IndividualSpacings();
                layoutData.setProperty(CoreOptions.SPACING_INDIVIDUAL, _individualSpacings);
            }
            final IndividualSpacings individualSpacings = layoutData.getProperty(CoreOptions.SPACING_INDIVIDUAL);
            final JsonObject opts = jsonIndividualSpacings;
            Iterable<String> _keysJsonObj = null;
            if (opts != null) {
                _keysJsonObj = this._jsonAdapter.keysJsonObj(opts);
            }
            if (_keysJsonObj != null) {
                Consumer<String> _function = new Consumer<String>(){

                    @Override
                    public void accept(String k) {
                        JsonElement _jsonObj = JsonImporter.this._jsonAdapter.getJsonObj(opts, k);
                        String _stringVal = null;
                        if (_jsonObj != null) {
                            _stringVal = JsonImporter.this._jsonAdapter.stringVal(_jsonObj);
                        }
                        String value = _stringVal;
                        JsonImporter.this.setOption(individualSpacings, k, value);
                    }
                };
                _keysJsonObj.forEach(_function);
            }
        }
    }

    private IPropertyHolder setOption(IPropertyHolder e, String id, String value) {
        IPropertyHolder _xblockexpression = null;
        LayoutOptionData optionData = LayoutMetaDataService.getInstance().getOptionDataBySuffix(id);
        IPropertyHolder _xifexpression = null;
        if (optionData != null) {
            IPropertyHolder _xblockexpression_1 = null;
            Object parsed = optionData.parseValue(value);
            IPropertyHolder _xifexpression_1 = null;
            if (parsed != null) {
                _xifexpression_1 = e.setProperty(optionData, parsed);
            }
            _xifexpression = _xblockexpression_1 = _xifexpression_1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private JsonArray transformLabels(Object jsonObjA, final ElkGraphElement element) {
        JsonArray _xblockexpression = null;
        JsonObject jsonObj = this._jsonAdapter.toJsonObject(jsonObjA);
        JsonArray _optJSONArray = this._jsonAdapter.optJSONArray(jsonObj, "labels");
        Procedures.Procedure1<JsonArray> _function = new Procedures.Procedure1<JsonArray>(){

            public void apply(JsonArray labels) {
                if (labels != null) {
                    int _sizeJsonArr = JsonImporter.this._jsonAdapter.sizeJsonArr(labels);
                    ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _sizeJsonArr, true);
                    for (Integer i : _doubleDotLessThan) {
                        JsonObject jsonLabel = JsonImporter.this._jsonAdapter.optJSONObject(labels, i);
                        if (jsonLabel == null) continue;
                        ElkLabel label = ElkGraphUtil.createLabel(JsonImporter.this._jsonAdapter.optString(jsonLabel, "text"), element);
                        JsonImporter.this.labelJsonMap.put(label, jsonLabel);
                        boolean _hasJsonObj = JsonImporter.this._jsonAdapter.hasJsonObj(jsonLabel, "id");
                        if (_hasJsonObj) {
                            label.setIdentifier(JsonImporter.this._jsonAdapter.getIdSave(jsonLabel));
                        }
                        JsonImporter.this.transformProperties(jsonLabel, label);
                        JsonImporter.this.transformShapeLayout(jsonLabel, label);
                    }
                }
            }
        };
        _xblockexpression = (JsonArray)ObjectExtensions.operator_doubleArrow((Object)_optJSONArray, (Procedures.Procedure1)_function);
        return _xblockexpression;
    }

    private JsonArray transformPorts(Object jsonObjA, final ElkNode parent) {
        JsonArray _xblockexpression = null;
        JsonObject jsonObj = this._jsonAdapter.toJsonObject(jsonObjA);
        JsonArray _optJSONArray = this._jsonAdapter.optJSONArray(jsonObj, "ports");
        Procedures.Procedure1<JsonArray> _function = new Procedures.Procedure1<JsonArray>(){

            public void apply(JsonArray ports) {
                if (ports != null) {
                    int _sizeJsonArr = JsonImporter.this._jsonAdapter.sizeJsonArr(ports);
                    ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _sizeJsonArr, true);
                    for (Integer i : _doubleDotLessThan) {
                        JsonObject _optJSONObject = JsonImporter.this._jsonAdapter.optJSONObject(ports, i);
                        if (_optJSONObject == null) continue;
                        JsonImporter.this.transformPort(_optJSONObject, parent);
                    }
                }
            }
        };
        _xblockexpression = (JsonArray)ObjectExtensions.operator_doubleArrow((Object)_optJSONArray, (Procedures.Procedure1)_function);
        return _xblockexpression;
    }

    private JsonArray transformPort(Object jsonPort, ElkNode parent) {
        JsonArray _xblockexpression = null;
        ElkPort port = this.register(ElkGraphUtil.createPort(parent), jsonPort);
        port.setIdentifier(this._jsonAdapter.getIdSave(this._jsonAdapter.toJsonObject(jsonPort)));
        this.transformProperties(jsonPort, port);
        this.transformShapeLayout(jsonPort, port);
        _xblockexpression = this.transformLabels(jsonPort, port);
        return _xblockexpression;
    }

    private Double transformShapeLayout(Object jsonObjA, final ElkShape shape) {
        Double _xblockexpression = null;
        JsonObject jsonObj = this._jsonAdapter.toJsonObject(jsonObjA);
        Double _optDouble = this._jsonAdapter.optDouble(jsonObj, "x");
        Procedures.Procedure1<Double> _function = new Procedures.Procedure1<Double>(){

            public void apply(Double it) {
                shape.setX(JsonImporter.this.doubleValueValid(it));
            }
        };
        ObjectExtensions.operator_doubleArrow((Object)_optDouble, (Procedures.Procedure1)_function);
        Double _optDouble_1 = this._jsonAdapter.optDouble(jsonObj, "y");
        Procedures.Procedure1<Double> _function_1 = new Procedures.Procedure1<Double>(){

            public void apply(Double it) {
                shape.setY(JsonImporter.this.doubleValueValid(it));
            }
        };
        ObjectExtensions.operator_doubleArrow((Object)_optDouble_1, (Procedures.Procedure1)_function_1);
        Double _optDouble_2 = this._jsonAdapter.optDouble(jsonObj, "width");
        Procedures.Procedure1<Double> _function_2 = new Procedures.Procedure1<Double>(){

            public void apply(Double it) {
                shape.setWidth(JsonImporter.this.doubleValueValid(it));
            }
        };
        ObjectExtensions.operator_doubleArrow((Object)_optDouble_2, (Procedures.Procedure1)_function_2);
        Double _optDouble_3 = this._jsonAdapter.optDouble(jsonObj, "height");
        Procedures.Procedure1<Double> _function_3 = new Procedures.Procedure1<Double>(){

            public void apply(Double it) {
                shape.setHeight(JsonImporter.this.doubleValueValid(it));
            }
        };
        _xblockexpression = (Double)ObjectExtensions.operator_doubleArrow((Object)_optDouble_3, (Procedures.Procedure1)_function_3);
        return _xblockexpression;
    }

    private double doubleValueValid(Double d) {
        if (d == null || d.isInfinite() || d.isNaN()) {
            return 0.0;
        }
        return d;
    }

    private ElkConnectableShape shapeById(Object id) {
        ElkNode node = (ElkNode)this.nodeIdMap.get(id);
        if (node != null) {
            return node;
        }
        ElkPort port = (ElkPort)this.portIdMap.get(id);
        if (port != null) {
            return port;
        }
        throw this._jsonAdapter.formatError("Referenced shape does not exist: " + id);
    }

    public void transferLayout(ElkNode graph) {
        Procedures.Procedure1<EObject> _function = new Procedures.Procedure1<EObject>(){

            public void apply(EObject element) {
                JsonImporter.this.transferLayoutInt(element);
            }
        };
        IteratorExtensions.forEach(ElkGraphUtil.propertiesSkippingIteratorFor(graph, true), (Procedures.Procedure1)_function);
    }

    private Object _transferLayoutInt(ElkNode node) {
        Object jsonObj = this.nodeJsonMap.get((Object)node);
        if (jsonObj == null) {
            throw this._jsonAdapter.formatError("Node did not exist in input.");
        }
        this.transferShapeLayout(node, jsonObj);
        return null;
    }

    private Object _transferLayoutInt(ElkPort port) {
        Object jsonObj = this.portJsonMap.get(port);
        if (jsonObj == null) {
            throw this._jsonAdapter.formatError("Port did not exist in input.");
        }
        this.transferShapeLayout(port, jsonObj);
        return null;
    }

    private Object _transferLayoutInt(ElkEdge edge) {
        boolean _hasProperty;
        boolean _not;
        JsonObject jsonObj = this._jsonAdapter.toJsonObject(this.edgeJsonMap.get(edge));
        if (jsonObj == null) {
            throw this._jsonAdapter.formatError("Edge did not exist in input.");
        }
        final Object edgeId = this._jsonAdapter.getId(jsonObj);
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty(edge.getSections());
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            final JsonArray sections = this._jsonAdapter.newJsonArray();
            Procedures.Procedure2<ElkEdgeSection, Integer> _function = new Procedures.Procedure2<ElkEdgeSection, Integer>(){

                public void apply(ElkEdgeSection elkSection, Integer i) {
                    boolean _isEmpty_1;
                    boolean _not_2;
                    boolean _isEmpty;
                    boolean _not_1;
                    ElkConnectableShape _outgoingShape;
                    boolean _tripleNotEquals_1;
                    ElkConnectableShape _incomingShape;
                    boolean _tripleNotEquals;
                    boolean _not;
                    Object maybeSection = JsonImporter.this.edgeSectionJsonMap.get(elkSection);
                    if (maybeSection == null) {
                        maybeSection = JsonImporter.this._jsonAdapter.newJsonObject();
                        JsonObject _jsonObject = JsonImporter.this._jsonAdapter.toJsonObject(maybeSection);
                        String _plus = edgeId + "_s";
                        String _plus_1 = String.valueOf(_plus) + i;
                        JsonImporter.this._jsonAdapter.addJsonObj(_jsonObject, "id", _plus_1);
                    }
                    JsonObject jsonSection = JsonImporter.this._jsonAdapter.toJsonObject(maybeSection);
                    JsonImporter.this._jsonAdapter.addJsonArr(sections, (JsonElement)jsonSection);
                    JsonObject startPoint = JsonImporter.this._jsonAdapter.newJsonObject();
                    JsonImporter.this._jsonAdapter.addJsonObj(startPoint, "x", elkSection.getStartX());
                    JsonImporter.this._jsonAdapter.addJsonObj(startPoint, "y", elkSection.getStartY());
                    JsonImporter.this._jsonAdapter.addJsonObj(jsonSection, "startPoint", (JsonElement)startPoint);
                    JsonObject endPoint = JsonImporter.this._jsonAdapter.newJsonObject();
                    JsonImporter.this._jsonAdapter.addJsonObj(endPoint, "x", elkSection.getEndX());
                    JsonImporter.this._jsonAdapter.addJsonObj(endPoint, "y", elkSection.getEndY());
                    JsonImporter.this._jsonAdapter.addJsonObj(jsonSection, "endPoint", (JsonElement)endPoint);
                    boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty(elkSection.getBendPoints());
                    boolean bl = _not = !_isNullOrEmpty;
                    if (_not) {
                        final JsonArray bendPoints = JsonImporter.this._jsonAdapter.newJsonArray();
                        Consumer<ElkBendPoint> _function = new Consumer<ElkBendPoint>(){

                            @Override
                            public void accept(ElkBendPoint pnt) {
                                JsonObject jsonPnt = JsonImporter.this._jsonAdapter.newJsonObject();
                                JsonImporter.this._jsonAdapter.addJsonObj(jsonPnt, "x", pnt.getX());
                                JsonImporter.this._jsonAdapter.addJsonObj(jsonPnt, "y", pnt.getY());
                                JsonImporter.this._jsonAdapter.addJsonArr(bendPoints, (JsonElement)jsonPnt);
                            }
                        };
                        elkSection.getBendPoints().forEach(_function);
                        JsonImporter.this._jsonAdapter.addJsonObj(jsonSection, "bendPoints", (JsonElement)bendPoints);
                    }
                    boolean bl2 = _tripleNotEquals = (_incomingShape = elkSection.getIncomingShape()) != null;
                    if (_tripleNotEquals) {
                        JsonImporter.this._jsonAdapter.addJsonObj(jsonSection, "incomingShape", JsonImporter.this.idByElement(elkSection.getIncomingShape()));
                    }
                    boolean bl3 = _tripleNotEquals_1 = (_outgoingShape = elkSection.getOutgoingShape()) != null;
                    if (_tripleNotEquals_1) {
                        JsonImporter.this._jsonAdapter.addJsonObj(jsonSection, "outgoingShape", JsonImporter.this.idByElement(elkSection.getOutgoingShape()));
                    }
                    boolean bl4 = _not_1 = !(_isEmpty = elkSection.getIncomingSections().isEmpty());
                    if (_not_1) {
                        final JsonArray incomingSections = JsonImporter.this._jsonAdapter.newJsonArray();
                        Consumer<ElkEdgeSection> _function_1 = new Consumer<ElkEdgeSection>(){

                            @Override
                            public void accept(ElkEdgeSection sec) {
                                JsonImporter.this._jsonAdapter.addJsonArr(incomingSections, JsonImporter.this.idByElement(sec));
                            }
                        };
                        elkSection.getIncomingSections().forEach(_function_1);
                        JsonImporter.this._jsonAdapter.addJsonObj(jsonSection, "incomingSections", (JsonElement)incomingSections);
                    }
                    boolean bl5 = _not_2 = !(_isEmpty_1 = elkSection.getOutgoingSections().isEmpty());
                    if (_not_2) {
                        final JsonArray outgoingSections = JsonImporter.this._jsonAdapter.newJsonArray();
                        Consumer<ElkEdgeSection> _function_2 = new Consumer<ElkEdgeSection>(){

                            @Override
                            public void accept(ElkEdgeSection sec) {
                                JsonImporter.this._jsonAdapter.addJsonArr(outgoingSections, JsonImporter.this.idByElement(sec));
                            }
                        };
                        elkSection.getOutgoingSections().forEach(_function_2);
                        JsonImporter.this._jsonAdapter.addJsonObj(jsonSection, "outgoingSections", (JsonElement)outgoingSections);
                    }
                }
            };
            IterableExtensions.forEach(edge.getSections(), (Procedures.Procedure2)_function);
            this._jsonAdapter.addJsonObj(jsonObj, "sections", (JsonElement)sections);
        }
        if (_hasProperty = edge.hasProperty(CoreOptions.JUNCTION_POINTS)) {
            boolean _not_1;
            KVectorChain jps = edge.getProperty(CoreOptions.JUNCTION_POINTS);
            boolean _isNullOrEmpty_1 = IterableExtensions.isNullOrEmpty((Iterable)jps);
            boolean bl2 = _not_1 = !_isNullOrEmpty_1;
            if (_not_1) {
                final JsonArray jsonJPs = this._jsonAdapter.newJsonArray();
                Consumer<KVector> _function_1 = new Consumer<KVector>(){

                    @Override
                    public void accept(KVector jp) {
                        JsonObject jsonPnt = JsonImporter.this._jsonAdapter.newJsonObject();
                        JsonImporter.this._jsonAdapter.addJsonObj(jsonPnt, "x", jp.x);
                        JsonImporter.this._jsonAdapter.addJsonObj(jsonPnt, "y", jp.y);
                        JsonImporter.this._jsonAdapter.addJsonArr(jsonJPs, (JsonElement)jsonPnt);
                    }
                };
                jps.forEach(_function_1);
                this._jsonAdapter.addJsonObj(jsonObj, "junctionPoints", (JsonElement)jsonJPs);
            }
        }
        this._jsonAdapter.addJsonObj(jsonObj, "container", edge.getContainingNode().getIdentifier());
        return null;
    }

    private Object _transferLayoutInt(ElkLabel label) {
        Object jsonObj = this.labelJsonMap.get(label);
        this.transferShapeLayout(label, jsonObj);
        return null;
    }

    private Object _transferLayoutInt(Object obj) {
        return null;
    }

    private void transferShapeLayout(ElkShape shape, Object jsonObjA) {
        JsonObject jsonObj = this._jsonAdapter.toJsonObject(jsonObjA);
        this._jsonAdapter.addJsonObj(jsonObj, "x", shape.getX());
        this._jsonAdapter.addJsonObj(jsonObj, "y", shape.getY());
        this._jsonAdapter.addJsonObj(jsonObj, "width", shape.getWidth());
        this._jsonAdapter.addJsonObj(jsonObj, "height", shape.getHeight());
    }

    private Object _idByElement(ElkNode node) {
        return this.nodeIdMap.inverse().get((Object)node);
    }

    private Object _idByElement(ElkPort port) {
        return this.portIdMap.inverse().get((Object)port);
    }

    private Object _idByElement(ElkEdgeSection section) {
        return this.edgeSectionIdMap.inverse().get((Object)section);
    }

    private ElkNode register(ElkNode node, Object obj) {
        Object id = this._jsonAdapter.getId(this._jsonAdapter.toJsonObject(obj));
        this.nodeIdMap.put(id, (Object)node);
        this.nodeJsonMap.put((Object)node, obj);
        return node;
    }

    private ElkPort register(ElkPort port, Object obj) {
        Object id = this._jsonAdapter.getId(this._jsonAdapter.toJsonObject(obj));
        this.portIdMap.put(id, (Object)port);
        this.portJsonMap.put(port, obj);
        return port;
    }

    private ElkEdge register(ElkEdge edge, Object obj) {
        Object id = this._jsonAdapter.getId(this._jsonAdapter.toJsonObject(obj));
        this.edgeIdMap.put(id, edge);
        this.edgeJsonMap.put(edge, obj);
        return edge;
    }

    private ElkEdgeSection register(ElkEdgeSection edgeSection, Object obj) {
        Object id = this._jsonAdapter.getId(this._jsonAdapter.toJsonObject(obj));
        this.edgeSectionIdMap.put(id, (Object)edgeSection);
        this.edgeSectionJsonMap.put(edgeSection, obj);
        return edgeSection;
    }

    private Object transferLayoutInt(Object node) {
        if (node instanceof ElkNode) {
            return this._transferLayoutInt((ElkNode)node);
        }
        if (node instanceof ElkPort) {
            return this._transferLayoutInt((ElkPort)node);
        }
        if (node instanceof ElkLabel) {
            return this._transferLayoutInt((ElkLabel)node);
        }
        if (node instanceof ElkEdge) {
            return this._transferLayoutInt((ElkEdge)node);
        }
        if (node != null) {
            return this._transferLayoutInt(node);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(node).toString());
    }

    private Object idByElement(EMapPropertyHolder node) {
        if (node instanceof ElkNode) {
            return this._idByElement((ElkNode)node);
        }
        if (node instanceof ElkPort) {
            return this._idByElement((ElkPort)node);
        }
        if (node instanceof ElkEdgeSection) {
            return this._idByElement((ElkEdgeSection)node);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(node).toString());
    }
}

