/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.graph.impl;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.modelengineers.MoRe_elk.graph.ElkConnectableShape;
import com.modelengineers.MoRe_elk.graph.ElkEdge;
import com.modelengineers.MoRe_elk.graph.ElkEdgeSection;
import com.modelengineers.MoRe_elk.graph.ElkGraphPackage;
import com.modelengineers.MoRe_elk.graph.ElkLabel;
import com.modelengineers.MoRe_elk.graph.ElkNode;
import com.modelengineers.MoRe_elk.graph.ElkPort;
import com.modelengineers.MoRe_elk.graph.impl.ElkGraphElementImpl;
import com.modelengineers.MoRe_elk.graph.util.ElkGraphUtil;
import com.modelengineers.MoRe_emf.common.notify.NotificationChain;
import com.modelengineers.MoRe_emf.common.util.EList;
import com.modelengineers.MoRe_emf.ecore.EClass;
import com.modelengineers.MoRe_emf.ecore.EObject;
import com.modelengineers.MoRe_emf.ecore.InternalEObject;
import com.modelengineers.MoRe_emf.ecore.impl.ENotificationImpl;
import com.modelengineers.MoRe_emf.ecore.util.EObjectContainmentWithInverseEList;
import com.modelengineers.MoRe_emf.ecore.util.EObjectWithInverseResolvingEList;
import com.modelengineers.MoRe_emf.ecore.util.EcoreUtil;
import com.modelengineers.MoRe_emf.ecore.util.InternalEList;
import java.util.Collection;

public class ElkEdgeImpl
extends ElkGraphElementImpl
implements ElkEdge {
    protected EList<ElkConnectableShape> sources;
    protected EList<ElkConnectableShape> targets;
    protected EList<ElkEdgeSection> sections;
    protected static final boolean HYPEREDGE_EDEFAULT = false;
    protected static final boolean HIERARCHICAL_EDEFAULT = false;
    protected static final boolean SELFLOOP_EDEFAULT = false;
    protected static final boolean CONNECTED_EDEFAULT = false;

    protected ElkEdgeImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return ElkGraphPackage.Literals.ELK_EDGE;
    }

    @Override
    public ElkNode getContainingNode() {
        if (this.eContainerFeatureID() != 3) {
            return null;
        }
        return (ElkNode)((Object)this.eInternalContainer());
    }

    public NotificationChain basicSetContainingNode(ElkNode newContainingNode, NotificationChain msgs) {
        msgs = this.eBasicSetContainer((InternalEObject)((Object)newContainingNode), 3, msgs);
        return msgs;
    }

    @Override
    public void setContainingNode(ElkNode newContainingNode) {
        if (newContainingNode != this.eInternalContainer() || this.eContainerFeatureID() != 3 && newContainingNode != null) {
            if (EcoreUtil.isAncestor(this, (EObject)newContainingNode)) {
                throw new IllegalArgumentException("Recursive containment not allowed for " + this.toString());
            }
            NotificationChain msgs = null;
            if (this.eInternalContainer() != null) {
                msgs = this.eBasicRemoveFromContainer(msgs);
            }
            if (newContainingNode != null) {
                msgs = ((InternalEObject)((Object)newContainingNode)).eInverseAdd(this, 12, ElkNode.class, msgs);
            }
            if ((msgs = this.basicSetContainingNode(newContainingNode, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 3, (Object)newContainingNode, (Object)newContainingNode));
        }
    }

    @Override
    public EList<ElkConnectableShape> getSources() {
        if (this.sources == null) {
            this.sources = new EObjectWithInverseResolvingEList.ManyInverse<ElkConnectableShape>(ElkConnectableShape.class, this, 4, 7);
        }
        return this.sources;
    }

    @Override
    public EList<ElkConnectableShape> getTargets() {
        if (this.targets == null) {
            this.targets = new EObjectWithInverseResolvingEList.ManyInverse<ElkConnectableShape>(ElkConnectableShape.class, this, 5, 8);
        }
        return this.targets;
    }

    @Override
    public EList<ElkEdgeSection> getSections() {
        if (this.sections == null) {
            this.sections = new EObjectContainmentWithInverseEList<ElkEdgeSection>(ElkEdgeSection.class, this, 6, 6);
        }
        return this.sections;
    }

    @Override
    public boolean isHyperedge() {
        return this.getSources().size() > 1 || this.getTargets().size() > 1;
    }

    @Override
    public boolean isHierarchical() {
        ElkNode commonRepresentingNode = null;
        for (ElkConnectableShape incidentShape : ElkGraphUtil.allIncidentShapes(this)) {
            ElkNode shapeNode = ElkGraphUtil.connectableShapeToNode(incidentShape);
            if (commonRepresentingNode == null) {
                commonRepresentingNode = shapeNode.getParent();
                continue;
            }
            if (commonRepresentingNode == shapeNode.getParent()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSelfloop() {
        ElkNode commonNode = null;
        for (ElkConnectableShape incidentShape : ElkGraphUtil.allIncidentShapes(this)) {
            ElkNode shapeNode = ElkGraphUtil.connectableShapeToNode(incidentShape);
            if (commonNode == null) {
                commonNode = shapeNode;
                continue;
            }
            if (commonNode == shapeNode) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isConnected() {
        return !this.getSources().isEmpty() && !this.getTargets().isEmpty();
    }

    @Override
    public boolean isSplit() {
        return ElkGraphUtil.getSourcePort(this).getOutgoingEdges().size() > 1;
    }

    @Override
    public boolean hasSameSourceAndTargetNodeAs(ElkEdge edge) {
        return ElkGraphUtil.getSourceNode(this).equals(ElkGraphUtil.getSourceNode(edge)) && ElkGraphUtil.getTargetNode(this).equals(ElkGraphUtil.getTargetNode(edge));
    }

    @Override
    public ElkPort getPort(boolean forward) {
        return forward ? ElkGraphUtil.getTargetPort(this) : ElkGraphUtil.getSourcePort(this);
    }

    @Override
    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 3: {
                if (this.eInternalContainer() != null) {
                    msgs = this.eBasicRemoveFromContainer(msgs);
                }
                return this.basicSetContainingNode((ElkNode)((Object)otherEnd), msgs);
            }
            case 4: {
                return ((InternalEList)this.getSources()).basicAdd(otherEnd, msgs);
            }
            case 5: {
                return ((InternalEList)this.getTargets()).basicAdd(otherEnd, msgs);
            }
            case 6: {
                return ((InternalEList)this.getSections()).basicAdd(otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 3: {
                return this.basicSetContainingNode(null, msgs);
            }
            case 4: {
                return ((InternalEList)this.getSources()).basicRemove(otherEnd, msgs);
            }
            case 5: {
                return ((InternalEList)this.getTargets()).basicRemove(otherEnd, msgs);
            }
            case 6: {
                return ((InternalEList)this.getSections()).basicRemove(otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
        switch (this.eContainerFeatureID()) {
            case 3: {
                return this.eInternalContainer().eInverseRemove(this, 12, ElkNode.class, msgs);
            }
        }
        return super.eBasicRemoveFromContainerFeature(msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 3: {
                return this.getContainingNode();
            }
            case 4: {
                return this.getSources();
            }
            case 5: {
                return this.getTargets();
            }
            case 6: {
                return this.getSections();
            }
            case 7: {
                return this.isHyperedge();
            }
            case 8: {
                return this.isHierarchical();
            }
            case 9: {
                return this.isSelfloop();
            }
            case 10: {
                return this.isConnected();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 3: {
                this.setContainingNode((ElkNode)newValue);
                return;
            }
            case 4: {
                this.getSources().clear();
                this.getSources().addAll((Collection)newValue);
                return;
            }
            case 5: {
                this.getTargets().clear();
                this.getTargets().addAll((Collection)newValue);
                return;
            }
            case 6: {
                this.getSections().clear();
                this.getSections().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 3: {
                this.setContainingNode(null);
                return;
            }
            case 4: {
                this.getSources().clear();
                return;
            }
            case 5: {
                this.getTargets().clear();
                return;
            }
            case 6: {
                this.getSections().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 3: {
                return this.getContainingNode() != null;
            }
            case 4: {
                return this.sources != null && !this.sources.isEmpty();
            }
            case 5: {
                return this.targets != null && !this.targets.isEmpty();
            }
            case 6: {
                return this.sections != null && !this.sections.isEmpty();
            }
            case 7: {
                return this.isHyperedge();
            }
            case 8: {
                return this.isHierarchical();
            }
            case 9: {
                return this.isSelfloop();
            }
            case 10: {
                return this.isConnected();
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        String text;
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuilder builder = new StringBuilder("ElkEdge");
        String id = this.getIdentifier();
        if (!Strings.isNullOrEmpty((String)id)) {
            builder.append(" \"").append(id).append("\"");
        } else if (this.getLabels().size() > 0 && !Strings.isNullOrEmpty((String)(text = ((ElkLabel)this.getLabels().get(0)).getText()))) {
            builder.append(" \"").append(text).append("\"");
        }
        boolean hyperedge = this.isHyperedge();
        if (hyperedge) {
            builder.append(" [");
        } else {
            builder.append(" ");
        }
        builder.append(Joiner.on((String)", ").join(this.sources));
        if (hyperedge) {
            builder.append("]");
        }
        builder.append(" -> ");
        if (hyperedge) {
            builder.append("[");
        }
        builder.append(Joiner.on((String)", ").join(this.targets));
        if (hyperedge) {
            builder.append("]");
        }
        return builder.toString();
    }
}

