/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.core.validation;

import com.modelengineers.MoRe_elk.core.data.LayoutAlgorithmData;
import com.modelengineers.MoRe_elk.core.options.CoreOptions;
import com.modelengineers.MoRe_elk.core.util.ElkUtil;
import com.modelengineers.MoRe_elk.core.validation.GraphIssue;
import com.modelengineers.MoRe_elk.core.validation.IValidatingGraphElementVisitor;
import com.modelengineers.MoRe_elk.graph.ElkConnectableShape;
import com.modelengineers.MoRe_elk.graph.ElkEdge;
import com.modelengineers.MoRe_elk.graph.ElkEdgeSection;
import com.modelengineers.MoRe_elk.graph.ElkGraphElement;
import com.modelengineers.MoRe_elk.graph.ElkNode;
import com.modelengineers.MoRe_elk.graph.util.ElkGraphUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GraphValidator
implements IValidatingGraphElementVisitor {
    private final List<GraphIssue> issues = new ArrayList<GraphIssue>();
    private final Map<LayoutAlgorithmData, IValidatingGraphElementVisitor> algorithmSpecificValidators = new HashMap<LayoutAlgorithmData, IValidatingGraphElementVisitor>();

    @Override
    public void visit(ElkGraphElement element) {
        ElkNode parent;
        if (element instanceof ElkEdge) {
            this.checkEdge((ElkEdge)element);
        }
        if ((parent = ElkGraphUtil.containingGraph(element)) != null) {
            this.runAlgorithmSpecificChecks(element, parent);
        }
        if (element instanceof ElkNode && (parent == null || parent.getProperty(CoreOptions.RESOLVED_ALGORITHM) != element.getProperty(CoreOptions.RESOLVED_ALGORITHM))) {
            this.runAlgorithmSpecificChecks(element, (ElkNode)element);
        }
    }

    protected void checkEdge(ElkEdge edge) {
        if (!edge.isConnected()) {
            this.issues.add(new GraphIssue(edge, "Edge is not connected.", GraphIssue.Severity.ERROR));
        } else {
            ElkNode bestContainer = ElkGraphUtil.findBestEdgeContainment(edge);
            if (bestContainer != null && bestContainer != edge.getContainingNode()) {
                StringBuilder message = new StringBuilder("Edge should be contained in ");
                ElkUtil.printElementPath(bestContainer, message);
                this.issues.add(new GraphIssue(edge, message.toString(), GraphIssue.Severity.WARNING));
            }
        }
        for (ElkEdgeSection edgeSection : edge.getSections()) {
            String message;
            ElkConnectableShape outgoingShape;
            ElkConnectableShape incomingShape = edgeSection.getIncomingShape();
            if (incomingShape != null) {
                String message2;
                if (!edge.getSources().contains(incomingShape)) {
                    message2 = String.valueOf(incomingShape.eClass().getName()) + " declared as incoming shape is not a source of this edge.";
                    this.issues.add(new GraphIssue(edge, message2, GraphIssue.Severity.ERROR));
                }
                if (!edgeSection.getIncomingSections().isEmpty()) {
                    message2 = "An edge section cannot be connected to an " + incomingShape.eClass().getName() + " and other sections at the same time.";
                    this.issues.add(new GraphIssue(edge, message2, GraphIssue.Severity.ERROR));
                }
            }
            if ((outgoingShape = edgeSection.getOutgoingShape()) == null) continue;
            if (!edge.getTargets().contains(outgoingShape)) {
                message = String.valueOf(outgoingShape.eClass().getName()) + " declared as outgoing shape is not a target of this edge.";
                this.issues.add(new GraphIssue(edge, message, GraphIssue.Severity.ERROR));
            }
            if (edgeSection.getOutgoingSections().isEmpty()) continue;
            message = "An edge section cannot be connected to an " + outgoingShape.eClass().getName() + " and other sections at the same time.";
            this.issues.add(new GraphIssue(edge, message, GraphIssue.Severity.ERROR));
        }
    }

    protected void runAlgorithmSpecificChecks(ElkGraphElement element, ElkNode parent) {
        IValidatingGraphElementVisitor validator;
        LayoutAlgorithmData algoData = parent.getProperty(CoreOptions.RESOLVED_ALGORITHM);
        if (algoData != null && (validator = this.getValidator(algoData)) != null) {
            validator.visit(element);
        }
    }

    protected IValidatingGraphElementVisitor getValidator(LayoutAlgorithmData algoData) {
        IValidatingGraphElementVisitor validator = this.algorithmSpecificValidators.get(algoData);
        if (validator != null) {
            return validator;
        }
        Class<? extends IValidatingGraphElementVisitor> validatorClass = algoData.getValidatorClass();
        if (validatorClass == null) {
            return null;
        }
        try {
            validator = validatorClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            this.algorithmSpecificValidators.put(algoData, validator);
            return validator;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            throw new RuntimeException("Failed to instantiate validator for " + algoData.getId(), ex);
        }
    }

    public List<GraphIssue> getIssues() {
        if (this.algorithmSpecificValidators.isEmpty()) {
            return this.issues;
        }
        ArrayList<GraphIssue> result = new ArrayList<GraphIssue>();
        result.addAll(this.issues);
        for (IValidatingGraphElementVisitor validator : this.algorithmSpecificValidators.values()) {
            result.addAll(validator.getIssues());
        }
        return result;
    }
}

