/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.core.validation;

import com.modelengineers.MoRe_elk.core.util.ElkUtil;
import com.modelengineers.MoRe_elk.graph.ElkGraphElement;

public class GraphIssue {
    private final ElkGraphElement element;
    private final String message;
    private final Severity severity;

    public GraphIssue(ElkGraphElement element, String message, Severity severity) {
        if (message == null || severity == null) {
            throw new NullPointerException();
        }
        this.element = element;
        this.message = message;
        this.severity = severity;
    }

    public ElkGraphElement getElement() {
        return this.element;
    }

    public String getMessage() {
        return this.message;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public boolean equals(Object obj) {
        if (obj instanceof GraphIssue) {
            GraphIssue other = (GraphIssue)obj;
            return this.element == other.element && this.message.equals(other.message) && this.severity == other.severity;
        }
        return false;
    }

    public int hashCode() {
        return this.element.hashCode() ^ this.message.hashCode() ^ this.severity.hashCode();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append((Object)this.severity).append(": ").append(this.message).append(" (");
        ElkUtil.printElementPath(this.element, result);
        result.append(")");
        return result.toString();
    }

    public static enum Severity {
        ERROR("Error"),
        WARNING("Warning");

        private final String userString;

        private Severity(String userString) {
            this.userString = userString;
        }

        public String getUserString() {
            return this.userString;
        }
    }
}

