/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.core.util.selection;

import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import com.modelengineers.MoRe_elk.core.util.selection.SelectionIterator;
import com.modelengineers.MoRe_elk.graph.ElkConnectableShape;
import com.modelengineers.MoRe_elk.graph.ElkEdge;
import com.modelengineers.MoRe_elk.graph.ElkGraphElement;
import com.modelengineers.MoRe_elk.graph.ElkPort;
import java.util.Collections;
import java.util.Iterator;

public class DefaultSelectionIterator
extends SelectionIterator {
    private static final long serialVersionUID = 2945508835051993888L;
    private boolean addPorts;
    private boolean followEdgeDirection;

    public DefaultSelectionIterator(ElkEdge edge, boolean addPorts, boolean followEdgeDirection) {
        super(edge);
        this.addPorts = addPorts;
        this.followEdgeDirection = followEdgeDirection;
    }

    @Override
    protected Iterator<? extends ElkGraphElement> getChildren(Object object) {
        if (this.visited == null) {
            this.visited = Sets.newHashSet();
        }
        if (object instanceof ElkEdge) {
            ElkConnectableShape connectedShape;
            ElkEdge edge = (ElkEdge)object;
            ElkConnectableShape elkConnectableShape = connectedShape = this.followEdgeDirection ? (ElkConnectableShape)edge.getTargets().get(0) : (ElkConnectableShape)edge.getSources().get(0);
            if (!(connectedShape instanceof ElkPort) || this.visited.contains((ElkPort)connectedShape)) {
                return Collections.emptyIterator();
            }
            ElkPort port = (ElkPort)connectedShape;
            this.visited.add(port);
            Iterator resultEdges = (this.followEdgeDirection ? port.getOutgoingEdges() : port.getIncomingEdges()).iterator();
            if (this.addPorts) {
                UnmodifiableIterator portIterator = Iterators.singletonIterator((Object)port);
                return Iterators.concat((Iterator)portIterator, resultEdges);
            }
            return resultEdges;
        }
        return Collections.emptyIterator();
    }
}

