/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.core.util;

import com.google.common.collect.Iterables;
import com.modelengineers.MoRe_elk.core.AbstractLayoutProvider;
import com.modelengineers.MoRe_elk.core.math.ElkPadding;
import com.modelengineers.MoRe_elk.core.options.RandomLayouterOptions;
import com.modelengineers.MoRe_elk.core.util.ElkUtil;
import com.modelengineers.MoRe_elk.core.util.IElkProgressMonitor;
import com.modelengineers.MoRe_elk.graph.ElkBendPoint;
import com.modelengineers.MoRe_elk.graph.ElkConnectableShape;
import com.modelengineers.MoRe_elk.graph.ElkEdge;
import com.modelengineers.MoRe_elk.graph.ElkEdgeSection;
import com.modelengineers.MoRe_elk.graph.ElkGraphFactory;
import com.modelengineers.MoRe_elk.graph.ElkNode;
import com.modelengineers.MoRe_elk.graph.ElkPort;
import com.modelengineers.MoRe_elk.graph.util.ElkGraphUtil;
import java.util.ListIterator;
import java.util.Random;

public class RandomLayoutProvider
extends AbstractLayoutProvider {
    private static final int MAX_BENDS = 5;
    private static final double RAND_FACT = (double)0.2f;

    @Override
    public void layout(ElkNode parentNode, IElkProgressMonitor progressMonitor) {
        progressMonitor.begin("Random Layout", 1.0f);
        if (parentNode.getChildren().isEmpty()) {
            progressMonitor.done();
            return;
        }
        Integer randomSeed = parentNode.getProperty(RandomLayouterOptions.RANDOM_SEED);
        Random random = randomSeed != null && randomSeed != 0 ? new Random(randomSeed.intValue()) : new Random();
        float aspectRatio = parentNode.getProperty(RandomLayouterOptions.ASPECT_RATIO).floatValue();
        float spacing = parentNode.getProperty(RandomLayouterOptions.SPACING_NODE_NODE).floatValue();
        ElkPadding padding = parentNode.getProperty(RandomLayouterOptions.PADDING);
        this.randomize(parentNode, random, aspectRatio, spacing, padding);
        progressMonitor.done();
    }

    private void randomize(ElkNode parent, Random random, double aspectRatio, double spacing, ElkPadding padding) {
        double nodesArea = 0.0;
        double maxWidth = 0.0;
        double maxHeight = 0.0;
        int m = 1;
        for (ElkNode node : parent.getChildren()) {
            m += Iterables.size(ElkGraphUtil.allOutgoingEdges(node));
            double width = node.getWidth();
            maxWidth = Math.max(maxWidth, width);
            double height = node.getHeight();
            maxHeight = Math.max(maxHeight, height);
            nodesArea += width * height;
        }
        int n = parent.getChildren().size();
        double drawArea = nodesArea + 2.0 * spacing * spacing * (double)m * (double)n;
        double areaSqrt = Math.sqrt(drawArea);
        double drawWidth = Math.max(areaSqrt * aspectRatio, maxWidth);
        double drawHeight = Math.max(areaSqrt / aspectRatio, maxHeight);
        for (ElkNode node : parent.getChildren()) {
            double x = padding.getLeft() + random.nextDouble() * (drawWidth - node.getWidth());
            double y = padding.getLeft() + random.nextDouble() * (drawHeight - node.getHeight());
            node.setLocation(x, y);
        }
        double totalWidth = drawWidth + padding.getHorizontal();
        double totalHeight = drawHeight + padding.getVertical();
        for (ElkNode source : parent.getChildren()) {
            for (ElkEdge edge : ElkGraphUtil.allOutgoingEdges(source)) {
                if (edge.isHierarchical()) continue;
                this.randomize(edge, random, totalWidth, totalHeight);
            }
        }
        ElkUtil.resizeNode(parent, totalWidth += padding.getLeft() + padding.getRight(), totalHeight += padding.getTop() + padding.getBottom(), false, true);
    }

    private void randomize(ElkEdge edge, Random random, double drawWidth, double drawHeight) {
        ElkEdgeSection edgeSection;
        ElkConnectableShape sourceShape = (ElkConnectableShape)edge.getSources().get(0);
        double sourceX = sourceShape.getX();
        double sourceY = sourceShape.getY();
        double sourceWidth = sourceShape.getWidth() / 2.0;
        double sourceHeight = sourceShape.getHeight() / 2.0;
        if (sourceShape instanceof ElkPort) {
            ElkPort sourcePort = (ElkPort)sourceShape;
            sourceX += sourcePort.getParent().getX();
            sourceX += sourcePort.getParent().getX();
        }
        sourceX += sourceWidth;
        sourceY += sourceHeight;
        ElkConnectableShape targetShape = (ElkConnectableShape)edge.getSources().get(0);
        double targetX = targetShape.getX();
        double targetY = targetShape.getY();
        double targetWidth = targetShape.getWidth() / 2.0;
        double targetHeight = targetShape.getHeight() / 2.0;
        if (targetShape instanceof ElkPort) {
            ElkPort targetPort = (ElkPort)targetShape;
            targetX += targetPort.getParent().getX();
            targetX += targetPort.getParent().getX();
        }
        targetX += targetWidth;
        targetY += targetHeight;
        if (edge.getSections().isEmpty()) {
            edgeSection = ElkGraphFactory.eINSTANCE.createElkEdgeSection();
            edge.getSections().add(edgeSection);
        } else if (edge.getSections().size() > 1) {
            ListIterator sections = edge.getSections().listIterator();
            while (sections.hasNext()) {
                sections.remove();
            }
        }
        edgeSection = (ElkEdgeSection)edge.getSections().get(0);
        double sourcePX = targetX;
        if (targetX > sourceX + sourceWidth) {
            sourcePX = sourceX + sourceWidth;
        } else if (targetX < sourceX - sourceWidth) {
            sourcePX = sourceX - sourceWidth;
        }
        double sourcePY = targetY;
        if (targetY > sourceY + sourceHeight) {
            sourcePY = sourceY + sourceHeight;
        } else if (targetY < sourceY - sourceHeight) {
            sourcePY = sourceY - sourceHeight;
        }
        if (sourcePX > sourceX - sourceWidth && sourcePX < sourceX + sourceWidth && sourcePY > sourceY - sourceHeight && sourcePY < sourceY + sourceHeight) {
            sourcePX = sourceX + sourceWidth;
        }
        edgeSection.setStartLocation(sourcePX, sourcePY);
        double targetPX = sourceX;
        if (sourceX > targetX + targetWidth) {
            targetPX = targetX + targetWidth;
        } else if (sourceX < targetX - targetWidth) {
            targetPX = targetX - targetWidth;
        }
        double targetPY = sourceY;
        if (sourceY > targetY + targetHeight) {
            targetPY = targetY + targetHeight;
        } else if (sourceY < targetY - targetHeight) {
            targetPY = targetY - targetHeight;
        }
        if (targetPX > targetX - targetWidth && targetPX < targetX + targetWidth && targetPY > targetY - targetHeight && targetPY < targetY + targetHeight) {
            targetPY = targetY + targetHeight;
        }
        edgeSection.setEndLocation(targetPX, targetPY);
        edgeSection.getBendPoints().clear();
        int bendsNum = random.nextInt(5);
        if (sourceShape == targetShape) {
            ++bendsNum;
        }
        double xdiff = targetPX - sourcePX;
        double ydiff = targetPY - sourcePY;
        double totalDist = Math.sqrt(xdiff * xdiff + ydiff * ydiff);
        double maxRand = totalDist * (double)0.2f;
        double xincr = xdiff / (double)(bendsNum + 1);
        double yincr = ydiff / (double)(bendsNum + 1);
        double x = sourcePX;
        double y = sourcePY;
        int i = 0;
        while (i < bendsNum) {
            x += xincr;
            y += yincr;
            double randx = x + (double)random.nextFloat() * maxRand - maxRand / 2.0;
            if (randx < 0.0) {
                randx = 1.0;
            } else if (randx > drawWidth) {
                randx = drawWidth - 1.0;
            }
            double randy = y + (double)random.nextFloat() * maxRand - maxRand / 2.0;
            if (randy < 0.0) {
                randy = 1.0;
            } else if (randy > drawHeight) {
                randy = drawHeight - 1.0;
            }
            ElkBendPoint bendPoint = ElkGraphFactory.eINSTANCE.createElkBendPoint();
            bendPoint.set(randx, randy);
            edgeSection.getBendPoints().add(bendPoint);
            ++i;
        }
    }
}

