/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.core.ui;

import com.modelengineers.MoRe_elk.core.data.ILayoutMetaData;
import com.modelengineers.MoRe_elk.core.data.LayoutAlgorithmData;
import com.modelengineers.MoRe_elk.core.data.LayoutCategoryData;
import com.modelengineers.MoRe_elk.core.data.LayoutMetaDataService;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class AlgorithmContentProvider
implements ITreeContentProvider {
    private LayoutMetaDataService layoutDataService;
    private final Map<Object, Boolean> filterMap = new HashMap<Object, Boolean>();
    private String filterValue;
    private ILayoutMetaData bestFilterMatch;

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof LayoutMetaDataService) {
            this.layoutDataService = (LayoutMetaDataService)inputElement;
        }
        return this.layoutDataService.getCategoryData().toArray();
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof LayoutCategoryData) {
            LayoutCategoryData typeData = (LayoutCategoryData)parentElement;
            return typeData.getLayouters().toArray();
        }
        return null;
    }

    public Object getParent(Object element) {
        if (element instanceof LayoutAlgorithmData) {
            LayoutAlgorithmData layouterData = (LayoutAlgorithmData)element;
            return this.layoutDataService.getCategoryData(layouterData.getCategoryId());
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof LayoutCategoryData) {
            return ((LayoutCategoryData)element).getLayouters().size() > 0;
        }
        return false;
    }

    public void dispose() {
    }

    public void updateFilter(String filter) {
        this.filterValue = filter;
        if (this.filterValue != null) {
            this.filterValue = this.filterValue.toLowerCase();
        }
        this.filterMap.clear();
        this.bestFilterMatch = null;
    }

    public boolean applyFilter(Object element) {
        Boolean result = this.filterMap.get(element);
        if (result == null) {
            if (this.filterValue != null && this.filterValue.length() > 0) {
                if (element instanceof LayoutCategoryData) {
                    LayoutCategoryData typeData = (LayoutCategoryData)element;
                    result = !typeData.getLayouters().isEmpty();
                    if (result.booleanValue()) {
                        String typeName = typeData.getName().toLowerCase();
                        result = typeName.contains(this.filterValue);
                        if (result.booleanValue()) {
                            for (LayoutAlgorithmData layouterData : typeData.getLayouters()) {
                                this.filterMap.put(layouterData, Boolean.TRUE);
                            }
                            if (this.bestFilterMatch == null || typeName.startsWith(this.filterValue) && !this.bestFilterMatch.getName().toLowerCase().startsWith(this.filterValue)) {
                                this.bestFilterMatch = typeData;
                            }
                        } else {
                            boolean hasFilteredChild = false;
                            for (LayoutAlgorithmData layouterData : typeData.getLayouters()) {
                                hasFilteredChild |= this.applyFilter(layouterData);
                            }
                            result = hasFilteredChild;
                        }
                    }
                } else if (element instanceof LayoutAlgorithmData) {
                    LayoutAlgorithmData layouterData = (LayoutAlgorithmData)element;
                    String layouterName = layouterData.getName().toLowerCase();
                    if (layouterName.contains(this.filterValue)) {
                        result = Boolean.TRUE;
                        if (this.bestFilterMatch == null || layouterName.startsWith(this.filterValue) && !this.bestFilterMatch.getName().toLowerCase().startsWith(this.filterValue)) {
                            this.bestFilterMatch = layouterData;
                        }
                    } else {
                        String bundle = layouterData.getBundleName();
                        result = bundle != null && bundle.toLowerCase().contains(this.filterValue);
                    }
                }
            } else {
                result = element instanceof LayoutCategoryData ? Boolean.valueOf(!((LayoutCategoryData)element).getLayouters().isEmpty()) : Boolean.TRUE;
            }
            this.filterMap.put(element, result);
        }
        return result;
    }

    public ILayoutMetaData getBestFilterMatch() {
        return this.bestFilterMatch;
    }
}

