/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.core.service.util;

import com.modelengineers.MoRe_elk.core.service.ElkServicePlugin;
import com.modelengineers.MoRe_elk.core.service.util.ProgressMonitorAdapter;
import com.modelengineers.MoRe_elk.core.util.BasicProgressMonitor;
import com.modelengineers.MoRe_elk.core.util.IElkCancelIndicator;
import com.modelengineers.MoRe_elk.core.util.IElkProgressMonitor;
import com.modelengineers.MoRe_elk.core.util.Maybe;
import java.util.LinkedList;
import java.util.concurrent.ExecutorService;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.statushandlers.StatusManager;

public abstract class MonitoredOperation {
    private static final int MAX_PROGRESS_LEVELS = 4;
    private final ExecutorService executorService;
    private long timestamp;
    private boolean isCanceled;
    private final IElkCancelIndicator cancelIndicator;

    public MonitoredOperation(ExecutorService service) {
        this(service, null);
    }

    public MonitoredOperation(ExecutorService service, IElkCancelIndicator cancelIndicator) {
        if (service == null) {
            throw new NullPointerException();
        }
        this.executorService = service;
        this.cancelIndicator = cancelIndicator;
    }

    protected boolean isCanceled() {
        return this.isCanceled || this.cancelIndicator != null && this.cancelIndicator.isCanceled();
    }

    protected abstract IStatus execute(IElkProgressMonitor var1);

    protected void preUIexec() {
    }

    protected void postUIexec() {
    }

    protected IElkProgressMonitor createMonitor() {
        return new CancelableProgressMonitor();
    }

    public final void runMonitored() {
        this.timestamp = System.currentTimeMillis();
        Display display = Display.getCurrent();
        if (display == null) {
            display = PlatformUI.getWorkbench().getDisplay();
            this.runMonitored(display, false);
        } else {
            this.runMonitored(display, true);
        }
    }

    public final void runUnmonitored() {
        this.timestamp = System.currentTimeMillis();
        if (PlatformUI.isWorkbenchRunning()) {
            Display display = Display.getCurrent();
            if (display == null) {
                this.runUnmonitored(PlatformUI.getWorkbench().getDisplay(), false);
            } else {
                this.runUnmonitored(display, true);
            }
        } else {
            this.runOffscreen();
        }
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void cancel() {
        this.isCanceled = true;
    }

    private void runOffscreen() {
        Maybe<IStatus> status = new Maybe<IStatus>();
        try {
            this.preUIexec();
        }
        catch (Throwable throwable) {
            status.set((IStatus)new Status(4, "com.modelengineers.MoRe_elk.core.service", "Error in monitored operation running offscreen during prepration", throwable));
        }
        if (status.get() == null && !this.isCanceled()) {
            status.set(this.execute(this.createMonitor()));
        }
        if (status.get() != null && ((IStatus)status.get()).getSeverity() == 0 && !this.isCanceled()) {
            try {
                this.postUIexec();
            }
            catch (Throwable throwable) {
                status.set((IStatus)new Status(4, "com.modelengineers.MoRe_elk.core.service", "Error in monitored operation running offscreen during post processing", throwable));
            }
        }
        this.handleStatus(status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void runUnmonitored(final Display display, boolean isUiThread) {
        block11: {
            block12: {
                status = new Maybe<IStatus>();
                if (!isUiThread) break block12;
                try {
                    this.preUIexec();
                    var4_4 = this.executorService;
                    synchronized (var4_4) {
                        this.executorService.execute(new Runnable(){

                            @Override
                            public void run() {
                                status.set(MonitoredOperation.this.execute(MonitoredOperation.this.createMonitor()));
                                if (!$assertionsDisabled && status.get() == null) {
                                    throw new AssertionError();
                                }
                                display.wake();
                            }
                        });
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var4_4
                        if (true) ** GOTO lbl19
                    }
                    while (true) {
                        if ((hasMoreToDispatch = display.readAndDispatch()) && status.get() == null && !this.isCanceled()) {
                            continue;
                        }
                        if (status.get() == null && !this.isCanceled()) {
                            display.sleep();
                        }
lbl19:
                        // 4 sources

                        if (status.get() != null || this.isCanceled()) break;
                    }
                    if (status.get() != null && status.get().getSeverity() == 0 && !this.isCanceled()) {
                        this.postUIexec();
                    }
                    break block11;
                }
                catch (Throwable throwable) {
                    status.set((IStatus)new Status(4, "com.modelengineers.MoRe_elk.core.service", "Error in monitored operation", throwable));
                }
                break block11;
            }
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        MonitoredOperation.this.preUIexec();
                    }
                    catch (Throwable throwable) {
                        status.set(new Status(4, "com.modelengineers.MoRe_elk.core.service", "Error in monitored operation", throwable));
                    }
                }
            });
            if (status.get() == null && !this.isCanceled()) {
                status.set(this.execute(this.createMonitor()));
                if (status.get().getSeverity() == 0 && !this.isCanceled()) {
                    display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                MonitoredOperation.this.postUIexec();
                            }
                            catch (Throwable throwable) {
                                status.set(new Status(4, "com.modelengineers.MoRe_elk.core.service", "Error in monitored operation", throwable));
                            }
                        }
                    });
                }
            }
        }
        this.handleStatus(status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runMonitored(final Display display, boolean isUiThread) {
        final Maybe<IProgressMonitor> monitor = new Maybe<IProgressMonitor>();
        final Maybe<IStatus> status = new Maybe<IStatus>();
        if (isUiThread) {
            ExecutorService executorService = this.executorService;
            synchronized (executorService) {
                this.executorService.execute(new Runnable(){

                    @Override
                    public void run() {
                        MonitoredOperation.this.runOperation(display, monitor, status);
                    }
                });
            }
            this.runUiHandler(display, monitor, status);
        } else {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    MonitoredOperation.this.runUiHandler(display, monitor, status);
                }
            });
            this.runOperation(display, monitor, status);
        }
        this.handleStatus(status);
    }

    protected void handleStatus(Maybe<IStatus> status) {
        if (status.get() != null) {
            int handlingStyle = 0;
            switch (status.get().getSeverity()) {
                case 4: {
                    handlingStyle = 3;
                    break;
                }
                case 1: 
                case 2: {
                    handlingStyle = 1;
                }
            }
            StatusManager.getManager().handle(status.get(), handlingStyle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void runOperation(Display display, Maybe<IProgressMonitor> monitor, Maybe<IStatus> status) {
        try {
            Maybe<IProgressMonitor> maybe = monitor;
            synchronized (maybe) {
                while (monitor.get() == null && !this.isCanceled()) {
                    try {
                        monitor.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            if (status.get() == null && !this.isCanceled()) {
                IPreferenceStore prefStore = ElkServicePlugin.getInstance().getPreferenceStore();
                BasicProgressMonitor monAdapt = new ProgressMonitorAdapter(monitor.get(), 4).withLogging(prefStore.getBoolean("elk.debug.logs")).withExecutionTimeMeasurement(prefStore.getBoolean("elk.debug.exectime"));
                status.set(this.execute(monAdapt));
                assert (status.get() != null);
            }
        }
        catch (Throwable throwable) {
            Maybe<IStatus> maybe = status;
            synchronized (maybe) {
                if (status.get() == null) {
                    status.set(Status.OK_STATUS);
                }
                display.wake();
                throw throwable;
            }
        }
        Maybe<IStatus> maybe = status;
        synchronized (maybe) {
            if (status.get() == null) {
                status.set(Status.OK_STATUS);
            }
            display.wake();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runUiHandler(final Display display, final Maybe<IProgressMonitor> monitor, final Maybe<IStatus> status) {
        try {
            this.preUIexec();
            PlatformUI.getWorkbench().getProgressService().run(false, true, new IRunnableWithProgress(){
                private static /* synthetic */ int[] $SWITCH_TABLE$org$eclipse$elk$core$service$util$MonitoredOperation$WrapperCommand$Type;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Unable to fully structure code
                 */
                public void run(IProgressMonitor uiMonitor) {
                    monitorWrapper = new ProgressMonitorWrapper(display);
                    var3_3 = monitor;
                    synchronized (var3_3) {
                        monitor.set(monitorWrapper);
                        monitor.notify();
                        // MONITOREXIT @DISABLED, blocks:[0, 2] lbl7 : MonitorExitStatement: MONITOREXIT : var3_3
                        if (true) ** GOTO lbl47
                    }
                    do {
                        hasMoreToDispatch = false;
                        do {
                            hasMoreToDispatch = display.readAndDispatch();
                            MonitoredOperation.access$1(MonitoredOperation.this, uiMonitor.isCanceled());
                        } while (hasMoreToDispatch && status.get() == null && !MonitoredOperation.this.isCanceled());
                        if (status.get() == null && ProgressMonitorWrapper.access$0(monitorWrapper).isEmpty() && !MonitoredOperation.this.isCanceled()) {
                            display.sleep();
                        }
                        while (!ProgressMonitorWrapper.access$0(monitorWrapper).isEmpty() && status.get() == null && !MonitoredOperation.this.isCanceled()) {
                            var5_6 = ProgressMonitorWrapper.access$0(monitorWrapper);
                            synchronized (var5_6) {
                                command = (WrapperCommand)ProgressMonitorWrapper.access$0(monitorWrapper).removeFirst();
                            }
                            switch (6.$SWITCH_TABLE$org$eclipse$elk$core$service$util$MonitoredOperation$WrapperCommand$Type()[WrapperCommand.access$1(command).ordinal()]) {
                                case 1: {
                                    uiMonitor.beginTask(WrapperCommand.access$2(command), WrapperCommand.access$3(command));
                                    break;
                                }
                                case 2: {
                                    uiMonitor.setTaskName(WrapperCommand.access$2(command));
                                    break;
                                }
                                case 3: {
                                    uiMonitor.subTask(WrapperCommand.access$2(command));
                                    break;
                                }
                                case 4: {
                                    uiMonitor.worked(WrapperCommand.access$3(command));
                                    break;
                                }
                                case 5: {
                                    uiMonitor.internalWorked((double)WrapperCommand.access$3(command));
                                }
                                case 6: {
                                    uiMonitor.done();
                                    return;
                                }
                            }
                        }
lbl47:
                        // 2 sources

                    } while (status.get() == null && !MonitoredOperation.this.isCanceled());
                }

                static /* synthetic */ int[] $SWITCH_TABLE$org$eclipse$elk$core$service$util$MonitoredOperation$WrapperCommand$Type() {
                    if ($SWITCH_TABLE$org$eclipse$elk$core$service$util$MonitoredOperation$WrapperCommand$Type != null) {
                        return $SWITCH_TABLE$org$eclipse$elk$core$service$util$MonitoredOperation$WrapperCommand$Type;
                    }
                    int[] nArray = new int[WrapperCommand.Type.values().length];
                    try {
                        nArray[WrapperCommand.Type.BEGIN_TASK.ordinal()] = 1;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {}
                    try {
                        nArray[WrapperCommand.Type.DONE.ordinal()] = 6;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {}
                    try {
                        nArray[WrapperCommand.Type.INTERNAL_WORKED.ordinal()] = 5;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {}
                    try {
                        nArray[WrapperCommand.Type.SET_TASK_NAME.ordinal()] = 2;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {}
                    try {
                        nArray[WrapperCommand.Type.SUB_TASK.ordinal()] = 3;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {}
                    try {
                        nArray[WrapperCommand.Type.WORKED.ordinal()] = 4;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {}
                    $SWITCH_TABLE$org$eclipse$elk$core$service$util$MonitoredOperation$WrapperCommand$Type = nArray;
                    return nArray;
                }
            });
            while (status.get() == null && !this.isCanceled()) {
                boolean hasMoreToDispatch;
                while ((hasMoreToDispatch = display.readAndDispatch()) && status.get() == null && !this.isCanceled()) {
                }
                if (status.get() != null || this.isCanceled()) continue;
                display.sleep();
            }
            if (status.get() != null && status.get().getSeverity() == 0 && !this.isCanceled()) {
                this.postUIexec();
            }
        }
        catch (Throwable throwable) {
            Maybe<IProgressMonitor> maybe = monitor;
            synchronized (maybe) {
                if (monitor.get() == null) {
                    monitor.set((IProgressMonitor)new NullProgressMonitor());
                    monitor.notify();
                }
            }
            maybe = status;
            synchronized (maybe) {
                if (status.get() == null || status.get().getSeverity() == 0) {
                    status.set((IStatus)new Status(4, "com.modelengineers.MoRe_elk.core.service", "Error in monitored operation", throwable));
                    this.handleStatus(status);
                }
            }
        }
    }

    protected class CancelableProgressMonitor
    extends BasicProgressMonitor {
        public CancelableProgressMonitor() {
            super(0);
            IPreferenceStore prefStore = ElkServicePlugin.getInstance().getPreferenceStore();
            this.withLogging(prefStore.getBoolean("elk.debug.logs"));
            this.withLogPersistence(prefStore.getBoolean("elk.debug.store"));
            this.withExecutionTimeMeasurement(prefStore.getBoolean("elk.debug.exectime"));
        }

        @Override
        public boolean isCanceled() {
            return MonitoredOperation.this.isCanceled();
        }
    }

    private class ProgressMonitorWrapper
    implements IProgressMonitor {
        private final LinkedList<WrapperCommand> commands = new LinkedList();
        private final Display display;

        ProgressMonitorWrapper(Display thedisplay) {
            this.display = thedisplay;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void beginTask(String name, int totalWork) {
            LinkedList<WrapperCommand> linkedList = this.commands;
            synchronized (linkedList) {
                this.commands.addLast(new WrapperCommand(WrapperCommand.Type.BEGIN_TASK, name, totalWork));
            }
            this.display.wake();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void done() {
            LinkedList<WrapperCommand> linkedList = this.commands;
            synchronized (linkedList) {
                this.commands.addLast(new WrapperCommand(WrapperCommand.Type.DONE, null, 0));
            }
            this.display.wake();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void internalWorked(double work) {
            LinkedList<WrapperCommand> linkedList = this.commands;
            synchronized (linkedList) {
                this.commands.addLast(new WrapperCommand(WrapperCommand.Type.INTERNAL_WORKED, null, (int)work));
            }
            this.display.wake();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setTaskName(String name) {
            LinkedList<WrapperCommand> linkedList = this.commands;
            synchronized (linkedList) {
                this.commands.addLast(new WrapperCommand(WrapperCommand.Type.SET_TASK_NAME, name, 0));
            }
            this.display.wake();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void subTask(String name) {
            LinkedList<WrapperCommand> linkedList = this.commands;
            synchronized (linkedList) {
                this.commands.addLast(new WrapperCommand(WrapperCommand.Type.SUB_TASK, name, 0));
            }
            this.display.wake();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void worked(int work) {
            LinkedList<WrapperCommand> linkedList = this.commands;
            synchronized (linkedList) {
                this.commands.addLast(new WrapperCommand(WrapperCommand.Type.WORKED, null, work));
            }
            this.display.wake();
        }

        public boolean isCanceled() {
            return MonitoredOperation.this.isCanceled;
        }

        public void setCanceled(boolean value) {
            MonitoredOperation.this.isCanceled = value;
        }

        static /* synthetic */ LinkedList access$0(ProgressMonitorWrapper progressMonitorWrapper) {
            return progressMonitorWrapper.commands;
        }
    }

    private static final class WrapperCommand {
        private Type type;
        private String name;
        private int work;

        private WrapperCommand(Type thetype, String thename, int thework) {
            this.type = thetype;
            this.name = thename;
            this.work = thework;
        }

        static /* synthetic */ Type access$1(WrapperCommand wrapperCommand) {
            return wrapperCommand.type;
        }

        static /* synthetic */ String access$2(WrapperCommand wrapperCommand) {
            return wrapperCommand.name;
        }

        static /* synthetic */ int access$3(WrapperCommand wrapperCommand) {
            return wrapperCommand.work;
        }

        static enum Type {
            BEGIN_TASK,
            SET_TASK_NAME,
            SUB_TASK,
            WORKED,
            INTERNAL_WORKED,
            DONE;

        }
    }
}

