/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.core.service.util;

import com.modelengineers.MoRe_elk.core.util.ElkUtil;
import com.modelengineers.MoRe_elk.core.util.IGraphElementVisitor;
import com.modelengineers.MoRe_elk.graph.ElkGraphElement;
import com.modelengineers.MoRe_elk.graph.ElkNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CompoundGraphElementVisitor
implements IGraphElementVisitor {
    private List<IGraphElementVisitor> graphVisitors = new ArrayList<IGraphElementVisitor>();
    private boolean applyToFullGraphFirst = false;

    public CompoundGraphElementVisitor(IGraphElementVisitor ... visitors) {
        this.graphVisitors.addAll(Arrays.asList(visitors));
    }

    public CompoundGraphElementVisitor(boolean applyToFullGraphFirst, IGraphElementVisitor ... visitors) {
        this(visitors);
        this.applyToFullGraphFirst = applyToFullGraphFirst;
    }

    @Override
    public void visit(ElkGraphElement element) {
        if (this.applyToFullGraphFirst) {
            if (element.eContainer() == null && element instanceof ElkNode) {
                ElkUtil.applyVisitors((ElkNode)element, this.graphVisitors.toArray(new IGraphElementVisitor[this.graphVisitors.size()]));
            }
        } else {
            for (IGraphElementVisitor graphVisitor : this.graphVisitors) {
                graphVisitor.visit(element);
            }
        }
    }

    public void addGraphVisitor(IGraphElementVisitor ... visitors) {
        this.graphVisitors.addAll(Arrays.asList(visitors));
    }

    public List<IGraphElementVisitor> getGraphVisitors() {
        return this.graphVisitors;
    }
}

