/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.core.options;

import com.modelengineers.MoRe_elk.core.AbstractLayoutProvider;
import com.modelengineers.MoRe_elk.core.data.ILayoutMetaDataProvider;
import com.modelengineers.MoRe_elk.core.data.LayoutAlgorithmData;
import com.modelengineers.MoRe_elk.core.math.ElkPadding;
import com.modelengineers.MoRe_elk.core.options.CoreOptions;
import com.modelengineers.MoRe_elk.core.util.IFactory;
import com.modelengineers.MoRe_elk.core.util.RandomLayoutProvider;
import com.modelengineers.MoRe_elk.graph.properties.IProperty;
import com.modelengineers.MoRe_elk.graph.properties.Property;

public class RandomLayouterOptions
implements ILayoutMetaDataProvider {
    public static final String ALGORITHM_ID = "com.modelengineers.MoRe_elk.random";
    private static final ElkPadding PADDING_DEFAULT = new ElkPadding(15.0);
    public static final IProperty<ElkPadding> PADDING = new Property<ElkPadding>(CoreOptions.PADDING, PADDING_DEFAULT);
    private static final double SPACING_NODE_NODE_DEFAULT = 15.0;
    public static final IProperty<Double> SPACING_NODE_NODE = new Property<Double>(CoreOptions.SPACING_NODE_NODE, Double.valueOf(15.0));
    private static final int RANDOM_SEED_DEFAULT = 0;
    public static final IProperty<Integer> RANDOM_SEED = new Property<Integer>(CoreOptions.RANDOM_SEED, Integer.valueOf(0));
    private static final double ASPECT_RATIO_DEFAULT = (double)1.6f;
    public static final IProperty<Double> ASPECT_RATIO = new Property<Double>(CoreOptions.ASPECT_RATIO, Double.valueOf(1.6f));

    @Override
    public void apply(ILayoutMetaDataProvider.Registry registry) {
        registry.register(new LayoutAlgorithmData.Builder().id(ALGORITHM_ID).name("ELK Randomizer").description("Distributes the nodes randomly on the plane, leading to very obfuscating layouts. Can be useful to demonstrate the power of \"real\" layout algorithms.").providerFactory(new RandomFactory()).melkBundleName("ELK").definingBundleId("com.modelengineers.MoRe_elk.core").imagePath("images/random_layout.png").create());
        registry.addOptionSupport(ALGORITHM_ID, "com.modelengineers.MoRe_elk.padding", PADDING_DEFAULT);
        registry.addOptionSupport(ALGORITHM_ID, "com.modelengineers.MoRe_elk.spacing.nodeNode", 15.0);
        registry.addOptionSupport(ALGORITHM_ID, "com.modelengineers.MoRe_elk.randomSeed", 0);
        registry.addOptionSupport(ALGORITHM_ID, "com.modelengineers.MoRe_elk.aspectRatio", 1.6f);
    }

    public static class RandomFactory
    implements IFactory<AbstractLayoutProvider> {
        @Override
        public AbstractLayoutProvider create() {
            RandomLayoutProvider provider = new RandomLayoutProvider();
            provider.initialize("");
            return provider;
        }

        @Override
        public void destroy(AbstractLayoutProvider obj) {
            obj.dispose();
        }
    }
}

