/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.core.options;

import com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.Set;

public enum NodeLabelPlacement {
    H_LEFT,
    H_CENTER,
    H_RIGHT,
    V_TOP,
    V_CENTER,
    V_BOTTOM,
    INSIDE,
    OUTSIDE,
    H_PRIORITY;


    public static EnumSet<NodeLabelPlacement> fixed() {
        return EnumSet.noneOf(NodeLabelPlacement.class);
    }

    public static EnumSet<NodeLabelPlacement> insideTopLeft() {
        return EnumSet.of(INSIDE, V_TOP, H_LEFT);
    }

    public static EnumSet<NodeLabelPlacement> insideTopCenter() {
        return EnumSet.of(INSIDE, V_TOP, H_CENTER);
    }

    public static EnumSet<NodeLabelPlacement> insideTopRight() {
        return EnumSet.of(INSIDE, V_TOP, H_RIGHT);
    }

    public static EnumSet<NodeLabelPlacement> insideCenter() {
        return EnumSet.of(INSIDE, V_CENTER, H_CENTER);
    }

    public static EnumSet<NodeLabelPlacement> insideBottomLeft() {
        return EnumSet.of(INSIDE, V_BOTTOM, H_LEFT);
    }

    public static EnumSet<NodeLabelPlacement> insideBottomCenter() {
        return EnumSet.of(INSIDE, V_BOTTOM, H_CENTER);
    }

    public static EnumSet<NodeLabelPlacement> insideBottomRight() {
        return EnumSet.of(INSIDE, V_BOTTOM, H_RIGHT);
    }

    public static EnumSet<NodeLabelPlacement> outsideTopLeft() {
        return EnumSet.of(OUTSIDE, V_TOP, H_LEFT);
    }

    public static EnumSet<NodeLabelPlacement> outsideTopCenter() {
        return EnumSet.of(OUTSIDE, V_TOP, H_CENTER);
    }

    public static EnumSet<NodeLabelPlacement> outsideTopRight() {
        return EnumSet.of(OUTSIDE, V_TOP, H_RIGHT);
    }

    public static EnumSet<NodeLabelPlacement> outsideBottomLeft() {
        return EnumSet.of(OUTSIDE, V_BOTTOM, H_LEFT);
    }

    public static EnumSet<NodeLabelPlacement> outsideBottomCenter() {
        return EnumSet.of(OUTSIDE, V_BOTTOM, H_CENTER);
    }

    public static EnumSet<NodeLabelPlacement> outsideBottomRight() {
        return EnumSet.of(OUTSIDE, V_BOTTOM, H_RIGHT);
    }

    public static boolean isValid(Set<NodeLabelPlacement> placement) {
        EnumSet<NodeLabelPlacement> validInsideOutside = EnumSet.of(INSIDE, OUTSIDE);
        if (Sets.intersection(validInsideOutside, placement).size() > 1) {
            return false;
        }
        EnumSet<NodeLabelPlacement> validHorizontal = EnumSet.of(H_LEFT, H_CENTER, H_RIGHT);
        if (Sets.intersection(validHorizontal, placement).size() > 1) {
            return false;
        }
        EnumSet<NodeLabelPlacement> validVertical = EnumSet.of(V_TOP, V_CENTER, V_BOTTOM);
        return Sets.intersection(validVertical, placement).size() <= 1;
    }

    public static NodeLabelPlacement valueOf(String string) {
        return Enum.valueOf(NodeLabelPlacement.class, string);
    }
}

