/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.core.math;

import com.modelengineers.MoRe_elk.core.util.IDataObject;

public abstract class Spacing
implements IDataObject,
Cloneable {
    private static final long serialVersionUID = 4358555478195088364L;
    public double top = 0.0;
    public double bottom = 0.0;
    public double left = 0.0;
    public double right = 0.0;

    protected Spacing() {
    }

    protected Spacing(double top, double right, double bottom, double left) {
        this.set(top, right, bottom, left);
    }

    public void set(Spacing spacing) {
        this.set(spacing.top, spacing.right, spacing.bottom, spacing.left);
    }

    public void set(double newTop, double newRight, double newBottom, double newLeft) {
        this.top = newTop;
        this.right = newRight;
        this.bottom = newBottom;
        this.left = newLeft;
    }

    public double getTop() {
        return this.top;
    }

    public void setTop(double top) {
        this.top = top;
    }

    public double getRight() {
        return this.right;
    }

    public void setRight(double right) {
        this.right = right;
    }

    public double getBottom() {
        return this.bottom;
    }

    public void setBottom(double bottom) {
        this.bottom = bottom;
    }

    public double getLeft() {
        return this.left;
    }

    public void setLeft(double left) {
        this.left = left;
    }

    public void setLeftRight(double val) {
        this.left = val;
        this.right = val;
    }

    public void setTopBottom(double val) {
        this.top = val;
        this.bottom = val;
    }

    public double getHorizontal() {
        return this.getLeft() + this.getRight();
    }

    public double getVertical() {
        return this.getTop() + this.getBottom();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Spacing) {
            Spacing other = (Spacing)obj;
            return this.top == other.top && this.bottom == other.bottom && this.left == other.left && this.right == other.right;
        }
        return false;
    }

    public int hashCode() {
        int code1 = Double.valueOf(this.left).hashCode() << 16;
        int code2 = Double.valueOf(this.right).hashCode() << 16;
        return (code1 |= Double.valueOf(this.bottom).hashCode() & 0xFFFF) ^ (code2 |= Double.valueOf(this.top).hashCode() & 0xFFFF);
    }

    public String toString() {
        return "[top=" + this.top + ",left=" + this.left + ",bottom=" + this.bottom + ",right=" + this.right + "]";
    }

    @Override
    public void parse(String string) {
        int start = 0;
        while (start < string.length() && Spacing.isdelim(string.charAt(start), "([{\"' \t\r\n")) {
            ++start;
        }
        int end = string.length();
        while (end > 0 && Spacing.isdelim(string.charAt(end - 1), ")]}\"' \t\r\n")) {
            --end;
        }
        if (start < end) {
            String[] tokens = string.substring(start, end).split(",|;");
            try {
                String[] stringArray = tokens;
                int n = tokens.length;
                int n2 = 0;
                while (n2 < n) {
                    String token = stringArray[n2];
                    String[] keyandvalue = token.split("=");
                    if (keyandvalue.length != 2) {
                        throw new IllegalArgumentException("Expecting a list of key-value pairs.");
                    }
                    String key = keyandvalue[0].trim();
                    double value = Double.parseDouble(keyandvalue[1].trim());
                    if (key.equals("top")) {
                        this.top = value;
                    } else if (key.equals("left")) {
                        this.left = value;
                    } else if (key.equals("bottom")) {
                        this.bottom = value;
                    } else if (key.equals("right")) {
                        this.right = value;
                    }
                    ++n2;
                }
            }
            catch (NumberFormatException exception) {
                throw new IllegalArgumentException("The given string contains parts that cannot be parsed as numbers." + exception);
            }
        }
    }

    private static boolean isdelim(char c, String delims) {
        int i = 0;
        while (i < delims.length()) {
            if (c == delims.charAt(i)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Spacing copy(Spacing other) {
        this.left = other.left;
        this.right = other.right;
        this.top = other.top;
        this.bottom = other.bottom;
        return this;
    }

    public Spacing add(Spacing other) {
        this.left += other.left;
        this.right += other.right;
        this.top += other.top;
        this.bottom += other.bottom;
        return this;
    }

    public abstract Spacing clone();
}

