/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.core.debug.views.time;

import com.modelengineers.MoRe_elk.core.debug.model.ExecutionInfo;
import com.modelengineers.MoRe_elk.core.debug.views.AbstractLayoutDebugView;
import com.modelengineers.MoRe_elk.core.debug.views.time.ExecutionTimeLabelProvider;
import java.util.function.Predicate;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;

public class ExecutionTimeView
extends AbstractLayoutDebugView {
    public static final String VIEW_ID = "com.modelengineers.MoRe_elk.debug.executionView";
    private TreeViewerColumn nameColumn;
    private TreeViewerColumn timeColumn;
    private TreeViewerColumn localTimeColumn;
    private static final String COL_NAME_WIDTH_KEY = "nameColumn.width";
    private static final String COL_TIME_WIDTH_KEY = "timeColumn.width";
    private static final String COL_LOCAL_TIME_WIDTH_KEY = "localTimeColumn.width";

    public ExecutionTimeView() {
        super(VIEW_ID, "elk.debug.exectime");
    }

    @Override
    protected Predicate<ExecutionInfo> getTreeFilter() {
        return info -> info.isExecutionTimeMeasured();
    }

    @Override
    protected void customizeTreeViewer(TreeViewer treeViewer) {
        treeViewer.getTree().setHeaderVisible(true);
        this.nameColumn = new TreeViewerColumn(treeViewer, 0);
        this.nameColumn.setLabelProvider((CellLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new ExecutionTimeLabelProvider(ExecutionTimeLabelProvider.DisplayMode.NAME)));
        this.nameColumn.getColumn().setText("Name");
        this.nameColumn.getColumn().setWidth(500);
        this.timeColumn = new TreeViewerColumn(treeViewer, 0);
        this.timeColumn.setLabelProvider((CellLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new ExecutionTimeLabelProvider(ExecutionTimeLabelProvider.DisplayMode.TIME_TOTAL)));
        this.timeColumn.getColumn().setAlignment(131072);
        this.timeColumn.getColumn().setText("Time [ms]");
        this.timeColumn.getColumn().setWidth(100);
        this.localTimeColumn = new TreeViewerColumn(treeViewer, 0);
        this.localTimeColumn.setLabelProvider((CellLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new ExecutionTimeLabelProvider(ExecutionTimeLabelProvider.DisplayMode.TIME_LOCAL)));
        this.localTimeColumn.getColumn().setAlignment(131072);
        this.localTimeColumn.getColumn().setText("Local Time [ms]");
        this.localTimeColumn.getColumn().setWidth(100);
    }

    @Override
    protected void loadState(IDialogSettings viewSettings) {
        super.loadState(viewSettings);
        this.loadColumnWidth(viewSettings, this.nameColumn, COL_NAME_WIDTH_KEY);
        this.loadColumnWidth(viewSettings, this.timeColumn, COL_TIME_WIDTH_KEY);
        this.loadColumnWidth(viewSettings, this.localTimeColumn, COL_LOCAL_TIME_WIDTH_KEY);
    }

    private void loadColumnWidth(IDialogSettings viewSettings, TreeViewerColumn column, String settingKey) {
        if (viewSettings.get(settingKey) != null) {
            column.getColumn().setWidth(viewSettings.getInt(settingKey));
        }
    }

    @Override
    protected void persistState(IDialogSettings viewSettings) {
        super.persistState(viewSettings);
        viewSettings.put(COL_NAME_WIDTH_KEY, this.nameColumn.getColumn().getWidth());
        viewSettings.put(COL_TIME_WIDTH_KEY, this.timeColumn.getColumn().getWidth());
        viewSettings.put(COL_LOCAL_TIME_WIDTH_KEY, this.localTimeColumn.getColumn().getWidth());
    }
}

