/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.core.debug.views.graph;

import com.google.common.collect.Lists;
import com.modelengineers.MoRe_elk.core.RecursiveGraphLayoutEngine;
import com.modelengineers.MoRe_elk.core.debug.ElkDebugPlugin;
import com.modelengineers.MoRe_elk.core.debug.model.ExecutionInfo;
import com.modelengineers.MoRe_elk.core.debug.views.graph.LayoutGraphView;
import com.modelengineers.MoRe_elk.core.debug.views.graph.LayoutUponLoadSettingAction;
import com.modelengineers.MoRe_elk.core.service.ElkServicePlugin;
import com.modelengineers.MoRe_elk.core.util.BasicProgressMonitor;
import com.modelengineers.MoRe_elk.graph.ElkNode;
import com.modelengineers.MoRe_emf.common.util.URI;
import com.modelengineers.MoRe_emf.common.util.WrappedException;
import com.modelengineers.MoRe_emf.ecore.resource.Resource;
import com.modelengineers.MoRe_emf.ecore.resource.impl.ResourceSetImpl;
import java.io.IOException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;

public class LoadGraphAction
extends Action {
    private static final String ACTION_ID = "com.modelengineers.MoRe_elk.debug.actions.loadGraph";
    private static final String ICON_PATH = "icons/import.png";
    private static final String LAST_FILE_NAME_PREF = "loadGraphAction.lastGraphFile";
    private LayoutGraphView view;

    public LoadGraphAction(LayoutGraphView theview) {
        this.setId(ACTION_ID);
        this.setText("Load Graph");
        this.setToolTipText("Load, layout, and display a saved ELK graph.");
        this.setImageDescriptor(ElkDebugPlugin.imageDescriptorFromPlugin((String)"com.modelengineers.MoRe_elk.core.debug", (String)ICON_PATH));
        this.view = theview;
    }

    public void run() {
        IPreferenceStore prefStore = ElkDebugPlugin.getDefault().getPreferenceStore();
        FileDialog fileDialog = new FileDialog(Display.getDefault().getActiveShell(), 4096);
        fileDialog.setFilterExtensions(new String[]{"*.elkg", "*.elkt", "*.xmi", "*.*"});
        fileDialog.setText("Select Graph File");
        fileDialog.setFileName(prefStore.getString(LAST_FILE_NAME_PREF));
        String fileName = fileDialog.open();
        LoadGraphAction.run(fileName, this.view);
    }

    public static void run(String fullFilePath, final LayoutGraphView layoutGraphView) {
        IPreferenceStore prefStore = ElkDebugPlugin.getDefault().getPreferenceStore();
        if (fullFilePath != null) {
            prefStore.setValue(LAST_FILE_NAME_PREF, fullFilePath);
            try {
                ElkNode content = LoadGraphAction.loadFromFile(fullFilePath);
                final ExecutionInfo info = LoadGraphAction.layout(fullFilePath, content);
                ElkDebugPlugin.getDefault().getModel().addExecution(info);
                layoutGraphView.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        layoutGraphView.setSelectedExecutionInfos(Lists.newArrayList((Object[])new ExecutionInfo[]{info}));
                    }
                });
            }
            catch (IOException exception) {
                throw new WrappedException(exception);
            }
        }
    }

    static ElkNode loadFromFile(String fileName) throws IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        URI uri = URI.createFileURI(fileName);
        Resource resource = resourceSet.createResource(uri);
        resource.load(null);
        return (ElkNode)resource.getContents().get(0);
    }

    static ExecutionInfo layout(String fileName, ElkNode graph) {
        return LoadGraphAction.layout(fileName, LayoutUponLoadSettingAction.shouldLayoutUponLoad(), graph);
    }

    static ExecutionInfo layout(String fileName, boolean performLayout, ElkNode graph) {
        IPreferenceStore prefStore = ElkServicePlugin.getInstance().getPreferenceStore();
        BasicProgressMonitor monitor = new BasicProgressMonitor().withMaxHierarchyLevels(0).withLogging(prefStore.getBoolean("elk.debug.logs")).withLogPersistence(prefStore.getBoolean("elk.debug.store")).withExecutionTimeMeasurement(prefStore.getBoolean("elk.debug.exectime"));
        monitor.begin(fileName, 1.0f);
        if (performLayout) {
            RecursiveGraphLayoutEngine layoutEngine = new RecursiveGraphLayoutEngine();
            layoutEngine.layout(graph, monitor.subTask(1.0f));
        }
        monitor.done();
        monitor.logGraph(graph, "Result");
        return ExecutionInfo.fromProgressMonitorAndFile(monitor, fileName, performLayout);
    }
}

