/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.core.debug.model;

import com.modelengineers.MoRe_elk.core.debug.model.ExecutionInfo;
import com.modelengineers.MoRe_elk.core.debug.model.IExecutionInfoModelListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ExecutionInfoModel {
    private final List<ExecutionInfo> executions = new ArrayList<ExecutionInfo>();
    private final Set<IExecutionInfoModelListener> listeners = new HashSet<IExecutionInfoModelListener>();

    public List<ExecutionInfo> getExecutionInfos() {
        return Collections.unmodifiableList(this.executions);
    }

    public void addExecution(ExecutionInfo info) {
        this.executions.add(info);
        this.notifyListeners();
    }

    public void replaceExecution(ExecutionInfo oldInfo, ExecutionInfo newInfo) {
        int index = this.executions.indexOf(oldInfo);
        if (index >= 0) {
            this.executions.set(index, newInfo);
            this.notifyListeners();
        }
    }

    public void removeExecutionInfos(ExecutionInfo ... infos) {
        ExecutionInfo[] executionInfoArray = infos;
        int n = infos.length;
        int n2 = 0;
        while (n2 < n) {
            ExecutionInfo info = executionInfoArray[n2];
            if (info.getParent() == null) {
                this.executions.remove(info);
            } else {
                info.getParent().getChildren().remove(info);
            }
            ++n2;
        }
        this.notifyListeners();
    }

    public void removeAllExecutionInfos() {
        this.executions.clear();
        this.notifyListeners();
    }

    public void addExecutionInfoModelListener(IExecutionInfoModelListener listener) {
        this.listeners.add(listener);
    }

    public void removeExecutionInfoModelListener(IExecutionInfoModelListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyListeners() {
        for (IExecutionInfoModelListener listener : this.listeners) {
            listener.executionInfoChanged();
        }
    }
}

