/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.core.debug.grandom.generators;

import com.modelengineers.MoRe_elk.core.debug.grandom.gRandom.Configuration;
import com.modelengineers.MoRe_elk.core.debug.grandom.gRandom.ConstraintType;
import com.modelengineers.MoRe_elk.core.debug.grandom.gRandom.DoubleQuantity;
import com.modelengineers.MoRe_elk.core.debug.grandom.gRandom.Edges;
import com.modelengineers.MoRe_elk.core.debug.grandom.gRandom.Flow;
import com.modelengineers.MoRe_elk.core.debug.grandom.gRandom.FlowType;
import com.modelengineers.MoRe_elk.core.debug.grandom.gRandom.Form;
import com.modelengineers.MoRe_elk.core.debug.grandom.gRandom.Hierarchy;
import com.modelengineers.MoRe_elk.core.debug.grandom.gRandom.Nodes;
import com.modelengineers.MoRe_elk.core.debug.grandom.gRandom.Ports;
import com.modelengineers.MoRe_elk.core.debug.grandom.gRandom.Side;
import com.modelengineers.MoRe_elk.core.debug.grandom.gRandom.Size;
import com.modelengineers.MoRe_elk.core.debug.grandom.generators.GeneratorOptions;
import com.modelengineers.MoRe_elk.core.options.PortConstraints;
import com.modelengineers.MoRe_elk.graph.properties.IProperty;
import com.modelengineers.MoRe_elk.graph.properties.IPropertyHolder;
import com.modelengineers.MoRe_elk.graph.properties.MapPropertyHolder;
import com.modelengineers.MoRe_emf.common.util.EList;
import java.util.Random;

public class ConfigurationParser {
    public static GeneratorOptions parse(Configuration config, Random r) {
        GeneratorOptions _xblockexpression = null;
        GeneratorOptions genOpt = new GeneratorOptions();
        ConfigurationParser.setGraphType(config, genOpt);
        ConfigurationParser.nodes(config.getNodes(), r, genOpt);
        ConfigurationParser.edges(config, genOpt, r);
        ConfigurationParser.hierarchy(config, genOpt, r);
        ConfigurationParser.setQuantities(genOpt, config.getFraction(), GeneratorOptions.PARTITION_FRAC);
        ConfigurationParser.setIfExists(genOpt, config.getMaxWidth(), GeneratorOptions.MAX_WIDTH);
        ConfigurationParser.setIfExists(genOpt, config.getMaxDegree(), GeneratorOptions.MAX_DEGREE);
        _xblockexpression = genOpt;
        return _xblockexpression;
    }

    private static MapPropertyHolder hierarchy(Configuration configuration, GeneratorOptions options, Random random) {
        MapPropertyHolder _xblockexpression = null;
        Hierarchy hierarchy = configuration.getHierarchy();
        MapPropertyHolder _xifexpression = null;
        boolean _exists = ConfigurationParser.exists(hierarchy);
        if (_exists) {
            MapPropertyHolder _xblockexpression_1 = null;
            DoubleQuantity hierarch = hierarchy.getNumHierarchNodes();
            ConfigurationParser.setQuantities(options, hierarchy.getCrossHierarchRel(), GeneratorOptions.EXACT_RELATIVE_HIER);
            options.setProperty(GeneratorOptions.SMALL_HIERARCHY, (Object)ConfigurationParser.exists(hierarch));
            ConfigurationParser.setQuantities(options, hierarchy.getLevels(), GeneratorOptions.MAX_HIERARCHY_LEVEL);
            ConfigurationParser.setQuantities(options, hierarch, GeneratorOptions.NUMBER_HIERARCHICAL_NODES);
            _xifexpression = _xblockexpression_1 = ConfigurationParser.setQuantities(options, hierarchy.getEdges(), GeneratorOptions.CROSS_HIER);
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private static MapPropertyHolder edges(Configuration config, GeneratorOptions genOpt, Random r) {
        IPropertyHolder _xblockexpression = null;
        Edges edges = config.getEdges();
        IPropertyHolder _xifexpression = null;
        boolean _exists = ConfigurationParser.exists(edges);
        if (_exists) {
            IPropertyHolder _xblockexpression_1 = null;
            boolean _isTotal = edges.isTotal();
            if (_isTotal) {
                genOpt.setProperty(GeneratorOptions.EDGE_DETERMINATION, (Object)GeneratorOptions.EdgeDetermination.ABSOLUTE);
                ConfigurationParser.setQuantities(genOpt, edges.getNEdges(), GeneratorOptions.EDGES_ABSOLUTE);
            } else {
                boolean _isDensity = edges.isDensity();
                if (_isDensity) {
                    ConfigurationParser.setQuantities(genOpt, edges.getNEdges(), GeneratorOptions.DENSITY);
                    genOpt.setProperty(GeneratorOptions.EDGE_DETERMINATION, (Object)GeneratorOptions.EdgeDetermination.DENSITY);
                } else {
                    boolean _isRelative = edges.isRelative();
                    if (_isRelative) {
                        genOpt.setProperty(GeneratorOptions.EDGE_DETERMINATION, (Object)GeneratorOptions.EdgeDetermination.RELATIVE);
                        ConfigurationParser.setQuantities(genOpt, edges.getNEdges(), GeneratorOptions.RELATIVE_EDGES);
                    } else {
                        genOpt.setProperty(GeneratorOptions.EDGE_DETERMINATION, (Object)GeneratorOptions.EdgeDetermination.OUTGOING);
                        ConfigurationParser.setQuantities(genOpt, edges.getNEdges(), GeneratorOptions.OUTGOING_EDGES);
                    }
                }
            }
            genOpt.setProperty(GeneratorOptions.EDGE_LABELS, (Object)edges.isLabels());
            _xifexpression = _xblockexpression_1 = genOpt.setProperty(GeneratorOptions.SELF_LOOPS, (Object)edges.isSelfLoops());
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private static MapPropertyHolder nodes(Nodes nodes, Random r, GeneratorOptions genOpt) {
        IPropertyHolder _xifexpression = null;
        boolean _exists = ConfigurationParser.exists(nodes);
        if (_exists) {
            IPropertyHolder _xblockexpression = null;
            ConfigurationParser.setQuantities(genOpt, nodes.getNNodes(), GeneratorOptions.NUMBER_OF_NODES);
            genOpt.setProperty(GeneratorOptions.CREATE_NODE_LABELS, (Object)nodes.isLabels());
            ConfigurationParser.ports(nodes, genOpt, r);
            ConfigurationParser.size(nodes, r, genOpt);
            boolean _isRemoveIsolated = nodes.isRemoveIsolated();
            boolean _not = !_isRemoveIsolated;
            _xifexpression = _xblockexpression = genOpt.setProperty(GeneratorOptions.ISOLATED_NODES, (Object)_not);
        }
        return _xifexpression;
    }

    private static MapPropertyHolder size(Nodes nodes, Random r, GeneratorOptions genOpt) {
        MapPropertyHolder _xblockexpression = null;
        Size size = nodes.getSize();
        MapPropertyHolder _xifexpression = null;
        boolean _exists = ConfigurationParser.exists(size);
        if (_exists) {
            MapPropertyHolder _xblockexpression_1 = null;
            ConfigurationParser.setQuantities(genOpt, size.getWidth(), GeneratorOptions.NODE_WIDTH);
            _xifexpression = _xblockexpression_1 = ConfigurationParser.setQuantities(genOpt, size.getHeight(), GeneratorOptions.NODE_HEIGHT);
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private static MapPropertyHolder ports(Nodes nodes, GeneratorOptions genOpt, Random r) {
        MapPropertyHolder _xblockexpression = null;
        Ports ports = nodes.getPorts();
        MapPropertyHolder _xifexpression = null;
        boolean _exists = ConfigurationParser.exists(ports);
        if (_exists) {
            MapPropertyHolder _xblockexpression_1 = null;
            genOpt.setProperty(GeneratorOptions.ENABLE_PORTS, (Object)true);
            genOpt.setProperty(GeneratorOptions.CREATE_PORT_LABELS, (Object)ports.isLabels());
            genOpt.setProperty(GeneratorOptions.PORT_CONSTRAINTS, (Object)ConfigurationParser.getConstraint(ports.getConstraint()));
            ConfigurationParser.setQuantities(genOpt, ports.getReUse(), GeneratorOptions.USE_EXISTING_PORTS_CHANCE);
            EList<Flow> flows = ports.getFlow();
            boolean _exists_1 = ConfigurationParser.exists(flows);
            if (_exists_1) {
                for (Flow f : flows) {
                    ConfigurationParser.setFlowSide(genOpt, f.getFlowType(), f.getSide(), f.getAmount(), r);
                }
            }
            Size size = ports.getSize();
            genOpt.setProperty(GeneratorOptions.SET_PORT_SIZE, (Object)true);
            MapPropertyHolder _xifexpression_1 = null;
            boolean _exists_2 = ConfigurationParser.exists(size);
            if (_exists_2) {
                MapPropertyHolder _xblockexpression_2 = null;
                ConfigurationParser.setQuantities(genOpt, size.getHeight(), GeneratorOptions.PORT_HEIGHT);
                _xifexpression_1 = _xblockexpression_2 = ConfigurationParser.setQuantities(genOpt, size.getWidth(), GeneratorOptions.PORT_WIDTH);
            }
            _xifexpression = _xblockexpression_1 = _xifexpression_1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private static MapPropertyHolder setQuantities(GeneratorOptions genOpt, DoubleQuantity quant, IProperty<GeneratorOptions.RandVal> randomValue) {
        IPropertyHolder _xifexpression = null;
        boolean _exists = ConfigurationParser.exists(quant);
        if (_exists) {
            _xifexpression = genOpt.setProperty(randomValue, ConfigurationParser.toRandVal(quant));
        }
        return _xifexpression;
    }

    private static GeneratorOptions.RandVal toRandVal(DoubleQuantity quant) {
        GeneratorOptions.RandVal _xifexpression = null;
        boolean _isMinMax = quant.isMinMax();
        if (_isMinMax) {
            _xifexpression = GeneratorOptions.RandVal.minMax(quant.getMin(), quant.getMax());
        } else {
            GeneratorOptions.RandVal _xifexpression_1 = null;
            boolean _isGaussian = quant.isGaussian();
            _xifexpression_1 = _isGaussian ? GeneratorOptions.RandVal.gaussian(quant.getMean(), quant.getStddv()) : GeneratorOptions.RandVal.exact(quant.getQuant());
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    private static MapPropertyHolder setFlowSide(GeneratorOptions options, FlowType type, Side side, DoubleQuantity quant, Random r) {
        IPropertyHolder _xblockexpression = null;
        int amount = ConfigurationParser.toRandVal(quant).intVal(r);
        IPropertyHolder _switchResult = null;
        if (type != null) {
            switch (type) {
                case INCOMING: {
                    IPropertyHolder _switchResult_1 = null;
                    if (side != null) {
                        switch (side) {
                            case EAST: {
                                _switchResult_1 = options.setProperty(GeneratorOptions.INCOMING_EAST_SIDE, (Object)amount);
                                break;
                            }
                            case NORTH: {
                                _switchResult_1 = options.setProperty(GeneratorOptions.INCOMING_NORTH_SIDE, (Object)amount);
                                break;
                            }
                            case SOUTH: {
                                _switchResult_1 = options.setProperty(GeneratorOptions.INCOMING_SOUTH_SIDE, (Object)amount);
                                break;
                            }
                            case WEST: {
                                _switchResult_1 = options.setProperty(GeneratorOptions.INCOMING_WEST_SIDE, (Object)amount);
                                break;
                            }
                        }
                    }
                    _switchResult = _switchResult_1;
                    break;
                }
                case OUTGOING: {
                    IPropertyHolder _switchResult_2 = null;
                    if (side != null) {
                        switch (side) {
                            case EAST: {
                                _switchResult_2 = options.setProperty(GeneratorOptions.OUTGOING_EAST_SIDE, (Object)amount);
                                break;
                            }
                            case NORTH: {
                                _switchResult_2 = options.setProperty(GeneratorOptions.OUTGOING_NORTH_SIDE, (Object)amount);
                                break;
                            }
                            case SOUTH: {
                                _switchResult_2 = options.setProperty(GeneratorOptions.OUTGOING_SOUTH_SIDE, (Object)amount);
                                break;
                            }
                            case WEST: {
                                _switchResult_2 = options.setProperty(GeneratorOptions.OUTGOING_WEST_SIDE, (Object)amount);
                                break;
                            }
                        }
                    }
                    _switchResult = _switchResult_2;
                    break;
                }
            }
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }

    private static PortConstraints getConstraint(ConstraintType constraint) {
        if (constraint != null) {
            switch (constraint) {
                case FREE: {
                    return PortConstraints.FREE;
                }
                case ORDER: {
                    return PortConstraints.FIXED_ORDER;
                }
                case POSITION: {
                    return PortConstraints.FIXED_POS;
                }
                case SIDE: {
                    return PortConstraints.FIXED_SIDE;
                }
                case RATIO: {
                    return PortConstraints.FIXED_RATIO;
                }
            }
        }
        return PortConstraints.UNDEFINED;
    }

    private static void setGraphType(Configuration configuration, GeneratorOptions options) {
        Form _form = configuration.getForm();
        if (_form != null) {
            switch (_form) {
                case ACYCLIC: {
                    options.setProperty(GeneratorOptions.GRAPH_TYPE, (Object)GeneratorOptions.GraphType.ACYCLIC_NO_TRANSITIVE_EDGES);
                    break;
                }
                case BICONNECTED: {
                    options.setProperty(GeneratorOptions.GRAPH_TYPE, (Object)GeneratorOptions.GraphType.BICONNECTED);
                    break;
                }
                case BIPARTITE: {
                    options.setProperty(GeneratorOptions.GRAPH_TYPE, (Object)GeneratorOptions.GraphType.BIPARTITE);
                    break;
                }
                case CUSTOM: {
                    options.setProperty(GeneratorOptions.GRAPH_TYPE, (Object)GeneratorOptions.GraphType.CUSTOM);
                    break;
                }
                case TREES: {
                    options.setProperty(GeneratorOptions.GRAPH_TYPE, (Object)GeneratorOptions.GraphType.TREE);
                    break;
                }
                case TRICONNECTED: {
                    options.setProperty(GeneratorOptions.GRAPH_TYPE, (Object)GeneratorOptions.GraphType.TRICONNECTED);
                    break;
                }
            }
        }
    }

    private static boolean exists(Object o) {
        return o != null;
    }

    private static <T> boolean setIfExists(GeneratorOptions genOpt, T value, IProperty<T> property) {
        boolean _exists = ConfigurationParser.exists(value);
        if (_exists) {
            genOpt.setProperty(property, (Object)value);
            return true;
        }
        return false;
    }
}

