/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.core.debug.grandom.gRandom;

import com.modelengineers.MoRe_emf.common.util.Enumerator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public enum FlowType implements Enumerator
{
    INCOMING(0, "incoming", "incoming"),
    OUTGOING(1, "outgoing", "outgoing");

    public static final int INCOMING_VALUE = 0;
    public static final int OUTGOING_VALUE = 1;
    private static final FlowType[] VALUES_ARRAY;
    public static final List<FlowType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new FlowType[]{INCOMING, OUTGOING};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static FlowType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            FlowType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static FlowType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            FlowType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static FlowType get(int value) {
        switch (value) {
            case 0: {
                return INCOMING;
            }
            case 1: {
                return OUTGOING;
            }
        }
        return null;
    }

    private FlowType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

