/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.core.debug.actions;

import com.modelengineers.MoRe_elk.core.debug.model.ExecutionInfo;
import com.modelengineers.MoRe_elk.core.debug.views.AbstractLayoutDebugView;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;

public class CompressLogFolderAction
extends Action {
    private static final String ACTION_ID = "com.modelengineers.MoRe_elk.debug.actions.compressLogFolder";
    private AbstractLayoutDebugView view;

    public CompressLogFolderAction(AbstractLayoutDebugView theview) {
        this.setId(ACTION_ID);
        this.setText("&Compress Log Folder");
        this.setToolTipText("Produces a zip archive for the selected log folder.");
        this.view = theview;
    }

    public void updateEnablement() {
        List<ExecutionInfo> selectedLayoutRuns = this.getSelectedLayoutRunsWithDebugFolder();
        this.setEnabled(!selectedLayoutRuns.isEmpty());
    }

    public void run() {
        String fileName;
        final List<ExecutionInfo> selectedInfos = this.getSelectedLayoutRunsWithDebugFolder();
        if (!selectedInfos.isEmpty() && (fileName = CompressLogFolderAction.getFileName(selectedInfos, this.view.getSite().getShell().getDisplay())) != null) {
            Job saveJob = new Job("Compress Log Folder"){

                protected IStatus run(IProgressMonitor monitor) {
                    return CompressLogFolderAction.this.doZip(selectedInfos, fileName, monitor);
                }
            };
            IProgressMonitor monitor = Job.getJobManager().createProgressGroup();
            saveJob.setProgressGroup(monitor, selectedInfos.size());
            saveJob.setPriority(30);
            saveJob.setUser(true);
            saveJob.schedule();
        }
    }

    private List<ExecutionInfo> getSelectedLayoutRunsWithDebugFolder() {
        return this.view.getSelectedExecutionInfos().stream().filter(info -> info.getParent() == null).filter(info -> info.getDebugFolder() != null).filter(info -> Files.isDirectory(info.getDebugFolder(), new LinkOption[0])).collect(Collectors.toList());
    }

    private static String getFileName(List<ExecutionInfo> executionInfos, Display display) {
        String suggestedFileName = String.valueOf(executionInfos.stream().map(info -> info.getDebugFolder()).filter(folder -> folder != null).map(folder -> folder.getFileName().toString()).collect(Collectors.joining(", "))) + ".zip";
        String[] extensions = new String[]{"*.zip"};
        String[] names = new String[]{"ZIP archives"};
        FileDialog fileDialog = new FileDialog(display.getActiveShell(), 8192);
        fileDialog.setFilterExtensions(extensions);
        fileDialog.setFilterNames(names);
        fileDialog.setOverwrite(true);
        fileDialog.setText("Select Output File");
        fileDialog.setFileName(suggestedFileName);
        String fileName = CompressLogFolderAction.completeFileName(fileDialog.open());
        return fileName;
    }

    private static String completeFileName(String fileName) {
        if (fileName == null) {
            return null;
        }
        String nameCopy = new String(fileName).toLowerCase();
        if (nameCopy.endsWith(".zip")) {
            return fileName;
        }
        if (nameCopy.endsWith(".zi")) {
            return String.valueOf(fileName) + "p";
        }
        if (nameCopy.endsWith(".z")) {
            return String.valueOf(fileName) + "ip";
        }
        if (nameCopy.endsWith(".")) {
            return String.valueOf(fileName) + "zip";
        }
        return String.valueOf(fileName) + ".zip";
    }

    private IStatus doZip(List<ExecutionInfo> layoutRuns, String zipFileName, IProgressMonitor monitor) {
        FileOutputStream outFileStream = null;
        ZipOutputStream zipFileStream = null;
        try {
            outFileStream = new FileOutputStream(zipFileName);
            zipFileStream = new ZipOutputStream(outFileStream);
            monitor.beginTask("Compressing log folders to " + zipFileName, layoutRuns.size());
            zipFileStream.putNextEntry(new ZipEntry("/"));
            zipFileStream.closeEntry();
            for (ExecutionInfo layoutRun : layoutRuns) {
                if (monitor.isCanceled()) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                this.doZipLayoutRun(layoutRun, zipFileStream, monitor);
            }
            monitor.done();
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (Exception e) {
            Status status = new Status(4, "com.modelengineers.MoRe_elk.core.debug", "Unable to compress log folders to " + zipFileName + ".", (Throwable)e);
            return status;
        }
        finally {
            if (zipFileStream != null) {
                try {
                    zipFileStream.close();
                }
                catch (IOException e) {
                    return new Status(4, "com.modelengineers.MoRe_elk.core.debug", "Unable to compress log folders to " + zipFileName + ".", (Throwable)e);
                }
            }
        }
    }

    private void doZipLayoutRun(ExecutionInfo layoutRun, ZipOutputStream zipFileStream, IProgressMonitor monitor) throws Exception {
        monitor.subTask("Compressing " + layoutRun.getDebugFolder().getFileName());
        Path debugFolder = layoutRun.getDebugFolder();
        if (Files.isDirectory(debugFolder, new LinkOption[0])) {
            this.doZipFolder("/", debugFolder, zipFileStream);
        }
        monitor.worked(1);
    }

    private void doZipFolder(String pathPrefix, Path folder, ZipOutputStream zipFileStream) throws Exception {
        String newPathPrefix = String.valueOf(pathPrefix) + folder.getFileName() + "/";
        zipFileStream.putNextEntry(new ZipEntry(newPathPrefix));
        zipFileStream.closeEntry();
        Iterator childIterator = Files.list(folder).iterator();
        while (childIterator.hasNext()) {
            Path child = (Path)childIterator.next();
            if (Files.isDirectory(child, new LinkOption[0])) {
                this.doZipFolder(newPathPrefix, child, zipFileStream);
                continue;
            }
            if (!Files.isRegularFile(child, new LinkOption[0])) continue;
            this.doZipFile(newPathPrefix, child, zipFileStream);
        }
    }

    private void doZipFile(String pathPrefix, Path file, ZipOutputStream zipFileStream) throws Exception {
        zipFileStream.putNextEntry(new ZipEntry(String.valueOf(pathPrefix) + file.getFileName()));
        Files.copy(file, zipFileStream);
        zipFileStream.closeEntry();
    }
}

