/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.core.comments;

import com.modelengineers.MoRe_elk.core.comments.IDataProvider;
import com.modelengineers.MoRe_elk.core.options.CoreOptions;
import com.modelengineers.MoRe_elk.graph.ElkNode;
import com.modelengineers.MoRe_elk.graph.util.ElkGraphUtil;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;

public class ElkGraphDataProvider
implements IDataProvider<ElkNode, ElkNode> {
    private final ElkNode graph;

    public ElkGraphDataProvider(ElkNode graph) {
        Objects.requireNonNull(graph, "Comment attachment must be run on a graph.");
        this.graph = graph;
    }

    @Override
    public Collection<ElkNode> provideComments() {
        return this.graph.getChildren().stream().filter(node -> node.getProperty(CoreOptions.COMMENT_BOX)).collect(Collectors.toList());
    }

    @Override
    public Collection<ElkNode> provideTargets() {
        return this.graph.getChildren().stream().filter(node -> node.getProperty(CoreOptions.COMMENT_BOX) == false).collect(Collectors.toList());
    }

    @Override
    public Collection<IDataProvider<ElkNode, ElkNode>> provideSubHierarchies() {
        return this.graph.getChildren().stream().filter(node -> !node.getChildren().isEmpty()).map(node -> new ElkGraphDataProvider((ElkNode)node)).collect(Collectors.toList());
    }

    @Override
    public void attach(ElkNode comment, ElkNode target) {
        ElkGraphUtil.createSimpleEdge(comment, target);
    }
}

