/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.conn.gmf.layouter;

import com.modelengineers.MoRe_elk.conn.gmf.layouter.Draw2DOptions;
import com.modelengineers.MoRe_elk.core.AbstractLayoutProvider;
import com.modelengineers.MoRe_elk.core.math.ElkPadding;
import com.modelengineers.MoRe_elk.core.options.Direction;
import com.modelengineers.MoRe_elk.core.util.ElkUtil;
import com.modelengineers.MoRe_elk.core.util.IElkProgressMonitor;
import com.modelengineers.MoRe_elk.graph.ElkConnectableShape;
import com.modelengineers.MoRe_elk.graph.ElkEdge;
import com.modelengineers.MoRe_elk.graph.ElkEdgeSection;
import com.modelengineers.MoRe_elk.graph.ElkNode;
import com.modelengineers.MoRe_elk.graph.util.ElkGraphUtil;
import java.util.HashMap;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.graph.CompoundDirectedGraphLayout;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.DirectedGraphLayout;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.Node;

public class Draw2DLayoutProvider
extends AbstractLayoutProvider {
    public static final String PARAM_COMPOUND = "Compound";
    private static final double DEF_MIN_SPACING = 16.0;
    private boolean compoundMode = false;

    @Override
    public void initialize(String parameter) {
        this.compoundMode = PARAM_COMPOUND.equals(parameter);
    }

    @Override
    public void layout(ElkNode layoutNode, IElkProgressMonitor progressMonitor) {
        progressMonitor.begin("Draw2D Directed Graph layout", 1.0f);
        DirectedGraph graph = this.buildDraw2dGraph(layoutNode);
        CompoundDirectedGraphLayout draw2dLayout = this.compoundMode ? new CompoundDirectedGraphLayout() : new DirectedGraphLayout();
        draw2dLayout.visit(graph);
        this.applyLayout(layoutNode, graph);
        progressMonitor.done();
    }

    private DirectedGraph buildDraw2dGraph(ElkNode layoutNode) {
        DirectedGraph graph = new DirectedGraph();
        double minSpacing = layoutNode.getProperty(Draw2DOptions.SPACING_NODE_NODE);
        if (minSpacing < 0.0) {
            minSpacing = 16.0;
        }
        graph.setDefaultPadding(new Insets((int)minSpacing));
        ElkPadding padding = layoutNode.getProperty(Draw2DOptions.PADDING);
        graph.setMargin(new Insets((int)padding.top, (int)padding.left, (int)padding.bottom, (int)padding.right));
        Direction layoutDirection = layoutNode.getProperty(Draw2DOptions.DIRECTION);
        switch (layoutDirection) {
            case DOWN: 
            case UP: {
                graph.setDirection(4);
                break;
            }
            default: {
                graph.setDirection(16);
            }
        }
        HashMap<ElkNode, Node> nodeMap = new HashMap<ElkNode, Node>();
        for (ElkNode elknode : layoutNode.getChildren()) {
            Node draw2dNode = new Node((Object)elknode);
            ElkUtil.resizeNode(elknode);
            draw2dNode.width = (int)elknode.getWidth();
            draw2dNode.height = (int)elknode.getHeight();
            nodeMap.put(elknode, draw2dNode);
            graph.nodes.add((Object)draw2dNode);
        }
        for (ElkNode source : layoutNode.getChildren()) {
            Node draw2dSource = (Node)nodeMap.get(source);
            for (ElkEdge kedge : ElkGraphUtil.allOutgoingEdges(source)) {
                ElkNode target;
                Node draw2dTarget;
                if (kedge.isHyperedge() || (draw2dTarget = (Node)nodeMap.get(target = ElkGraphUtil.connectableShapeToNode((ElkConnectableShape)kedge.getTargets().get(0)))) == null || draw2dTarget == draw2dSource) continue;
                Edge draw2dEdge = new Edge((Object)kedge, draw2dSource, draw2dTarget);
                graph.edges.add((Object)draw2dEdge);
            }
        }
        return graph;
    }

    private void applyLayout(ElkNode parentNode, DirectedGraph graph) {
        int i = 0;
        while (i < graph.nodes.size()) {
            Node node = graph.nodes.getNode(i);
            if (node.data instanceof ElkNode) {
                ElkNode knode = (ElkNode)node.data;
                knode.setLocation(node.x, node.y);
            }
            ++i;
        }
        i = 0;
        while (i < graph.edges.size()) {
            Edge edge = graph.edges.getEdge(i);
            if (edge.data instanceof ElkEdge) {
                ElkEdge kedge = (ElkEdge)edge.data;
                ElkEdgeSection edgeSection = ElkGraphUtil.firstEdgeSection(kedge, true, true);
                PointList pointList = edge.getPoints();
                Point startPoint = pointList.getFirstPoint();
                edgeSection.setStartLocation(startPoint.x, startPoint.y);
                int j = 1;
                while (j < pointList.size() - 1) {
                    Point point = pointList.getPoint(j);
                    ElkGraphUtil.createBendPoint(edgeSection, point.x, point.y);
                    ++j;
                }
                Point endPoint = pointList.getFirstPoint();
                edgeSection.setStartLocation(endPoint.x, endPoint.y);
            }
            ++i;
        }
        ElkPadding insets = parentNode.getProperty(Draw2DOptions.PADDING);
        Dimension layoutSize = graph.getLayoutSize();
        double width = insets.getLeft() + (double)layoutSize.width + insets.getRight();
        double height = insets.getTop() + (double)layoutSize.height + insets.getBottom();
        ElkUtil.resizeNode(parentNode, width, height, false, true);
    }
}

