/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.conn.gmf;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.modelengineers.MoRe_elk.core.service.DiagramLayoutEngine;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gmf.runtime.common.core.service.AbstractProvider;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.diagram.ui.editparts.AbstractBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.render.editparts.AbstractImageEditPart;
import org.eclipse.gmf.runtime.diagram.ui.services.layout.ILayoutNode;
import org.eclipse.gmf.runtime.diagram.ui.services.layout.ILayoutNodeOperation;
import org.eclipse.gmf.runtime.diagram.ui.services.layout.ILayoutNodeProvider;
import org.eclipse.gmf.runtime.notation.Node;

public class ElkLayoutProvider
extends AbstractProvider
implements ILayoutNodeProvider {
    public boolean provides(IOperation operation) {
        return operation instanceof ILayoutNodeOperation;
    }

    public boolean canLayoutNodes(List layoutNodes, boolean shouldOffsetFromBoundingBox, IAdaptable layoutHint) {
        Object o = layoutHint.getAdapter(IGraphicalEditPart.class);
        if (!(o instanceof IGraphicalEditPart)) {
            return false;
        }
        final IGraphicalEditPart parent = (IGraphicalEditPart)o;
        if (layoutNodes.isEmpty()) {
            return Iterables.any((Iterable)parent.getChildren(), (Predicate)new Predicate<Object>(){

                public boolean apply(Object o) {
                    return o instanceof ShapeNodeEditPart && !(o instanceof AbstractBorderItemEditPart) && !(o instanceof AbstractImageEditPart);
                }
            });
        }
        return Iterables.any((Iterable)layoutNodes, (Predicate)new Predicate<Object>(){

            public boolean apply(Object o) {
                ILayoutNode layoutNode = (ILayoutNode)o;
                IGraphicalEditPart editPart = ElkLayoutProvider.findEditPart(parent, layoutNode.getNode());
                return editPart instanceof ShapeNodeEditPart && !(editPart instanceof AbstractBorderItemEditPart) && !(editPart instanceof AbstractImageEditPart);
            }
        });
    }

    public Runnable layoutLayoutNodes(List layoutNodes, boolean offsetFromBoundingBox, IAdaptable layoutHint) {
        ArrayList<IGraphicalEditPart> diagramPart;
        final boolean zoomToFit = Platform.getPreferencesService().getBoolean("com.modelengineers.MoRe_elk.core.ui", "com.modelengineers.MoRe_elk.zoomToFit", false, null);
        final boolean progressDialog = Platform.getPreferencesService().getBoolean("com.modelengineers.MoRe_elk.core.ui", "com.modelengineers.MoRe_elk.progressDialog", false, null);
        if (layoutNodes.isEmpty()) {
            diagramPart = layoutHint.getAdapter(IGraphicalEditPart.class);
        } else {
            ArrayList<IGraphicalEditPart> partList = new ArrayList<IGraphicalEditPart>(layoutNodes.size());
            IGraphicalEditPart parent = (IGraphicalEditPart)layoutHint.getAdapter(IGraphicalEditPart.class);
            if (parent != null) {
                for (ILayoutNode layoutNode : layoutNodes) {
                    IGraphicalEditPart editPart = ElkLayoutProvider.findEditPart(parent, layoutNode.getNode());
                    if (editPart == null) continue;
                    partList.add(editPart);
                }
            }
            diagramPart = partList;
        }
        return new Runnable(){

            @Override
            public void run() {
                DiagramLayoutEngine.invokeLayout(null, diagramPart, false, progressDialog, false, zoomToFit);
            }
        };
    }

    private static IGraphicalEditPart findEditPart(IGraphicalEditPart parent, Node notationNode) {
        LinkedList<IGraphicalEditPart> editPartQueue = new LinkedList<IGraphicalEditPart>();
        editPartQueue.add(parent);
        do {
            IGraphicalEditPart editPart;
            if (notationNode.equals((editPart = (IGraphicalEditPart)editPartQueue.removeFirst()).getNotationView())) {
                return editPart;
            }
            editPartQueue.addAll(editPart.getChildren());
        } while (!editPartQueue.isEmpty());
        return null;
    }
}

