/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.p5edges.orthogonal;

import com.modelengineers.MoRe_elk.alg.layered.p5edges.orthogonal.HyperEdgeSegment;

public final class HyperEdgeSegmentDependency {
    public static final int CRITICAL_DEPENDENCY_WEIGHT = 1;
    private final DependencyType type;
    private HyperEdgeSegment source;
    private HyperEdgeSegment target;
    private final int weight;

    private HyperEdgeSegmentDependency(DependencyType type, HyperEdgeSegment source, HyperEdgeSegment target, int weight) {
        this.type = type;
        this.weight = weight;
        this.setSource(source);
        this.setTarget(target);
    }

    public static HyperEdgeSegmentDependency createAndAddRegular(HyperEdgeSegment source, HyperEdgeSegment target, int weight) {
        return new HyperEdgeSegmentDependency(DependencyType.REGULAR, source, target, weight);
    }

    public static HyperEdgeSegmentDependency createAndAddCritical(HyperEdgeSegment source, HyperEdgeSegment target) {
        return new HyperEdgeSegmentDependency(DependencyType.CRITICAL, source, target, 1);
    }

    public void remove() {
        this.setSource(null);
        this.setTarget(null);
    }

    public void reverse() {
        HyperEdgeSegment oldSource = this.source;
        HyperEdgeSegment oldTarget = this.target;
        this.setSource(oldTarget);
        this.setTarget(oldSource);
    }

    public DependencyType getType() {
        return this.type;
    }

    public HyperEdgeSegment getSource() {
        return this.source;
    }

    public void setSource(HyperEdgeSegment newSource) {
        if (this.source != null) {
            this.source.getOutgoingSegmentDependencies().remove(this);
        }
        this.source = newSource;
        if (this.source != null) {
            this.source.getOutgoingSegmentDependencies().add(this);
        }
    }

    public HyperEdgeSegment getTarget() {
        return this.target;
    }

    public void setTarget(HyperEdgeSegment newTarget) {
        if (this.target != null) {
            this.target.getIncomingSegmentDependencies().remove(this);
        }
        this.target = newTarget;
        if (this.target != null) {
            this.target.getIncomingSegmentDependencies().add(this);
        }
    }

    public int getWeight() {
        return this.weight;
    }

    public String toString() {
        return this.source + "->" + this.target + " (" + this.type.name() + ")";
    }

    public static enum DependencyType {
        REGULAR,
        CRITICAL;

    }
}

