/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.p5edges;

import com.modelengineers.MoRe_elk.alg.layered.LayeredPhases;
import com.modelengineers.MoRe_elk.alg.layered.graph.LGraph;
import com.modelengineers.MoRe_elk.alg.layered.graph.LGraphUtil;
import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.alg.layered.graph.LPort;
import com.modelengineers.MoRe_elk.alg.layered.graph.Layer;
import com.modelengineers.MoRe_elk.alg.layered.intermediate.IntermediateProcessorStrategy;
import com.modelengineers.MoRe_elk.alg.layered.options.GraphProperties;
import com.modelengineers.MoRe_elk.alg.layered.options.InternalProperties;
import com.modelengineers.MoRe_elk.alg.layered.options.LayeredOptions;
import com.modelengineers.MoRe_elk.alg.layered.options.LayeringStrategy;
import com.modelengineers.MoRe_elk.alg.layered.p5edges.orthogonal.HyperEdgeSegment;
import com.modelengineers.MoRe_elk.alg.layered.p5edges.orthogonal.OrthogonalRoutingGenerator;
import com.modelengineers.MoRe_elk.alg.layered.p5edges.orthogonal.direction.RoutingDirection;
import com.modelengineers.MoRe_elk.core.alg.ILayoutPhase;
import com.modelengineers.MoRe_elk.core.alg.LayoutProcessorConfiguration;
import com.modelengineers.MoRe_elk.core.options.PortSide;
import com.modelengineers.MoRe_elk.core.util.IElkProgressMonitor;
import com.modelengineers.MoRe_elk.core.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.stream.IntStream;

public final class OrthogonalEdgeRouter
implements ILayoutPhase<LayeredPhases, LGraph> {
    private static final LayoutProcessorConfiguration<LayeredPhases, LGraph> HYPEREDGE_PROCESSING_ADDITIONS_NON_INTERACTIVE = LayoutProcessorConfiguration.create().addBefore(LayeredPhases.P4_NODE_PLACEMENT, IntermediateProcessorStrategy.HYPEREDGE_DUMMY_MERGER_BEFORE_P4).addAfter(LayeredPhases.P4_NODE_PLACEMENT, IntermediateProcessorStrategy.HYPEREDGE_DUMMY_MERGER_AFTER_P4);
    private static final LayoutProcessorConfiguration<LayeredPhases, LGraph> HYPEREDGE_PROCESSING_ADDITIONS_INTERACTIVE = LayoutProcessorConfiguration.create().addBefore(LayeredPhases.P4_NODE_PLACEMENT, IntermediateProcessorStrategy.HYPEREDGE_DUMMY_MERGER_FOR_INTERACTIVE_MODE);
    private static final LayoutProcessorConfiguration<LayeredPhases, LGraph> INVERTED_PORT_PROCESSING_ADDITIONS = LayoutProcessorConfiguration.create().addBefore(LayeredPhases.P3_NODE_ORDERING, IntermediateProcessorStrategy.INVERTED_PORT_PROCESSOR);
    private static final LayoutProcessorConfiguration<LayeredPhases, LGraph> NORTH_SOUTH_PORT_PROCESSING_ADDITIONS = LayoutProcessorConfiguration.create().addBefore(LayeredPhases.P3_NODE_ORDERING, IntermediateProcessorStrategy.NORTH_SOUTH_PORT_PREPROCESSOR).addAfter(LayeredPhases.P5_EDGE_ROUTING, IntermediateProcessorStrategy.NORTH_SOUTH_PORT_POSTPROCESSOR);
    private static final LayoutProcessorConfiguration<LayeredPhases, LGraph> SELF_LOOP_PROCESSING_ADDITIONS = LayoutProcessorConfiguration.create().addBefore(LayeredPhases.P2_LAYERING, IntermediateProcessorStrategy.SELF_LOOP_PREPROCESSOR).addAfter(LayeredPhases.P5_EDGE_ROUTING, IntermediateProcessorStrategy.SELF_LOOP_POSTPROCESSOR).before(LayeredPhases.P4_NODE_PLACEMENT).add(IntermediateProcessorStrategy.SELF_LOOP_PORT_RESTORER).add(IntermediateProcessorStrategy.SELF_LOOP_ROUTER);
    private static final LayoutProcessorConfiguration<LayeredPhases, LGraph> END_EDGE_LABEL_PROCESSING_ADDITIONS = LayoutProcessorConfiguration.create().addBefore(LayeredPhases.P4_NODE_PLACEMENT, IntermediateProcessorStrategy.END_LABEL_PREPROCESSOR).addAfter(LayeredPhases.P5_EDGE_ROUTING, IntermediateProcessorStrategy.END_LABEL_POSTPROCESSOR);
    private static double ADAPTIVE_SLOPE = 0.012;
    private static int ADAPTIVE_SPACING_STEP_SIZE = 5;
    private static int SIMULINK_GRID_SIZE = 5;

    @Override
    public LayoutProcessorConfiguration<LayeredPhases, LGraph> getLayoutProcessorConfiguration(LGraph graph) {
        Set<GraphProperties> graphProperties = graph.getProperty(InternalProperties.GRAPH_PROPERTIES);
        LayoutProcessorConfiguration<LayeredPhases, LGraph> configuration = LayoutProcessorConfiguration.create();
        if (graphProperties.contains((Object)GraphProperties.HYPEREDGES)) {
            if (!graph.getProperty(LayeredOptions.LAYERING_STRATEGY).equals(LayeringStrategy.INTERACTIVE)) {
                configuration.addAll(HYPEREDGE_PROCESSING_ADDITIONS_NON_INTERACTIVE);
            } else {
                configuration.addAll(HYPEREDGE_PROCESSING_ADDITIONS_INTERACTIVE);
            }
            configuration.addAll(INVERTED_PORT_PROCESSING_ADDITIONS);
        }
        if (graphProperties.contains((Object)GraphProperties.NON_FREE_PORTS)) {
            configuration.addAll(INVERTED_PORT_PROCESSING_ADDITIONS);
            if (graphProperties.contains((Object)GraphProperties.NORTH_SOUTH_PORTS)) {
                configuration.addAll(NORTH_SOUTH_PORT_PROCESSING_ADDITIONS);
            }
        }
        if (graphProperties.contains((Object)GraphProperties.SELF_LOOPS)) {
            configuration.addAll(SELF_LOOP_PROCESSING_ADDITIONS);
        }
        if (graphProperties.contains((Object)GraphProperties.END_LABELS)) {
            configuration.addAll(END_EDGE_LABEL_PROCESSING_ADDITIONS);
        }
        return configuration;
    }

    @Override
    public void process(LGraph layeredGraph, IElkProgressMonitor monitor) {
        monitor.begin("Orthogonal edge routing", 1.0f);
        double nodeNodeSpacing = layeredGraph.getProperty(LayeredOptions.SPACING_NODE_NODE_BETWEEN_LAYERS);
        double adaptiveSpacing = this.getSpacing(layeredGraph);
        double edgeNodeSpacing = layeredGraph.getProperty(LayeredOptions.SPACING_EDGE_NODE_BETWEEN_LAYERS);
        OrthogonalRoutingGenerator routingGenerator = new OrthogonalRoutingGenerator(RoutingDirection.WEST_TO_EAST, adaptiveSpacing, "phase5");
        float xpos = 0.0f;
        ListIterator<Layer> layerIter = layeredGraph.getLayers().listIterator();
        Layer leftLayer = null;
        Layer rightLayer = null;
        List<LNode> leftLayerNodes = null;
        List<LNode> rightLayerNodes = null;
        int leftLayerIndex = -1;
        int rightLayerIndex = -1;
        do {
            boolean isRightLayerExternal;
            rightLayer = layerIter.hasNext() ? layerIter.next() : null;
            rightLayerNodes = rightLayer == null ? null : rightLayer.getNodes();
            rightLayerIndex = layerIter.previousIndex();
            if (leftLayer != null) {
                LGraphUtil.placeNodesHorizontally(leftLayer, xpos);
                xpos = (float)((double)xpos + leftLayer.getSize().x);
            }
            double startPos = leftLayer == null ? (double)xpos : (double)xpos + edgeNodeSpacing;
            Pair<Integer, List<HyperEdgeSegment>> slots = routingGenerator.routeEdges(monitor, layeredGraph, leftLayerNodes, leftLayerIndex, rightLayerNodes, startPos);
            int slotsCount = slots.getFirst();
            boolean isLeftLayerExternal = leftLayer == null;
            boolean bl = isRightLayerExternal = rightLayer == null;
            if (slotsCount > 0) {
                double routingWidth = (double)(slotsCount - 1) * adaptiveSpacing;
                double rightSideAdaptivWidth = edgeNodeSpacing;
                if (this.horizontalEdgeSegmentToCloseToAdjacentNode(slots.getSecond(), layeredGraph, adaptiveSpacing, leftLayerIndex)) {
                    rightSideAdaptivWidth = adaptiveSpacing;
                }
                if (leftLayer != null) {
                    routingWidth += edgeNodeSpacing;
                }
                if (rightLayer != null) {
                    routingWidth += rightSideAdaptivWidth;
                }
                if (routingWidth < nodeNodeSpacing && !isLeftLayerExternal && !isRightLayerExternal) {
                    routingWidth = nodeNodeSpacing;
                }
                xpos = (float)((double)xpos + routingWidth);
            } else if (!isLeftLayerExternal && !isRightLayerExternal) {
                xpos = (float)((double)xpos + nodeNodeSpacing);
            }
            leftLayer = rightLayer;
            leftLayerNodes = rightLayerNodes;
            leftLayerIndex = rightLayerIndex;
        } while (rightLayer != null);
        layeredGraph.getSize().x = xpos;
        monitor.done();
    }

    private boolean horizontalEdgeSegmentToCloseToAdjacentNode(List<HyperEdgeSegment> edgeSegments, LGraph layeredGraph, double edgeEdgeSpacing, int sourceLayerIndex) {
        List<HyperEdgeSegment> highestRoutingSlotEdges = this.getEdgeSegmentsWithHighestRoutingSlot(edgeSegments);
        boolean isToClose = false;
        if (highestRoutingSlotEdges.size() > 0) {
            for (HyperEdgeSegment highestRoutingSlotEdge : highestRoutingSlotEdges) {
                if (!IntStream.range(0, highestRoutingSlotEdge.getPorts().size() - 1).anyMatch(i -> this.checkIfNextToNodeOnRight(sourceLayerIndex, highestRoutingSlotEdge.getPorts().get(0), highestRoutingSlotEdge.getPorts().get(i + 1), layeredGraph))) continue;
                isToClose = true;
            }
        }
        return isToClose;
    }

    private List<HyperEdgeSegment> getEdgeSegmentsWithHighestRoutingSlot(List<HyperEdgeSegment> edgeSegments) {
        int maxRoutingSlot = 0;
        ArrayList<HyperEdgeSegment> highestRoutingSlotEdgeList = new ArrayList<HyperEdgeSegment>();
        for (HyperEdgeSegment edgeSegment : edgeSegments) {
            if (Math.abs(edgeSegment.getStartCoordinate() - edgeSegment.getEndCoordinate()) < 0.001) continue;
            if (edgeSegment.getRoutingSlot() == maxRoutingSlot) {
                highestRoutingSlotEdgeList.add(edgeSegment);
            }
            if (edgeSegment.getRoutingSlot() > maxRoutingSlot) {
                highestRoutingSlotEdgeList.clear();
                highestRoutingSlotEdgeList.add(edgeSegment);
            }
            maxRoutingSlot = Math.max(maxRoutingSlot, edgeSegment.getRoutingSlot());
        }
        return highestRoutingSlotEdgeList;
    }

    private double getSpacing(LGraph layeredGraph) {
        double lowerBoundSpacing = layeredGraph.getProperty(LayeredOptions.SPACING_EDGE_EDGE_OR_EDGE_NODE_BETWEEN_LAYERS_ADAPTIVE_LOWER_BOUND);
        double upperBoundSpacing = layeredGraph.getProperty(LayeredOptions.SPACING_EDGE_EDGE_OR_EDGE_NODE_BETWEEN_LAYERS_ADAPTIVE_UPPER_BOUND);
        double heightOfGraph = layeredGraph.getSize().y;
        return this.getAdaptiveSpacing(heightOfGraph, lowerBoundSpacing, upperBoundSpacing);
    }

    private double getAdaptiveSpacing(double heightOfGraph, double lowerBoundSpacing, double upperBoundSpacing) {
        double adaptiveSpacing = Math.floor((heightOfGraph * ADAPTIVE_SLOPE + lowerBoundSpacing) / (double)ADAPTIVE_SPACING_STEP_SIZE) * (double)ADAPTIVE_SPACING_STEP_SIZE;
        return Math.min(adaptiveSpacing, upperBoundSpacing);
    }

    private boolean checkIfNextToNodeOnRight(int sourceLayerIndex, LPort startPort, LPort connectedPort, LGraph layeredGraph) {
        double minYOfLine = Math.min(startPort.getAbsoluteAnchor().y, connectedPort.getAbsoluteAnchor().y);
        double maxYOfLine = Math.max(startPort.getAbsoluteAnchor().y, connectedPort.getAbsoluteAnchor().y);
        if (layeredGraph.getLayers().size() > sourceLayerIndex + 1) {
            return layeredGraph.getLayers().get(sourceLayerIndex + 1).getNodes().stream().anyMatch(node -> !this.nodeisLongEdge((LNode)node) && this.nodeHasPortsEast((LNode)node) && this.isBiggestInLayerWithMarginAndHasNoLeftLabel((LNode)node) && this.edgeDoesIntersectOnYAxisWithNode(connectedPort, (LNode)node, minYOfLine, maxYOfLine));
        }
        return false;
    }

    private boolean nodeHasPortsEast(LNode node) {
        return node.getPorts(PortSide.EAST).iterator().hasNext();
    }

    private boolean nodeisLongEdge(LNode node) {
        return node.getType().equals((Object)LNode.NodeType.LONG_EDGE);
    }

    private boolean isBiggestInLayerWithMarginAndHasNoLeftLabel(LNode node) {
        double leftLabelWidth;
        double d = leftLabelWidth = node.isWideNode() ? node.getOriginalWideNode().getLeftLabelWidth() : node.getLeftLabelWidth();
        return node.getSize().x + (double)SIMULINK_GRID_SIZE >= node.getLayer().getSize().x && leftLabelWidth == 0.0;
    }

    private boolean edgeDoesIntersectOnYAxisWithNode(LPort targetPort, LNode node, double minYOfLine, double maxYOfLine) {
        return maxYOfLine > node.getPosition().y && minYOfLine < node.getPosition().y + node.getSize().y;
    }
}

