/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.p4nodes.bk;

import com.google.common.collect.Lists;
import com.modelengineers.MoRe_elk.alg.layered.graph.LEdge;
import com.modelengineers.MoRe_elk.alg.layered.graph.LGraph;
import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.alg.layered.graph.Layer;
import com.modelengineers.MoRe_elk.alg.layered.options.LayeredOptions;
import com.modelengineers.MoRe_elk.core.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class NeighborhoodInformation {
    public int nodeCount;
    public int[] layerIndex;
    public int[] nodeIndex;
    public List<List<Pair<LNode, LEdge>>> leftNeighbors;
    public List<List<Pair<LNode, LEdge>>> rightNeighbors;
    public List<List<Pair<LNode, LEdge>>> mostConctdRightNeighbors;
    public List<List<Pair<LNode, LEdge>>> mostConctdLeftNeighbors;
    private NeighborComparator neighborComparator;

    private NeighborhoodInformation() {
    }

    public void cleanup() {
        this.layerIndex = null;
        this.nodeIndex = null;
        this.leftNeighbors.clear();
        this.rightNeighbors.clear();
        this.mostConctdRightNeighbors.clear();
        this.mostConctdLeftNeighbors.clear();
        this.neighborComparator = null;
    }

    public static NeighborhoodInformation buildFor(LGraph graph) {
        NeighborhoodInformation ni = new NeighborhoodInformation();
        ni.nodeCount = 0;
        for (Layer layer : graph) {
            ni.nodeCount += layer.getNodes().size();
        }
        int lId = 0;
        int lIndex = 0;
        ni.layerIndex = new int[graph.getLayers().size()];
        int nId = 0;
        int nIndex = 0;
        ni.nodeIndex = new int[ni.nodeCount];
        for (Layer l : graph.getLayers()) {
            l.id = lId++;
            ni.layerIndex[l.id] = lIndex++;
            nIndex = 0;
            for (LNode n : l.getNodes()) {
                n.id = nId++;
                ni.nodeIndex[n.id] = nIndex++;
            }
        }
        NeighborhoodInformation neighborhoodInformation = ni;
        neighborhoodInformation.getClass();
        ni.neighborComparator = neighborhoodInformation.new NeighborComparator();
        ni.leftNeighbors = Lists.newArrayListWithCapacity((int)ni.nodeCount);
        NeighborhoodInformation.determineAllLeftNeighbors(ni, graph);
        ni.rightNeighbors = Lists.newArrayListWithCapacity((int)ni.nodeCount);
        NeighborhoodInformation.determineAllRightNeighbors(ni, graph);
        ni.mostConctdRightNeighbors = Lists.newArrayListWithCapacity((int)ni.nodeCount);
        NeighborhoodInformation.determineAllRightNeighborsSortedByNumConnections(ni, graph);
        ni.mostConctdLeftNeighbors = Lists.newArrayListWithCapacity((int)ni.nodeCount);
        NeighborhoodInformation.determineAllLeftNeighborsSortedByNumConnections(ni, graph);
        return ni;
    }

    private static void determineAllRightNeighbors(NeighborhoodInformation ni, LGraph graph) {
        for (Layer l : graph) {
            for (LNode n : l) {
                List<Pair<LNode, LEdge>> result = NeighborhoodInformation.getAllTargetNodesAndConnectingEdges(n);
                Collections.sort(result, ni.neighborComparator);
                ni.rightNeighbors.add(n.id, result);
            }
        }
    }

    private static void determineAllRightNeighborsSortedByNumConnections(NeighborhoodInformation ni, LGraph graph) {
        for (Layer l : graph) {
            for (LNode n : l) {
                List<Pair<LNode, LEdge>> result = NeighborhoodInformation.getAllTargetNodesAndConnectingEdges(n);
                if (!result.isEmpty()) {
                    NeighborhoodInformation.sortListOfPairsByFrequencyOfOccuranceOfNode(result, ni);
                }
                ni.mostConctdRightNeighbors.add(n.id, result);
            }
        }
    }

    private static List<Pair<LNode, LEdge>> getAllTargetNodesAndConnectingEdges(LNode n) {
        ArrayList result = Lists.newArrayList();
        int maxPriority = 0;
        for (LEdge edge : n.getOutgoingEdges()) {
            if (edge.isSelfLoop() || edge.isInLayerEdge()) continue;
            int edgePrio = edge.getProperty(LayeredOptions.PRIORITY_STRAIGHTNESS);
            if (edgePrio > maxPriority) {
                maxPriority = edgePrio;
                result.clear();
            }
            if (edgePrio != maxPriority) continue;
            result.add(Pair.of(edge.getTarget().getNode(), edge));
        }
        return result;
    }

    private static void determineAllLeftNeighbors(NeighborhoodInformation ni, LGraph graph) {
        for (Layer l : graph) {
            for (LNode n : l) {
                List<Pair<LNode, LEdge>> result = NeighborhoodInformation.getAllSourceNodesAndConnectingEdges(n);
                Collections.sort(result, ni.neighborComparator);
                ni.leftNeighbors.add(n.id, result);
            }
        }
    }

    private static void determineAllLeftNeighborsSortedByNumConnections(NeighborhoodInformation ni, LGraph graph) {
        for (Layer l : graph) {
            for (LNode n : l) {
                List<Pair<LNode, LEdge>> result = NeighborhoodInformation.getAllSourceNodesAndConnectingEdges(n);
                if (!result.isEmpty()) {
                    NeighborhoodInformation.sortListOfPairsByFrequencyOfOccuranceOfNode(result, ni);
                }
                ni.mostConctdLeftNeighbors.add(n.id, result);
            }
        }
    }

    private static List<Pair<LNode, LEdge>> getAllSourceNodesAndConnectingEdges(LNode n) {
        ArrayList result = Lists.newArrayList();
        int maxPriority = 0;
        for (LEdge edge : n.getIncomingEdges()) {
            if (edge.isSelfLoop() || edge.isInLayerEdge()) continue;
            int edgePrio = edge.getProperty(LayeredOptions.PRIORITY_STRAIGHTNESS);
            if (edgePrio > maxPriority) {
                maxPriority = edgePrio;
                result.clear();
            }
            if (edgePrio != maxPriority) continue;
            result.add(Pair.of(edge.getSource().getNode(), edge));
        }
        return result;
    }

    private static void sortListOfPairsByFrequencyOfOccuranceOfNode(List<Pair<LNode, LEdge>> listOfPairs, final NeighborhoodInformation ni) {
        final Map<LNode, Integer> frequencyMap = NeighborhoodInformation.getNumberOfConnectingEdgesMap(listOfPairs);
        Collections.sort(listOfPairs, new Comparator<Pair<LNode, LEdge>>(){

            @Override
            public int compare(Pair<LNode, LEdge> pair1, Pair<LNode, LEdge> pair2) {
                int freq1 = (Integer)frequencyMap.get(pair1.getFirst());
                int freq2 = (Integer)frequencyMap.get(pair2.getFirst());
                int result = Integer.compare(freq2, freq1);
                if (result == 0) {
                    result = ni.neighborComparator.compare(pair1, pair2);
                }
                return result;
            }
        });
    }

    private static Map<LNode, Integer> getNumberOfConnectingEdgesMap(List<Pair<LNode, LEdge>> listOfPairs) {
        LinkedHashMap<LNode, Integer> frequencyMap = new LinkedHashMap<LNode, Integer>();
        for (Pair<LNode, LEdge> pair : listOfPairs) {
            if (frequencyMap.containsKey(pair.getFirst())) {
                frequencyMap.put(pair.getFirst(), (Integer)frequencyMap.get(pair.getFirst()) + 1);
                continue;
            }
            frequencyMap.put(pair.getFirst(), 1);
        }
        return frequencyMap;
    }

    private final class NeighborComparator
    implements Comparator<Pair<LNode, LEdge>> {
        private NeighborComparator() {
        }

        @Override
        public int compare(Pair<LNode, LEdge> o1, Pair<LNode, LEdge> o2) {
            int cmp = NeighborhoodInformation.this.nodeIndex[o1.getFirst().id] - NeighborhoodInformation.this.nodeIndex[o2.getFirst().id];
            return (int)Math.signum(cmp);
        }
    }
}

