/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.p3order.mes;

import com.modelengineers.MoRe_elk.alg.layered.graph.LEdge;
import com.modelengineers.MoRe_elk.alg.layered.graph.LGraph;
import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.alg.layered.graph.LPort;
import com.modelengineers.MoRe_elk.alg.layered.mesutils.MesUtilMethods;
import com.modelengineers.MoRe_elk.alg.layered.options.InternalProperties;
import com.modelengineers.MoRe_elk.alg.layered.p3order.mes.BinaryOrderProblem;
import com.modelengineers.MoRe_elk.core.options.PortSide;
import java.util.List;

public class TwigBelowSplitEdgeConstraint {
    public TwigBelowSplitEdgeConstraint(LGraph graph, BinaryOrderProblem orderProblem) {
        graph.getLayers().forEach(l -> MesUtilMethods.getAllPairsAsStream(l.getNodes()).forEach(p -> this.setConstraintIfDesired((LNode)p.getFirst(), (LNode)p.getSecond(), orderProblem)));
    }

    private void setConstraintIfDesired(LNode presumedTwigEnd, LNode presumedLongEdgeDummy, BinaryOrderProblem orderProblem) {
        if (TwigBelowSplitEdgeConstraint.isTwigEndInSameTreeAsLongEdgeDummy(presumedTwigEnd, presumedLongEdgeDummy) && this.targetOfLongEdgeDummyIsBehindTwigEnd(presumedTwigEnd, presumedLongEdgeDummy)) {
            orderProblem.setFirstNodeAboveSecondNode(presumedLongEdgeDummy, presumedTwigEnd);
        }
    }

    private static boolean isTwigEndInSameTreeAsLongEdgeDummy(LNode presumedTwigEnd, LNode presumedLongEdgeDummy) {
        return presumedLongEdgeDummy.isLongEdge() && TwigBelowSplitEdgeConstraint.isTwigEnd(presumedTwigEnd) && TwigBelowSplitEdgeConstraint.getSourceSkippingLinearNodes(presumedTwigEnd.getTrueIncomingEdges().get(0)) == presumedLongEdgeDummy.getProperty(InternalProperties.LONG_EDGE_SOURCE);
    }

    private static boolean isTwigEnd(LNode node) {
        return !node.isLongEdge() && !node.hasTrueNorthSouthPort() && !node.isNorthSouthDummy() && node.getTrueConnectedNodes().size() == 1 && node.getTrueIncomingEdges().size() == 1;
    }

    private static LPort getSourceSkippingLinearNodes(LEdge edge) {
        LPort curPort = edge.getPort(false);
        while (TwigBelowSplitEdgeConstraint.isLinearNode(curPort.getNode())) {
            curPort = curPort.getNode().getTrueEdges(false).get(0).getPort(false);
        }
        return curPort;
    }

    private static boolean isLinearNode(LNode node) {
        return TwigBelowSplitEdgeConstraint.hasExactlyOneIncomingEdgeOnWestSide(node) && TwigBelowSplitEdgeConstraint.hasExactlyOneOutgoingEdgeOnWestSide(node) && !node.hasTrueNorthSouthPort();
    }

    private static boolean hasExactlyOneIncomingEdgeOnWestSide(LNode node) {
        List<LEdge> trueIncomingEdges = node.getTrueIncomingEdges();
        return trueIncomingEdges.size() == 1 && trueIncomingEdges.get(0).getTarget().getSide().equals((Object)PortSide.WEST);
    }

    private static boolean hasExactlyOneOutgoingEdgeOnWestSide(LNode node) {
        List<LEdge> trueOutgoingEdges = node.getTrueOutgoingEdges();
        return trueOutgoingEdges.size() == 1 && trueOutgoingEdges.get(0).getSource().getSide().equals((Object)PortSide.EAST);
    }

    private boolean targetOfLongEdgeDummyIsBehindTwigEnd(LNode twigEnd, LNode longEgdeDummy) {
        return twigEnd.getLastWideNodeDummy().getLayer().getIndex() < longEgdeDummy.getProperty(InternalProperties.LONG_EDGE_TARGET).getNode().getLayer().getIndex();
    }
}

