/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.p3order.mes;

import com.google.common.collect.Lists;
import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.alg.layered.mesutils.MesUtilMethods;
import com.modelengineers.MoRe_elk.core.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ReachableNodesDetector {
    private Map<Pair<LNode, Boolean>, List<LNode>> reachableNodes = new HashMap<Pair<LNode, Boolean>, List<LNode>>();
    private List<Pair<LNode, Boolean>> visited = Lists.newArrayList();

    public List<LNode> detect(LNode startNode, boolean forward) {
        Pair<LNode, Boolean> key = new Pair<LNode, Boolean>(startNode, forward);
        if (!this.reachableNodes.containsKey(key)) {
            this.reachableNodes.put(key, this.compute(startNode, forward));
        }
        return this.reachableNodes.get(key);
    }

    private List<LNode> compute(LNode node, boolean forward) {
        if (this.markVisited(node, forward)) {
            return this.computeFromNewNode(node, forward);
        }
        return Lists.newArrayList();
    }

    private boolean markVisited(LNode node, boolean forward) {
        Pair<LNode, Boolean> key = new Pair<LNode, Boolean>(node, forward);
        if (!this.visited.contains(key)) {
            this.visited.add(key);
            return true;
        }
        return false;
    }

    private List<LNode> computeFromNewNode(LNode node, boolean forward) {
        List<LNode> directlyConnectedNodes = ReachableNodesDetector.getDirectlyConnectedNodes(node, forward);
        List<LNode> indirectlyConnectedNodes = this.getIndirectlyConnectedNodes(directlyConnectedNodes, forward);
        return MesUtilMethods.concatLists(directlyConnectedNodes, indirectlyConnectedNodes);
    }

    private static List<LNode> getDirectlyConnectedNodes(LNode node, boolean forward) {
        if (node.isNorthSouthDummy()) {
            return ReachableNodesDetector.getDirectlyConnectedNodesOfNorthSouthDummy(node, forward);
        }
        return MesUtilMethods.concatLists(node.getConnectedNodes(forward), node.getNorthSouthPortDummies());
    }

    private static List<LNode> getDirectlyConnectedNodesOfNorthSouthDummy(LNode node, boolean forward) {
        ArrayList connectedNodes = node.getConnectedNodes(forward);
        return connectedNodes.isEmpty() ? Lists.newArrayList((Object[])new LNode[]{node.getOriginPort().getNode()}) : connectedNodes;
    }

    private List<LNode> getIndirectlyConnectedNodes(List<LNode> directlyConnectedNodes, boolean forward) {
        return directlyConnectedNodes.stream().flatMap(n -> this.detect((LNode)n, forward).stream()).collect(Collectors.toList());
    }
}

