/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.p3order.mes;

import com.modelengineers.MoRe_elk.alg.layered.graph.LGraph;
import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.alg.layered.graph.LPort;
import com.modelengineers.MoRe_elk.alg.layered.graph.Layer;
import com.modelengineers.MoRe_elk.alg.layered.mesutils.MesUtilMethods;
import com.modelengineers.MoRe_elk.core.math.KVector;
import com.modelengineers.MoRe_elk.core.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NodeCombinerCore {
    private LGraph graph;
    private Map<Layer, List<LNode>> nodesOfLayerBefore = new HashMap<Layer, List<LNode>>();
    private Map<LNode, List<LPort>> portsOfNodeBefore = new HashMap<LNode, List<LPort>>();
    private Map<LPort, LNode> nodeOfPortBefore = new HashMap<LPort, LNode>();
    private Map<LPort, KVector> positionOfPortBefore = new HashMap<LPort, KVector>();
    private Map<LNode, LNode> nodeCombinedInto = new HashMap<LNode, LNode>();

    public NodeCombinerCore(LGraph graph) {
        this.graph = graph;
        this.saveStateBefore();
    }

    private void saveStateBefore() {
        this.graph.getLayers().forEach(l -> {
            ArrayList<LNode> arrayList = this.nodesOfLayerBefore.put((Layer)l, (List<LNode>)new ArrayList<LNode>(l.getNodes()));
        });
        this.graph.getNodesFromAllLayers().forEach(this::saveStateBefore);
    }

    private void saveStateBefore(LNode node) {
        this.portsOfNodeBefore.put(node, new ArrayList<LPort>(node.getPorts()));
        node.getPorts().forEach(this::saveStateBefore);
    }

    private void saveStateBefore(LPort port) {
        this.nodeOfPortBefore.put(port, port.getNode());
        this.positionOfPortBefore.put(port, new KVector(port.getPosition()));
    }

    public void combine(List<Pair<LNode, LNode>> pairs) {
        pairs.forEach(p -> this.combine((Pair<LNode, LNode>)p));
    }

    private void combine(Pair<LNode, LNode> pair) {
        LNode upperNodeToCombine = this.getNodeToCombine(pair.getFirst());
        LNode lowerNodeToCombine = this.getNodeToCombine(pair.getSecond());
        LNode newNode = this.combine(upperNodeToCombine, lowerNodeToCombine);
        this.updateNodeCombinedIntoMap(newNode);
    }

    private LNode getNodeToCombine(LNode node) {
        return this.nodeCombinedInto.containsKey(node) ? this.nodeCombinedInto.get(node) : node;
    }

    private LNode combine(LNode upperNode, LNode lowerNode) {
        assert (this.nodesCanBeCombined(upperNode, lowerNode));
        LNode newNode = this.replaceByNewNode(upperNode, lowerNode);
        this.setSize(newNode, upperNode, lowerNode);
        this.transferPorts(upperNode, lowerNode, newNode);
        this.setCombinedNodes(newNode, upperNode, lowerNode);
        return newNode;
    }

    private boolean nodesCanBeCombined(LNode a, LNode b) {
        return a != b && this.nodeCanBeCombined(a) && this.nodeCanBeCombined(b) && a.getLayer() == b.getLayer();
    }

    private boolean nodeCanBeCombined(LNode node) {
        return node.getLayer() != null && !node.isNorthSouthDummy() && !node.hasNorthSouthPort();
    }

    private LNode replaceByNewNode(LNode upperNode, LNode lowerNode) {
        LNode newNode = new LNode(upperNode.getGraph());
        newNode.setLayer(upperNode.getIndex(), upperNode.getLayer());
        upperNode.setLayer(null);
        lowerNode.setLayer(null);
        return newNode;
    }

    private void setSize(LNode newNode, LNode upperNode, LNode lowerNode) {
        newNode.getSize().x = Math.max(upperNode.getSize().x, lowerNode.getSize().x);
        newNode.getSize().y = upperNode.getSize().y + lowerNode.getSize().y;
    }

    private void transferPorts(LNode upperNode, LNode lowerNode, LNode newNode) {
        this.transferPorts(upperNode, newNode, 0.0);
        this.transferPorts(lowerNode, newNode, upperNode.getSize().y);
    }

    private void transferPorts(LNode source, LNode target, double yOffset) {
        MesUtilMethods.iterableToList(source.getPorts()).stream().filter(LPort::hasEdges).forEach(p -> this.transferPort((LPort)p, target, yOffset));
    }

    private void transferPort(LPort port, LNode target, double yOffset) {
        port.setNode(target);
        port.getPosition().y += yOffset;
    }

    private void setCombinedNodes(LNode newNode, LNode upperNode, LNode lowerNode) {
        List<LNode> combinedNodes = newNode.getCombinedNodes();
        combinedNodes.addAll(upperNode.getCombinedNodesOrNodeItself());
        combinedNodes.addAll(lowerNode.getCombinedNodesOrNodeItself());
    }

    private void updateNodeCombinedIntoMap(LNode newNode) {
        newNode.getCombinedNodes().forEach(n -> {
            LNode lNode2 = this.nodeCombinedInto.put((LNode)n, newNode);
        });
    }

    public void decombine(boolean restoreNodeOrder) {
        this.decombine();
        if (restoreNodeOrder) {
            this.restoreNodeOrder();
        }
    }

    private void decombine() {
        this.graph.getNodesFromAllLayers().stream().filter(LNode::isCombined).forEach(n -> this.decombine((LNode)n));
        this.graph.getNodesFromAllLayers().forEach(n -> this.restorePortOrder((LNode)n));
    }

    private void decombine(LNode node) {
        this.decombineNodes(node);
        this.decombinePorts(node);
    }

    private void decombineNodes(LNode node) {
        int ixNode = node.getIndex();
        Layer layer = node.getLayer();
        node.setLayer(null);
        for (LNode n : node.getCombinedNodes()) {
            n.setLayer(ixNode++, layer);
        }
    }

    private void decombinePorts(LNode node) {
        MesUtilMethods.iterableToList(node.getPorts()).forEach(p -> {
            p.setNode(this.nodeOfPortBefore.get(p));
            p.getPosition().set(this.positionOfPortBefore.get(p));
        });
    }

    private void restorePortOrder(LNode node) {
        assert (MesUtilMethods.setEquals(node.getPorts(), this.portsOfNodeBefore.get(node)));
        MesUtilMethods.replaceElements(node.getPorts(), this.portsOfNodeBefore.get(node));
    }

    public void restoreNodeOrder() {
        this.graph.getLayers().forEach(this::restoreNodeOrder);
    }

    private void restoreNodeOrder(Layer layer) {
        assert (MesUtilMethods.setEquals(layer.getNodes(), this.nodesOfLayerBefore.get(layer)));
        MesUtilMethods.replaceElements(layer.getNodes(), this.nodesOfLayerBefore.get(layer));
    }
}

