/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.p3order.mes;

import com.google.ortools.sat.Literal;
import com.modelengineers.MoRe_elk.alg.layered.ortools.CpSolverWrapper;
import com.modelengineers.MoRe_elk.alg.layered.p3order.mes.BinaryOrderProblem;
import com.modelengineers.MoRe_elk.alg.layered.p3order.mes.CEdge;
import com.modelengineers.MoRe_elk.alg.layered.p3order.mes.ICrossingObjectiveCore;
import com.modelengineers.MoRe_elk.core.options.PortSide;

public class MixedCrossing
implements ICrossingObjectiveCore {
    private CEdge edgeA;
    private CEdge edgeB;
    private BinaryOrderProblem orderProblem;
    private CpSolverWrapper solverWrapper;

    public MixedCrossing(CEdge edgeA, CEdge edgeB, BinaryOrderProblem orderProblem) {
        this.edgeA = edgeA;
        this.edgeB = edgeB;
        this.orderProblem = orderProblem;
        this.solverWrapper = orderProblem.getSolverWrapper();
    }

    @Override
    public boolean noObjectiveNeeded() {
        return this.edgeA.hasCommonPortWith(this.edgeB);
    }

    @Override
    public Literal getLiteral() {
        CEdge inLayerEdge = this.getInLayerEdge();
        CEdge interLayerEdge = this.getInterLayerEdge();
        return inLayerEdge.getInLayerSide() == PortSide.EAST ? this.getCrossingOnSourceSide(inLayerEdge, interLayerEdge) : this.getCrossingOnTargetSide(inLayerEdge, interLayerEdge);
    }

    private CEdge getInLayerEdge() {
        return this.edgeA.isInLayerEdge() ? this.edgeA : this.edgeB;
    }

    private CEdge getInterLayerEdge() {
        return this.edgeA.isInLayerEdge() ? this.edgeB : this.edgeA;
    }

    private Literal getCrossingOnSourceSide(CEdge inLayerEdge, CEdge interLayerEdge) {
        Literal interLayerSourceBelowInLayerSource = this.orderProblem.sourceOfFirstEdgeIsBelowSourceOfSecondEdge(interLayerEdge, inLayerEdge);
        Literal interLayerSourceBelowInLayerTarget = this.orderProblem.sourceOfFirstEdgeIsBelowTargetOfSecondEdge(interLayerEdge, inLayerEdge);
        return this.solverWrapper.xor(interLayerSourceBelowInLayerSource, interLayerSourceBelowInLayerTarget);
    }

    private Literal getCrossingOnTargetSide(CEdge inLayerEdge, CEdge interLayerEdge) {
        Literal interLayerTargetBelowInLayerTarget = this.orderProblem.targetOfFirstEdgeIsBelowTargetOfSecondEdge(interLayerEdge, inLayerEdge);
        Literal interLayerTargetBelowInLayerSource = this.orderProblem.targetOfFirstEdgeIsBelowSourceOfSecondEdge(interLayerEdge, inLayerEdge);
        return this.solverWrapper.xor(interLayerTargetBelowInLayerSource, interLayerTargetBelowInLayerTarget);
    }
}

