/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.p3order.mes;

import com.google.common.collect.Lists;
import com.modelengineers.MoRe_elk.alg.layered.graph.LEdge;
import com.modelengineers.MoRe_elk.alg.layered.graph.LGraph;
import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.alg.layered.graph.Layer;
import com.modelengineers.MoRe_elk.alg.layered.p3order.mes.BinaryOrderProblem;
import com.modelengineers.MoRe_elk.alg.layered.p3order.mes.CEdge;
import com.modelengineers.MoRe_elk.alg.layered.p3order.mes.CrossingObjectivesFactory;
import com.modelengineers.MoRe_elk.alg.layered.p3order.mes.IObjective;
import com.modelengineers.MoRe_elk.alg.layered.p3order.mes.NodeOrderObjective;
import com.modelengineers.MoRe_elk.alg.layered.p3order.mes.NorthSouthDummiesNextToCorrespondingNodeConstraint;
import com.modelengineers.MoRe_elk.alg.layered.p3order.mes.TwigBelowSplitEdgeConstraint;
import com.modelengineers.MoRe_elk.core.options.PortSide;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class MesCrossingMinimizer {
    private LGraph graph;
    private BinaryOrderProblem orderProblem;

    public MesCrossingMinimizer(LGraph layeredGraph) {
        this.graph = layeredGraph;
    }

    public void order() throws InterruptedException {
        this.constructOrderProblem();
        this.orderProblem.findBestOrder();
        this.orderProblem.transferOrderOnNodeIndices();
    }

    private void constructOrderProblem() {
        this.orderProblem = new BinaryOrderProblem(this.graph);
        this.addObjectivesToOrderProblem();
        this.addConstraintsToOrderProblem();
    }

    private void addObjectivesToOrderProblem() {
        this.addCrossingObjectives();
        this.addNodeOrderObjectives();
    }

    private void addCrossingObjectives() {
        this.addObjectivesForLeftOutsideCrossings();
        this.addObjectivesForCrossingsWithinLayers();
        this.addObjectivesForRightOutsideCrossings();
    }

    private void addObjectivesForLeftOutsideCrossings() {
        Layer firstLayer = this.graph.getFirstLayer();
        this.addObjectivesForInLayerCrossingsOnWestSide(firstLayer);
    }

    private void addObjectivesForInLayerCrossingsOnWestSide(Layer layer) {
        List<CEdge> inLayerEdgesOnWestSide = this.getOutgoingEdgesOnWestSide(layer);
        this.addCrossingObjectives(inLayerEdgesOnWestSide);
    }

    private List<CEdge> getOutgoingEdgesOnWestSide(Layer layer) {
        return this.getEdgesOfAllNodes(layer, node -> this.getOutgoingEdgesOnWestSide((LNode)node));
    }

    private List<CEdge> getOutgoingEdgesOnWestSide(LNode node) {
        return this.getOutgoingEdgesOnSide(node, PortSide.WEST);
    }

    private void addObjectivesForCrossingsWithinLayers() {
        int ixLayer = 0;
        while (ixLayer < this.graph.getLayers().size() - 1) {
            Layer leftLayer = this.graph.getLayers().get(ixLayer);
            Layer rightLayer = this.graph.getLayers().get(ixLayer + 1);
            this.addObjectivesForCrossingsWithin(leftLayer, rightLayer);
            ++ixLayer;
        }
    }

    private void addObjectivesForCrossingsWithin(Layer leftLayer, Layer rightLayer) {
        List<CEdge> edges = this.getEdgesBetweenLayers(leftLayer, rightLayer);
        this.addCrossingObjectives(edges);
    }

    private List<CEdge> getEdgesBetweenLayers(Layer leftLayer, Layer rightLayer) {
        ArrayList edges = Lists.newArrayList();
        edges.addAll(this.getOutgoingEdgesOnEastSide(leftLayer));
        edges.addAll(this.getOutgoingEdgesOnWestSide(rightLayer));
        return edges;
    }

    private List<CEdge> getOutgoingEdgesOnEastSide(Layer layer) {
        return this.getEdgesOfAllNodes(layer, node -> this.getOutgoingEdgesOnEastSide((LNode)node));
    }

    private List<CEdge> getEdgesOfAllNodes(Layer layer, Function<LNode, List<CEdge>> getEdges) {
        return layer.getNodes().stream().flatMap(n -> ((List)getEdges.apply((LNode)n)).stream()).collect(Collectors.toList());
    }

    private List<CEdge> getOutgoingEdgesOnEastSide(LNode node) {
        return MesCrossingMinimizer.hasOnlyWideNodeInnerEdgesToNextLayer(node) ? this.getInnerWideNodeEdgeToNextLayer(node) : this.getOutgoingEdgesOnSide(node, PortSide.EAST);
    }

    private static boolean hasOnlyWideNodeInnerEdgesToNextLayer(LNode node) {
        return node.isNonLastWideNodeDummy();
    }

    private List<CEdge> getInnerWideNodeEdgeToNextLayer(LNode node) {
        LEdge innerWideNodeEdgeToNextLayer = node.getOutgoingEdgesAsList().stream().filter(e -> e.getSource().isWideNodeInnerPort()).findFirst().orElse(null);
        return Lists.newArrayList((Object[])new CEdge[]{new CEdge(innerWideNodeEdgeToNextLayer)});
    }

    private List<CEdge> getOutgoingEdgesOnSide(LNode node, PortSide portSide) {
        ArrayList outEdgesOnSide = Lists.newArrayList();
        node.getOutgoingEdgesAsList().stream().filter(outEdge -> outEdge.getSource().getSide() == portSide).forEach(edge -> {
            boolean bl = outEdgesOnSide.add(new CEdge((LEdge)edge));
        });
        return outEdgesOnSide;
    }

    private void addObjectivesForRightOutsideCrossings() {
        Layer lastLayer = this.graph.getLastLayer();
        this.addObjectivesForInLayerCrossingsOnEastSide(lastLayer);
    }

    private void addObjectivesForInLayerCrossingsOnEastSide(Layer layer) {
        List<CEdge> inLayerEdgesOnEastSide = this.getOutgoingEdgesOnEastSide(layer);
        this.addCrossingObjectives(inLayerEdgesOnEastSide);
    }

    private void addCrossingObjectives(List<CEdge> edges) {
        MesCrossingMinimizer.forEachPair(edges, (edgeA, edgeB) -> this.addCrossingObjectives((CEdge)edgeA, (CEdge)edgeB));
    }

    private void addCrossingObjectives(CEdge edgeA, CEdge edgeB) {
        this.orderProblem.addObjectives(this.getCrossingObjectives(edgeA, edgeB));
    }

    private List<IObjective> getCrossingObjectives(CEdge edgeA, CEdge edgeB) {
        return new CrossingObjectivesFactory(this.orderProblem).createObjectives(edgeA, edgeB);
    }

    private void addNodeOrderObjectives() {
        this.graph.getLayers().forEach(layer -> this.addNodeOrderObjectivesInLayer((Layer)layer));
    }

    private void addNodeOrderObjectivesInLayer(Layer layer) {
        List<LNode> nodes = layer.getNodes();
        MesCrossingMinimizer.forEachPair(nodes, (nodeA, nodeB) -> this.addNodeOrderObjectives((LNode)nodeA, (LNode)nodeB));
    }

    public static <T> void forEachPair(List<T> list, BiConsumer<T, T> action) {
        int i = 0;
        while (i < list.size()) {
            int j = i + 1;
            while (j < list.size()) {
                action.accept(list.get(i), list.get(j));
                ++j;
            }
            ++i;
        }
    }

    private void addNodeOrderObjectives(LNode nodeA, LNode nodeB) {
        NodeOrderObjective nodeOrderObjective = new NodeOrderObjective(nodeA, nodeB, this.orderProblem);
        this.orderProblem.addObjective(nodeOrderObjective);
    }

    private void addConstraintsToOrderProblem() {
        new NorthSouthDummiesNextToCorrespondingNodeConstraint(this.graph, this.orderProblem);
        new TwigBelowSplitEdgeConstraint(this.graph, this.orderProblem);
    }
}

