/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.p3order.mes;

import com.google.ortools.sat.BoolVar;
import com.google.ortools.sat.Literal;
import com.modelengineers.MoRe_elk.alg.layered.ortools.CpSolverWrapper;
import com.modelengineers.MoRe_elk.alg.layered.p3order.mes.BinaryOrderProblem;
import com.modelengineers.MoRe_elk.alg.layered.p3order.mes.CEdge;
import com.modelengineers.MoRe_elk.alg.layered.p3order.mes.ICrossingObjectiveCore;

public class InLayerCrossing
implements ICrossingObjectiveCore {
    private CEdge edgeA;
    private CEdge edgeB;
    private BinaryOrderProblem orderProblem;
    private CpSolverWrapper solverWrapper;

    public InLayerCrossing(CEdge edgeA, CEdge edgeB, BinaryOrderProblem orderProblem) {
        this.edgeA = edgeA;
        this.edgeB = edgeB;
        this.orderProblem = orderProblem;
        this.solverWrapper = orderProblem.getSolverWrapper();
    }

    @Override
    public boolean noObjectiveNeeded() {
        return this.edgeA.hasSameSourceAndTargetNodeAs(this.edgeB) || this.edgeA.hasCommonPortWith(this.edgeB);
    }

    @Override
    public Literal getLiteral() {
        Literal sourceABelowSourceB = this.orderProblem.sourceOfFirstEdgeIsBelowSourceOfSecondEdge(this.edgeA, this.edgeB);
        Literal sourceABelowTargetB = this.orderProblem.sourceOfFirstEdgeIsBelowTargetOfSecondEdge(this.edgeA, this.edgeB);
        Literal targetABelowSourceB = this.orderProblem.targetOfFirstEdgeIsBelowSourceOfSecondEdge(this.edgeA, this.edgeB);
        Literal targetABelowTargetB = this.orderProblem.targetOfFirstEdgeIsBelowTargetOfSecondEdge(this.edgeA, this.edgeB);
        BoolVar sourceABetweenB = this.solverWrapper.xor(sourceABelowSourceB, sourceABelowTargetB);
        BoolVar targetABetweenB = this.solverWrapper.xor(targetABelowSourceB, targetABelowTargetB);
        return this.solverWrapper.xor(sourceABetweenB, targetABetweenB);
    }
}

