/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.p3order.mes;

import com.modelengineers.MoRe_elk.alg.layered.graph.LEdge;
import com.modelengineers.MoRe_elk.alg.layered.graph.LGraph;
import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.alg.layered.graph.LPort;
import com.modelengineers.MoRe_elk.alg.layered.mesutils.MesUtilMethods;
import com.modelengineers.MoRe_elk.core.math.KVector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GraphSimplifierCheck {
    private LGraph graph;
    private List<LNode> nodesFromAllLayersBefore;
    private Map<LNode, List<LPort>> portsOfNodeBefore = new HashMap<LNode, List<LPort>>();
    private Map<LPort, List<LEdge>> incomingEdgesOfPortBefore = new HashMap<LPort, List<LEdge>>();
    private Map<LPort, List<LEdge>> outgoingEdgesOfPortBefore = new HashMap<LPort, List<LEdge>>();
    private Map<LPort, KVector> positionOfPortBefore = new HashMap<LPort, KVector>();

    public GraphSimplifierCheck(LGraph graph) {
        this.graph = graph;
        assert (this.saveStateBefore());
    }

    private boolean saveStateBefore() {
        this.nodesFromAllLayersBefore = new ArrayList<LNode>(this.graph.getNodesFromAllLayers());
        this.nodesFromAllLayersBefore.forEach(n -> {
            ArrayList<LPort> arrayList = this.portsOfNodeBefore.put((LNode)n, (List<LPort>)new ArrayList<LPort>(n.getPorts()));
        });
        this.nodesFromAllLayersBefore.forEach(n -> n.getPorts().forEach(this::saveStateBefore));
        return true;
    }

    private void saveStateBefore(LPort port) {
        this.incomingEdgesOfPortBefore.put(port, new ArrayList<LEdge>(port.getIncomingEdges()));
        this.outgoingEdgesOfPortBefore.put(port, new ArrayList<LEdge>(port.getOutgoingEdges()));
        this.positionOfPortBefore.put(port, new KVector(port.getPosition()));
    }

    public void assertGraphIsOk(boolean checkNodeOrder) {
        assert (this.graphIsOk(checkNodeOrder));
    }

    private boolean graphIsOk(boolean checkNodeOrder) {
        return this.nodesAreSameAsBefore(checkNodeOrder) && this.nodesHaveSamePortsAsBefore() && this.portsAreOk();
    }

    private boolean nodesAreSameAsBefore(boolean checkNodeOrder) {
        return checkNodeOrder ? this.nodesFromAllLayersBefore.equals(this.graph.getNodesFromAllLayers()) : MesUtilMethods.setEquals(this.nodesFromAllLayersBefore, this.graph.getNodesFromAllLayers());
    }

    private boolean nodesHaveSamePortsAsBefore() {
        return this.graph.getNodesFromAllLayers().stream().allMatch(n -> n.getPorts().equals(this.portsOfNodeBefore.get(n)));
    }

    private boolean portsAreOk() {
        return this.graph.getNodesFromAllLayers().stream().flatMap(n -> n.getPorts().stream()).allMatch(p -> this.portIsOk((LPort)p));
    }

    private boolean portIsOk(LPort port) {
        return port.getIncomingEdges().equals(this.incomingEdgesOfPortBefore.get(port)) && port.getOutgoingEdges().equals(this.outgoingEdgesOfPortBefore.get(port)) && port.getPosition().equals(this.positionOfPortBefore.get(port));
    }
}

