/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.p3order.mes;

import com.google.common.collect.Lists;
import com.modelengineers.MoRe_elk.alg.layered.graph.LEdge;
import com.modelengineers.MoRe_elk.alg.layered.graph.LGraph;
import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.alg.layered.graph.LPort;
import com.modelengineers.MoRe_elk.alg.layered.mesutils.MesUtilMethods;
import com.modelengineers.MoRe_elk.core.options.PortSide;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EdgeCombiner {
    private LGraph graph;
    private List<LEdge> edgesCombinedInto = Lists.newArrayList();
    private List<LEdge> currentEdgesToCombine = Lists.newArrayList();
    private Map<LEdge, LPort> sourceOfEdgeBefore = new HashMap<LEdge, LPort>();
    private Map<LEdge, LPort> targetOfEdgeBefore = new HashMap<LEdge, LPort>();

    public EdgeCombiner(LGraph graph) {
        this.graph = graph;
    }

    public void combine() {
        this.graph.getNodesFromAllLayers().stream().forEach(n -> this.combineEastOutEdges((LNode)n));
    }

    private void combineEastOutEdges(LNode node) {
        List<LPort> eastPorts = node.getPortsSortedTopToBottom(PortSide.EAST);
        int ix = 0;
        while (ix < eastPorts.size()) {
            this.tryToCombineOutEdgeWithPreviousEdges(eastPorts.get(ix), ix == eastPorts.size() - 1);
            ++ix;
        }
    }

    private void tryToCombineOutEdgeWithPreviousEdges(LPort eastPort, boolean isLastPort) {
        LEdge edge = EdgeCombiner.getCombinableOutEdge(eastPort);
        boolean combineEdgeWithPreviousEdge = this.shouldBeCombinedWithPreviousEdge(edge);
        if (combineEdgeWithPreviousEdge) {
            this.currentEdgesToCombine.add(edge);
        }
        if (!combineEdgeWithPreviousEdge || isLastPort) {
            this.combine(this.currentEdgesToCombine);
            this.currentEdgesToCombine.clear();
        }
    }

    private static LEdge getCombinableOutEdge(LPort eastPort) {
        LEdge edge;
        if (eastPort.hasOutgoingEdges() && eastPort.getDegree() == 1 && (edge = eastPort.getOutgoingEdges().get(0)).isHorizontal() && edge.getTarget().getDegree() == 1) {
            return edge;
        }
        return null;
    }

    private boolean shouldBeCombinedWithPreviousEdge(LEdge edge) {
        LEdge previousEdge = MesUtilMethods.getLastElementOrNull(this.currentEdgesToCombine);
        return edge != null && (previousEdge == null || EdgeCombiner.areAtSameNodeAndNoOtherPortWithEdgesBetween(previousEdge.getTarget(), edge.getTarget()));
    }

    private static boolean areAtSameNodeAndNoOtherPortWithEdgesBetween(LPort upper, LPort lower) {
        return upper.isOnSameNodeAs(lower) && upper.getNode().getPortsWithEdgesAsStream(upper.getSide()).allMatch(p -> p.isAboveOrEqual(upper) || p.isBelowOrEqual(lower));
    }

    private void combine(List<LEdge> edges) {
        if (edges.size() > 1) {
            LEdge newEdge = this.copyEdge(edges.get(0));
            edges.forEach(e -> this.disconnect((LEdge)e));
            newEdge.getCombinedEdges().addAll(edges);
            this.edgesCombinedInto.add(newEdge);
        }
    }

    private LEdge copyEdge(LEdge edge) {
        LEdge newEdge = new LEdge();
        newEdge.setSource(edge.getSource());
        newEdge.setTarget(edge.getTarget());
        return newEdge;
    }

    private void disconnect(LEdge edge) {
        this.sourceOfEdgeBefore.put(edge, edge.getSource());
        this.targetOfEdgeBefore.put(edge, edge.getTarget());
        edge.setSource(null);
        edge.setTarget(null);
    }

    public void decombine() {
        this.edgesCombinedInto.forEach(e -> this.decombine((LEdge)e));
    }

    private void decombine(LEdge edge) {
        edge.setSource(null);
        edge.setTarget(null);
        edge.getCombinedEdges().forEach(e -> this.reconnect((LEdge)e));
        edge.getCombinedEdges().clear();
    }

    private void reconnect(LEdge edge) {
        edge.setSource(this.sourceOfEdgeBefore.get(edge));
        edge.setTarget(this.targetOfEdgeBefore.get(edge));
    }
}

