/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.p3order.counting;

public class BinaryIndexedTree {
    private int[] binarySums;
    private int[] numsPerIndex;
    private int size;
    private int maxNum;

    public BinaryIndexedTree(int maxNum) {
        this.maxNum = maxNum;
        this.binarySums = new int[maxNum + 1];
        this.numsPerIndex = new int[maxNum];
        this.size = 0;
    }

    public void add(int index) {
        ++this.size;
        int n = index;
        this.numsPerIndex[n] = this.numsPerIndex[n] + 1;
        int i = index + 1;
        while (i < this.binarySums.length) {
            int n2 = i;
            this.binarySums[n2] = this.binarySums[n2] + 1;
            i += i & -i;
        }
    }

    public int rank(int index) {
        int i = index;
        int sum = 0;
        while (i > 0) {
            sum += this.binarySums[i];
            i -= i & -i;
        }
        return sum;
    }

    public int size() {
        return this.size;
    }

    public void removeAll(int index) {
        int numEntries = this.numsPerIndex[index];
        if (numEntries == 0) {
            return;
        }
        this.numsPerIndex[index] = 0;
        this.size -= numEntries;
        int i = index + 1;
        while (i < this.binarySums.length) {
            int n = i;
            this.binarySums[n] = this.binarySums[n] - numEntries;
            i += i & -i;
        }
    }

    public void clear() {
        this.binarySums = new int[this.maxNum + 1];
        this.numsPerIndex = new int[this.maxNum];
        this.size = 0;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }
}

