/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.p3order;

import com.modelengineers.MoRe_elk.alg.layered.graph.LGraph;
import com.modelengineers.MoRe_elk.alg.layered.mesutils.MesUtilMethods;
import com.modelengineers.MoRe_elk.core.util.Pair;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class SeparateComponentSorter {
    private List<LGraph> unsortedComponents;
    private List<LGraph> sortedComponentsWithOutportBlocks;
    private HashMap<Pair<LGraph, String>, Integer> minPortNumberMap = new HashMap();
    private static final String INPORT = "Inport";
    private static final String OUTPORT = "Outport";

    public SeparateComponentSorter(List<LGraph> unsortedComponents) {
        this.unsortedComponents = unsortedComponents;
    }

    public List<LGraph> sort() {
        return MesUtilMethods.concatLists(this.getSortedComponentsWithOnlyInportBlocks(), this.getSortedComponentsWithNoPortBlocks(), this.getSortedComponentsWithOutportBlocks());
    }

    private List<LGraph> getSortedComponentsWithOnlyInportBlocks() {
        List<LGraph> componentsWithOnlyInportBlocks = this.getUnsortedComponents(true, false);
        return this.sortBySizeFirstAndMinInportNumberSecond(componentsWithOnlyInportBlocks);
    }

    private List<LGraph> getUnsortedComponents(boolean hasInportBlocks, boolean hasOutportBlocks) {
        return this.unsortedComponents.stream().filter(c -> hasInportBlocks == c.hasNodeOfMesBlockType(INPORT) && hasOutportBlocks == c.hasNodeOfMesBlockType(OUTPORT)).collect(Collectors.toList());
    }

    private List<LGraph> sortBySizeFirstAndMinInportNumberSecond(List<LGraph> components) {
        return components.stream().sorted(Comparator.comparing(c -> SeparateComponentSorter.getSize(c)).thenComparing(c -> this.getMinPortNumber((LGraph)c, INPORT))).collect(Collectors.toList());
    }

    private static int getSize(LGraph component) {
        return component.getComponents().get(0).getNumberOfNormalNodes();
    }

    private int getMinPortNumber(LGraph component, String portType) {
        return this.minPortNumberMap.computeIfAbsent(new Pair<LGraph, String>(component, portType), p -> SeparateComponentSorter.computeMinPortNumber((LGraph)p.getFirst(), (String)p.getSecond()));
    }

    private static int computeMinPortNumber(LGraph component, String typeOfPort) {
        return component.getNodesFromAllLayers().stream().filter(n -> n.isOfMesBlockType(typeOfPort)).mapToInt(p -> p.getPortBlockNumber()).min().getAsInt();
    }

    private List<LGraph> getSortedComponentsWithNoPortBlocks() {
        List<LGraph> componentsWithNoPortBlocks = this.getUnsortedComponents(false, false);
        return SeparateComponentSorter.sortBySize(componentsWithNoPortBlocks);
    }

    private static List<LGraph> sortBySize(List<LGraph> components) {
        return components.stream().sorted(Comparator.comparing(c -> SeparateComponentSorter.getSize(c))).collect(Collectors.toList());
    }

    private List<LGraph> getSortedComponentsWithOutportBlocks() {
        this.sortedComponentsWithOutportBlocks = this.getSortedComponentsWithInportAndOutportBlocks();
        this.insertComponentsWithOnlyOutportBlocks();
        return this.sortedComponentsWithOutportBlocks;
    }

    private List<LGraph> getSortedComponentsWithInportAndOutportBlocks() {
        List<LGraph> componentsWithInportAndOutportBlocks = this.getUnsortedComponents(true, true);
        return this.sortByInportNumber(componentsWithInportAndOutportBlocks);
    }

    private List<LGraph> sortByInportNumber(List<LGraph> components) {
        return components.stream().sorted(Comparator.comparing(c -> this.getMinPortNumber((LGraph)c, INPORT))).collect(Collectors.toList());
    }

    private void insertComponentsWithOnlyOutportBlocks() {
        List<LGraph> componentsToInsert = this.getUnsortedComponents(false, true);
        this.insertComponentsWithOnlyOutportBlocks(componentsToInsert);
    }

    private void insertComponentsWithOnlyOutportBlocks(List<LGraph> componentsToInsert) {
        componentsToInsert.forEach(c -> this.insertComponentWithOnlyOutportBlocks((LGraph)c));
    }

    private void insertComponentWithOnlyOutportBlocks(LGraph componentToInsert) {
        int insertPosition = this.getInsertPosition(componentToInsert);
        this.sortedComponentsWithOutportBlocks.add(insertPosition, componentToInsert);
    }

    private int getInsertPosition(LGraph componentToInsert) {
        int[] scoresOfInsertPositions = IntStream.range(0, this.sortedComponentsWithOutportBlocks.size() + 1).map(i -> this.getScoreForInsertPosition(i, componentToInsert)).toArray();
        return MesUtilMethods.indexOfMax(scoresOfInsertPositions);
    }

    private int getScoreForInsertPosition(int insertPosition, LGraph componentToInsert) {
        int minPortNumberOfComponentToInsert = this.getMinPortNumber(componentToInsert, OUTPORT);
        return this.getNumComponentsAboveWithSmallerMinOutportNumber(insertPosition, minPortNumberOfComponentToInsert) + this.getNumComponentsBelowWithHigherMinOutportNumber(insertPosition, minPortNumberOfComponentToInsert);
    }

    private int getNumComponentsAboveWithSmallerMinOutportNumber(int insertPosition, int minPortNumberOfComponentToInsert) {
        return (int)this.sortedComponentsWithOutportBlocks.subList(0, insertPosition).stream().filter(c -> this.getMinPortNumber((LGraph)c, OUTPORT) < minPortNumberOfComponentToInsert).count();
    }

    private int getNumComponentsBelowWithHigherMinOutportNumber(int insertPosition, int minPortNumberOfComponentToInsert) {
        return (int)this.sortedComponentsWithOutportBlocks.subList(insertPosition, this.sortedComponentsWithOutportBlocks.size()).stream().filter(c -> this.getMinPortNumber((LGraph)c, OUTPORT) > minPortNumberOfComponentToInsert).count();
    }
}

