/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.p3order;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.modelengineers.MoRe_elk.alg.layered.LayeredPhases;
import com.modelengineers.MoRe_elk.alg.layered.graph.LEdge;
import com.modelengineers.MoRe_elk.alg.layered.graph.LGraph;
import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.alg.layered.graph.LPort;
import com.modelengineers.MoRe_elk.alg.layered.graph.Layer;
import com.modelengineers.MoRe_elk.alg.layered.intermediate.IntermediateProcessorStrategy;
import com.modelengineers.MoRe_elk.alg.layered.options.InternalProperties;
import com.modelengineers.MoRe_elk.alg.layered.options.LayeredOptions;
import com.modelengineers.MoRe_elk.alg.layered.p3order.GraphInfoHolder;
import com.modelengineers.MoRe_elk.alg.layered.p3order.SweepCopy;
import com.modelengineers.MoRe_elk.alg.layered.p3order.counting.CrossMinUtil;
import com.modelengineers.MoRe_elk.core.alg.ILayoutPhase;
import com.modelengineers.MoRe_elk.core.alg.LayoutProcessorConfiguration;
import com.modelengineers.MoRe_elk.core.options.HierarchyHandling;
import com.modelengineers.MoRe_elk.core.options.PortConstraints;
import com.modelengineers.MoRe_elk.core.options.PortSide;
import com.modelengineers.MoRe_elk.core.util.IElkProgressMonitor;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Consumer;

public class LayerSweepCrossingMinimizer
implements ILayoutPhase<LayeredPhases, LGraph> {
    private List<GraphInfoHolder> graphInfoHolders;
    private Set<GraphInfoHolder> graphsWhoseNodeOrderChanged;
    private Random random;
    private long randomSeed;
    private CrossMinType crossMinType;
    private static final LayoutProcessorConfiguration<LayeredPhases, LGraph> INTERMEDIATE_PROCESSING_CONFIGURATION = LayoutProcessorConfiguration.create().addBefore(LayeredPhases.P3_NODE_ORDERING, IntermediateProcessorStrategy.LONG_EDGE_SPLITTER).addBefore(LayeredPhases.P4_NODE_PLACEMENT, IntermediateProcessorStrategy.IN_LAYER_CONSTRAINT_PROCESSOR).after(LayeredPhases.P5_EDGE_ROUTING).add(IntermediateProcessorStrategy.LONG_EDGE_JOINER);

    public LayerSweepCrossingMinimizer(CrossMinType cT) {
        this.crossMinType = cT;
    }

    @Override
    public void process(LGraph layeredGraph, IElkProgressMonitor progressMonitor) {
        progressMonitor.begin("Minimize Crossings " + (Object)((Object)this.crossMinType), 1.0f);
        this.orderNodesAndPorts(layeredGraph);
        this.orderFirstAndLastSeparateLayer(layeredGraph);
        progressMonitor.done();
    }

    public void orderNodesAndPorts(LGraph layeredGraph) {
        boolean hierarchicalLayout;
        boolean emptyGraph = this.isGraphEmpty(layeredGraph);
        boolean singleNode = layeredGraph.getLayers().size() == 1 && layeredGraph.getLayers().get(0).getNodes().size() == 1;
        boolean bl = hierarchicalLayout = layeredGraph.getProperty(LayeredOptions.HIERARCHY_HANDLING) == HierarchyHandling.INCLUDE_CHILDREN;
        if (emptyGraph || singleNode && !hierarchicalLayout) {
            return;
        }
        List<GraphInfoHolder> graphsToSweepOn = this.initialize(layeredGraph);
        Consumer<GraphInfoHolder> minimizingMethod = this.chooseMinimizingMethod(graphsToSweepOn);
        this.minimizeCrossings(graphsToSweepOn, minimizingMethod);
        this.transferNodeAndPortOrdersToGraph();
    }

    private boolean isGraphEmpty(LGraph layeredGraph) {
        return layeredGraph.getLayers().isEmpty() || layeredGraph.getLayers().stream().allMatch(layer -> layer.getNodes().isEmpty());
    }

    private Consumer<GraphInfoHolder> chooseMinimizingMethod(List<GraphInfoHolder> graphsToSweepOn) {
        GraphInfoHolder parent = graphsToSweepOn.get(0);
        if (!parent.crossMinDeterministic()) {
            return this::compareDifferentRandomizedLayouts;
        }
        if (parent.crossMinAlwaysImproves()) {
            return this::minimizeCrossingsNoCounter;
        }
        return this::minimizeCrossingsWithCounter;
    }

    private void minimizeCrossings(List<GraphInfoHolder> graphsToSweepOn, Consumer<GraphInfoHolder> minimizingMethod) {
        for (GraphInfoHolder gData : graphsToSweepOn) {
            if (gData.currentNodeOrder().length <= 0) continue;
            minimizingMethod.accept(gData);
            if (!gData.hasParent()) continue;
            this.setPortOrderOnParentGraph(gData);
        }
    }

    private void setPortOrderOnParentGraph(GraphInfoHolder gData) {
        if (gData.hasExternalPorts()) {
            SweepCopy bestSweep = gData.getBestSweep();
            this.sortPortsByDummyPositionsInLastLayer(bestSweep.nodes(), gData.parent(), true);
            this.sortPortsByDummyPositionsInLastLayer(bestSweep.nodes(), gData.parent(), false);
            gData.parent().setProperty(LayeredOptions.PORT_CONSTRAINTS, (Object)PortConstraints.FIXED_ORDER);
        }
    }

    private void minimizeCrossingsNoCounter(GraphInfoHolder gData) {
        boolean isForwardSweep = this.random.nextBoolean();
        boolean improved = true;
        while (improved) {
            improved = false;
            improved = gData.crossMinimizer().setFirstLayerOrder(gData.currentNodeOrder(), isForwardSweep);
            improved |= this.sweepReducingCrossings(gData, isForwardSweep, false);
            boolean bl = isForwardSweep = !isForwardSweep;
        }
        this.setCurrentlyBestNodeOrders();
    }

    private void compareDifferentRandomizedLayouts(GraphInfoHolder gData) {
        this.random.setSeed(this.randomSeed);
        this.graphsWhoseNodeOrderChanged.clear();
        int bestCrossings = Integer.MAX_VALUE;
        if (gData.crossMinimizer().supportsRandomPerturbations()) {
            this.minimizeCrossingsWithRandomPerturbationsAndSaveOrder(gData, bestCrossings);
        } else {
            this.minimizeCrossingsAndSaveOrder(gData, bestCrossings);
        }
    }

    private void minimizeCrossingsWithRandomPerturbationsAndSaveOrder(GraphInfoHolder gData, int prevBestCrossings) {
        int bestCrossings = prevBestCrossings;
        gData.crossMinimizer().enableRandomPerturbations(true);
        bestCrossings = this.minimizeCrossingsAndSaveOrder(gData, bestCrossings);
        if (gData.lGraph().getProperty(LayeredOptions.CROSSING_MINIMIZATION_ADD_DETERMINISTIC_MINIMUMS_MES_MORE).booleanValue()) {
            gData.crossMinimizer().enableRandomPerturbations(false);
            this.minimizeCrossingsAndSaveOrder(gData, bestCrossings);
        }
    }

    private int minimizeCrossingsAndSaveOrder(GraphInfoHolder gData, int prevBestCrossings) {
        int bestCrossings = prevBestCrossings;
        int thouroughness = gData.lGraph().getProperty(LayeredOptions.THOROUGHNESS);
        int i = 0;
        while (i < thouroughness) {
            int crossings = this.minimizeCrossingsWithCounter(gData);
            if (crossings < bestCrossings) {
                bestCrossings = crossings;
                this.saveAllNodeOrdersOfChangedGraphs();
                if (bestCrossings == 0) break;
            }
            ++i;
        }
        return bestCrossings;
    }

    private int minimizeCrossingsWithCounter(GraphInfoHolder gData) {
        int oldNumberOfCrossings;
        boolean isForwardSweep = this.random.nextBoolean();
        gData.crossMinimizer().setFirstLayerOrder(gData.currentNodeOrder(), isForwardSweep);
        this.sweepReducingCrossings(gData, isForwardSweep, true);
        if (gData.lGraph().getProperty(InternalProperties.SECOND_TRY_WITH_INITIAL_ORDER).booleanValue()) {
            gData.lGraph().setProperty(InternalProperties.SECOND_TRY_WITH_INITIAL_ORDER, (Object)false);
        }
        if (gData.lGraph().getProperty(InternalProperties.FIRST_TRY_WITH_INITIAL_ORDER).booleanValue()) {
            gData.lGraph().setProperty(InternalProperties.FIRST_TRY_WITH_INITIAL_ORDER, (Object)false);
            gData.lGraph().setProperty(InternalProperties.SECOND_TRY_WITH_INITIAL_ORDER, (Object)true);
        }
        int crossingsInGraph = this.countCurrentNumberOfCrossings(gData);
        do {
            this.setCurrentlyBestNodeOrders();
            if (crossingsInGraph == 0) {
                return 0;
            }
            isForwardSweep = !isForwardSweep;
            oldNumberOfCrossings = crossingsInGraph;
            this.sweepReducingCrossings(gData, isForwardSweep, false);
        } while (oldNumberOfCrossings > (crossingsInGraph = this.countCurrentNumberOfCrossings(gData)));
        return oldNumberOfCrossings;
    }

    private int countCurrentNumberOfCrossings(GraphInfoHolder currentGraph) {
        int totalCrossings = 0;
        ArrayDeque<GraphInfoHolder> countCrossingsIn = new ArrayDeque<GraphInfoHolder>();
        countCrossingsIn.push(currentGraph);
        while (!countCrossingsIn.isEmpty()) {
            GraphInfoHolder gD = (GraphInfoHolder)countCrossingsIn.pop();
            totalCrossings += gD.crossCounter().countAllCrossings(gD.currentNodeOrder());
            for (LGraph childLGraph : gD.childGraphs()) {
                GraphInfoHolder child = this.graphInfoHolders.get(childLGraph.id);
                if (child.dontSweepInto()) continue;
                totalCrossings += this.countCurrentNumberOfCrossings(child);
            }
        }
        return totalCrossings;
    }

    private boolean sweepReducingCrossings(GraphInfoHolder graph, boolean forward, boolean firstSweep) {
        LNode[][] nodes = graph.currentNodeOrder();
        int length = nodes.length;
        boolean improved = graph.portDistributor().distributePortsWhileSweeping(nodes, this.firstIndex(forward, length), forward);
        LNode[] firstLayer = nodes[this.firstIndex(forward, length)];
        improved |= this.sweepInHierarchicalNodes(firstLayer, forward, firstSweep);
        int i = this.firstFree(forward, length);
        while (this.isNotEnd(length, i, forward)) {
            improved |= graph.crossMinimizer().minimizeCrossings(nodes, i, forward, firstSweep && graph.lGraph().getProperty(InternalProperties.FIRST_TRY_WITH_INITIAL_ORDER) == false && graph.lGraph().getProperty(InternalProperties.SECOND_TRY_WITH_INITIAL_ORDER) == false);
            improved |= graph.portDistributor().distributePortsWhileSweeping(nodes, i, forward);
            improved |= this.sweepInHierarchicalNodes(nodes[i], forward, firstSweep);
            i += this.next(forward);
        }
        this.graphsWhoseNodeOrderChanged.add(graph);
        return improved;
    }

    private boolean sweepInHierarchicalNodes(LNode[] layer, boolean isForwardSweep, boolean isFirstSweep) {
        boolean improved = false;
        LNode[] lNodeArray = layer;
        int n = layer.length;
        int n2 = 0;
        while (n2 < n) {
            LNode node = lNodeArray[n2];
            if (this.hasNestedGraph(node).booleanValue() && !this.graphInfoHolders.get(node.getNestedGraph().id).dontSweepInto()) {
                improved |= this.sweepInHierarchicalNode(isForwardSweep, node, isFirstSweep);
            }
            ++n2;
        }
        return improved;
    }

    private boolean sweepInHierarchicalNode(boolean isForwardSweep, LNode node, boolean isFirstSweep) {
        int startIndex;
        LGraph nestedLGraph = node.getNestedGraph();
        GraphInfoHolder nestedGraph = this.graphInfoHolders.get(nestedLGraph.id);
        LNode[][] nestedGraphNodeOrder = nestedGraph.currentNodeOrder();
        LNode firstNode = nestedGraphNodeOrder[startIndex = this.firstIndex(isForwardSweep, nestedGraphNodeOrder.length)][0];
        if (this.isExternalPortDummy(firstNode)) {
            nestedGraphNodeOrder[startIndex] = this.sortPortDummiesByPortPositions(node, nestedGraphNodeOrder[startIndex], this.sideOpposedSweepDirection(isForwardSweep));
        } else {
            nestedGraph.crossMinimizer().setFirstLayerOrder(nestedGraphNodeOrder, isForwardSweep);
        }
        boolean improved = this.sweepReducingCrossings(nestedGraph, isForwardSweep, isFirstSweep);
        this.sortPortsByDummyPositionsInLastLayer(nestedGraph.currentNodeOrder(), nestedGraph.parent(), isForwardSweep);
        return improved;
    }

    private void sortPortsByDummyPositionsInLastLayer(LNode[][] nodeOrder, LNode parent, boolean onRightMostLayer) {
        int endIndex = this.endIndex(onRightMostLayer, nodeOrder.length);
        LNode[] lastLayer = nodeOrder[endIndex];
        if (!this.isExternalPortDummy(lastLayer[0])) {
            return;
        }
        int j = this.firstIndex(onRightMostLayer, lastLayer.length);
        List<LPort> ports = parent.getPorts();
        int i = 0;
        while (i < ports.size()) {
            LPort port = ports.get(i);
            if (this.isOnEndOfSweepSide(port, onRightMostLayer) && this.isHierarchical(port)) {
                ports.set(i, this.originPort(lastLayer[j]));
                j += this.next(onRightMostLayer);
            }
            ++i;
        }
    }

    private LNode[] sortPortDummiesByPortPositions(LNode parentNode, LNode[] layerCloseToNodeEdge, PortSide side) {
        Iterable<LPort> ports = CrossMinUtil.inNorthSouthEastWestOrder(parentNode, side);
        LNode[] sortedDummies = new LNode[layerCloseToNodeEdge.length];
        int i = 0;
        for (LPort port : ports) {
            if (!this.isHierarchical(port)) continue;
            sortedDummies[i++] = this.dummyNodeFor(port);
        }
        if (i < layerCloseToNodeEdge.length) {
            throw new IllegalStateException("Expected " + layerCloseToNodeEdge.length + " hierarchical ports, but found only " + i + ".");
        }
        return sortedDummies;
    }

    private void saveAllNodeOrdersOfChangedGraphs() {
        for (GraphInfoHolder graph : this.graphsWhoseNodeOrderChanged) {
            graph.setBestNodeNPortOrder(new SweepCopy(graph.currentlyBestNodeAndPortOrder()));
        }
    }

    private void setCurrentlyBestNodeOrders() {
        for (GraphInfoHolder graph : this.graphsWhoseNodeOrderChanged) {
            graph.setCurrentlyBestNodeAndPortOrder(new SweepCopy(graph.currentNodeOrder()));
        }
    }

    private int firstIndex(boolean isForwardSweep, int length) {
        return isForwardSweep ? 0 : length - 1;
    }

    private int endIndex(boolean isForwardSweep, int length) {
        return isForwardSweep ? length - 1 : 0;
    }

    private int firstFree(boolean isForwardSweep, int length) {
        return isForwardSweep ? 1 : length - 2;
    }

    private int next(boolean isForwardSweep) {
        return isForwardSweep ? 1 : -1;
    }

    private boolean isNotEnd(int length, int freeLayerIndex, boolean isForwardSweep) {
        return isForwardSweep ? freeLayerIndex < length : freeLayerIndex >= 0;
    }

    private Boolean hasNestedGraph(LNode node) {
        if (node.getNestedGraph() != null) {
            return true;
        }
        return false;
    }

    private PortSide sideOpposedSweepDirection(boolean isForwardSweep) {
        return isForwardSweep ? PortSide.WEST : PortSide.EAST;
    }

    private boolean isExternalPortDummy(LNode firstNode) {
        return firstNode.getType() == LNode.NodeType.EXTERNAL_PORT;
    }

    private LPort originPort(LNode node) {
        return (LPort)node.getProperty(InternalProperties.ORIGIN);
    }

    private boolean isHierarchical(LPort port) {
        return port.getProperty(InternalProperties.INSIDE_CONNECTIONS);
    }

    private LNode dummyNodeFor(LPort port) {
        return port.getProperty(InternalProperties.PORT_DUMMY);
    }

    private boolean isOnEndOfSweepSide(LPort port, boolean isForwardSweep) {
        return isForwardSweep ? port.getSide() == PortSide.EAST : port.getSide() == PortSide.WEST;
    }

    private List<GraphInfoHolder> initialize(LGraph rootGraph) {
        this.graphInfoHolders = Lists.newArrayList();
        this.random = rootGraph.getProperty(InternalProperties.RANDOM);
        this.randomSeed = this.random.nextLong();
        LinkedList graphsToSweepOn = Lists.newLinkedList();
        ArrayList graphs = Lists.newArrayList((Object[])new LGraph[]{rootGraph});
        int i = 0;
        while (i < graphs.size()) {
            LGraph graph = (LGraph)graphs.get(i);
            graph.id = i++;
            GraphInfoHolder gData = new GraphInfoHolder(graph, this.crossMinType, this.graphInfoHolders);
            graphs.addAll(gData.childGraphs());
            this.graphInfoHolders.add(gData);
            if (!gData.dontSweepInto()) continue;
            graphsToSweepOn.add(0, gData);
        }
        this.graphsWhoseNodeOrderChanged = Sets.newHashSet();
        return graphsToSweepOn;
    }

    private void transferNodeAndPortOrdersToGraph() {
        for (GraphInfoHolder gD : this.graphInfoHolders) {
            SweepCopy bestSweep = gD.getBestSweep();
            if (bestSweep == null) continue;
            bestSweep.transferNodeAndPortOrdersToGraph(gD.lGraph(), true);
        }
    }

    public void orderFirstAndLastSeparateLayer(LGraph layeredGraph) {
        if (this.isGraphEmpty(layeredGraph)) {
            return;
        }
        Layer firstLayer = layeredGraph.getLayers().get(0);
        Layer lastLayer = layeredGraph.getLayers().get(layeredGraph.getLayers().size() - 1);
        if (firstLayer.getNodes().get(0).isFirstSeparate()) {
            this.orderFirstSeparateLayer(firstLayer);
            this.correctNodesWithNorthSouthPorts(firstLayer);
        }
        if (lastLayer.getNodes().get(0).isLastSeparate()) {
            this.orderLastSeparateLayer(lastLayer);
            this.correctNodesWithNorthSouthPorts(lastLayer);
        }
    }

    private void orderFirstSeparateLayer(Layer firstSeparateLayer) {
        Collections.sort(firstSeparateLayer.getNodes(), new Comparator<LNode>(){
            private static final double FACTOR_FOR_PORT_INDEX = 0.001;

            @Override
            public int compare(LNode n1, LNode n2) {
                return Double.compare(this.getCompareValueOfTargetPort(n1), this.getCompareValueOfTargetPort(n2));
            }

            private double getCompareValueOfTargetPort(LNode node) {
                double minCompareValue = Double.MAX_VALUE;
                for (LEdge outgoingEdge : node.getOutgoingEdges()) {
                    int indexOfPort;
                    LPort destPort = outgoingEdge.getTarget();
                    int indexOfNode = destPort.getNode().getIndex();
                    double compareValue = (double)indexOfNode + 0.001 * (double)(indexOfPort = destPort.getNode().getPorts().size() - destPort.getIndex());
                    if (!(compareValue < minCompareValue)) continue;
                    minCompareValue = compareValue;
                }
                return minCompareValue;
            }
        });
    }

    private void orderLastSeparateLayer(Layer lastSeparateLayer) {
        Collections.sort(lastSeparateLayer.getNodes(), new Comparator<LNode>(){
            private static final double FACTOR_FOR_PORT_INDEX = 0.001;

            @Override
            public int compare(LNode n1, LNode n2) {
                return Double.compare(this.getCompareValueOfSrcNode(n1), this.getCompareValueOfSrcNode(n2));
            }

            private double getCompareValueOfSrcNode(LNode node) {
                if (!node.getIncomingEdges().iterator().hasNext()) {
                    return Double.MAX_VALUE;
                }
                LPort srcPort = node.getIncomingEdges().iterator().next().getSource();
                int indexOfSourceNode = srcPort.getNode().getIndex();
                int indexOfSourcePort = srcPort.getIndex();
                return (double)indexOfSourceNode + 0.001 * (double)indexOfSourcePort;
            }
        });
    }

    private void correctNodesWithNorthSouthPorts(Layer firstOrLastLayer) {
        for (LNode node : Lists.newArrayList(firstOrLastLayer.getNodes())) {
            if (node.getType() != LNode.NodeType.NORTH_SOUTH_PORT) continue;
            LNode connectedPortBlock = (LNode)node.getProperty(InternalProperties.ORIGIN);
            firstOrLastLayer.getNodes().remove(connectedPortBlock);
            int indexOfNode = firstOrLastLayer.getNodes().indexOf(node);
            if (connectedPortBlock.getPorts().get(0).getSide() == PortSide.SOUTH) {
                firstOrLastLayer.getNodes().add(indexOfNode, connectedPortBlock);
                continue;
            }
            firstOrLastLayer.getNodes().add(indexOfNode + 1, connectedPortBlock);
        }
    }

    @Override
    public LayoutProcessorConfiguration<LayeredPhases, LGraph> getLayoutProcessorConfiguration(LGraph graph) {
        LayoutProcessorConfiguration<LayeredPhases, LGraph> configuration = LayoutProcessorConfiguration.createFrom(INTERMEDIATE_PROCESSING_CONFIGURATION);
        configuration.addBefore(LayeredPhases.P3_NODE_ORDERING, IntermediateProcessorStrategy.PORT_LIST_SORTER);
        return configuration;
    }

    public List<GraphInfoHolder> getGraphData() {
        return this.graphInfoHolders;
    }

    public static enum CrossMinType {
        BARYCENTER,
        ONE_SIDED_GREEDY_SWITCH,
        TWO_SIDED_GREEDY_SWITCH;

    }
}

