/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.p2layers.mes;

import com.modelengineers.MoRe_elk.alg.layered.LayeredPhases;
import com.modelengineers.MoRe_elk.alg.layered.graph.LGraph;
import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.alg.layered.graph.Layer;
import com.modelengineers.MoRe_elk.alg.layered.intermediate.IntermediateProcessorStrategy;
import com.modelengineers.MoRe_elk.alg.layered.mesutils.MesUtilMethods;
import com.modelengineers.MoRe_elk.alg.layered.p2layers.mes.MesLayererCore;
import com.modelengineers.MoRe_elk.core.alg.ILayoutPhase;
import com.modelengineers.MoRe_elk.core.alg.LayoutProcessorConfiguration;
import com.modelengineers.MoRe_elk.core.util.IElkProgressMonitor;
import java.util.List;
import java.util.stream.IntStream;

public final class MesLayerer
implements ILayoutPhase<LayeredPhases, LGraph> {
    public static final String PRINT_PREFIX = MesLayerer.class.getSimpleName();
    private List<LNode> layerlessNodes;
    private static final LayoutProcessorConfiguration<LayeredPhases, LGraph> BASELINE_PROCESSING_CONFIGURATION = LayoutProcessorConfiguration.create().addAfter(LayeredPhases.P2_LAYERING, IntermediateProcessorStrategy.MES_BACK_EDGE_REVERSER).addAfter(LayeredPhases.P5_EDGE_ROUTING, IntermediateProcessorStrategy.REVERSED_EDGE_RESTORER);

    @Override
    public LayoutProcessorConfiguration<LayeredPhases, LGraph> getLayoutProcessorConfiguration(LGraph graph) {
        return BASELINE_PROCESSING_CONFIGURATION;
    }

    @Override
    public void process(LGraph graph, IElkProgressMonitor monitor) throws InterruptedException {
        monitor.begin(PRINT_PREFIX, 1.0f);
        MesUtilMethods.measureRuntime(() -> this.processCore(graph, monitor), PRINT_PREFIX, graph.loggingEnabled());
        monitor.done();
    }

    private void processCore(LGraph graph, IElkProgressMonitor monitor) throws InterruptedException {
        this.layerlessNodes = graph.getLayerlessNodes();
        if (this.layerlessNodes.size() > 0) {
            int[] layersOfNodes = new MesLayererCore(this.layerlessNodes).computeLayers();
            this.createLayers(layersOfNodes, graph);
        }
        this.layerlessNodes.clear();
    }

    private void createLayers(int[] layersOfNodes, LGraph graph) {
        int numLayers = MesLayerer.max(layersOfNodes) + 1;
        List<Layer> layers = this.createEmptyLayers(graph, numLayers);
        this.assignNodesToLayers(layersOfNodes, layers);
    }

    private static int max(int[] a) {
        return IntStream.of(a).max().getAsInt();
    }

    private List<Layer> createEmptyLayers(LGraph graph, int numLayers) {
        List<Layer> layers = graph.getLayers();
        int ixLayer = 0;
        while (ixLayer < numLayers) {
            Layer layer = new Layer(graph);
            layer.id = ixLayer++;
            layers.add(layer);
        }
        return layers;
    }

    private void assignNodesToLayers(int[] layersOfNodes, List<Layer> layers) {
        int ixNode = 0;
        while (ixNode < this.layerlessNodes.size()) {
            this.layerlessNodes.get(ixNode).setLayer(layers.get(layersOfNodes[ixNode]));
            ++ixNode;
        }
    }
}

