/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.p2layers.mes;

import com.google.ortools.linearsolver.MPVariable;
import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.alg.layered.ortools.MPSolverWrapperInt;
import com.modelengineers.MoRe_elk.alg.layered.p2layers.mes.SimilarNodesShouldBeInSimilarLayersObjectives;
import com.modelengineers.MoRe_elk.alg.layered.p2layers.mes.SplitSourceNodesConstraints;
import java.util.List;
import java.util.Map;

public class FinalLayeringProblem {
    private MPSolverWrapperInt solver;
    private List<LNode> nodes;
    private Map<LNode, MPVariable> nodeToLayerMap;
    private int[] layersOfNodesWithoutSimilarity;

    public FinalLayeringProblem(MPSolverWrapperInt solver, List<LNode> nodes, Map<LNode, MPVariable> nodeToLayerMap, int[] layersOfNodesWithoutSimilarity) throws InterruptedException {
        this.solver = solver;
        this.nodes = nodes;
        this.nodeToLayerMap = nodeToLayerMap;
        this.layersOfNodesWithoutSimilarity = layersOfNodesWithoutSimilarity;
        this.addConstraintsAndObjectivesToSolver();
    }

    private void addConstraintsAndObjectivesToSolver() throws InterruptedException {
        new SimilarNodesShouldBeInSimilarLayersObjectives(this, this.nodes, this.solver);
        new SplitSourceNodesConstraints(this, this.nodes, this.solver);
    }

    public MPVariable getLayer(LNode node) {
        return this.nodeToLayerMap.get(node);
    }

    public int getLayerWithoutSimilarity(LNode node) {
        return this.layersOfNodesWithoutSimilarity[this.nodes.indexOf(node)];
    }
}

