/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.p2layers;

import com.google.common.collect.Lists;
import com.modelengineers.MoRe_elk.alg.layered.LayeredPhases;
import com.modelengineers.MoRe_elk.alg.layered.graph.LEdge;
import com.modelengineers.MoRe_elk.alg.layered.graph.LGraph;
import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.alg.layered.graph.LPort;
import com.modelengineers.MoRe_elk.alg.layered.graph.Layer;
import com.modelengineers.MoRe_elk.alg.layered.intermediate.IntermediateProcessorStrategy;
import com.modelengineers.MoRe_elk.alg.layered.options.LayeredOptions;
import com.modelengineers.MoRe_elk.alg.layered.options.PortType;
import com.modelengineers.MoRe_elk.core.alg.ILayoutPhase;
import com.modelengineers.MoRe_elk.core.alg.LayoutProcessorConfiguration;
import com.modelengineers.MoRe_elk.core.util.IElkProgressMonitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;

public final class InteractiveLayerer
implements ILayoutPhase<LayeredPhases, LGraph> {
    @Override
    public LayoutProcessorConfiguration<LayeredPhases, LGraph> getLayoutProcessorConfiguration(LGraph graph) {
        return LayoutProcessorConfiguration.create().addBefore(LayeredPhases.P1_CYCLE_BREAKING, IntermediateProcessorStrategy.INTERACTIVE_EXTERNAL_PORT_POSITIONER);
    }

    @Override
    public void process(LGraph graph, IElkProgressMonitor monitor) {
        monitor.begin("Interactive node layering", 1.0f);
        List<LayerSpan> layerSpans = this.buildLayerSpans(graph);
        this.createLayersFromLayerSpans(graph, layerSpans);
        this.correctLayeringRespectingGraphTopology(graph);
        graph.getLayerlessNodes().clear();
        monitor.done();
    }

    private List<LayerSpan> buildLayerSpans(LGraph graph) {
        ArrayList spans = Lists.newArrayList();
        this.sortNodesByX(graph.getLayerlessNodes());
        for (LNode node : graph.getLayerlessNodes()) {
            if (spans.size() > 0 && this.isNodeAssignedToSpan(node, (LayerSpan)spans.get(spans.size() - 1))) {
                LayerSpan span = (LayerSpan)spans.get(spans.size() - 1);
                span.nodes.add(node);
                span.end = Math.max(span.end, this.getRightBoundary(node));
                span.rightMostCenter = Math.max(span.rightMostCenter, this.getCenter(this.getLeftBoundary(node), this.getRightBoundary(node)));
                continue;
            }
            LayerSpan newSpan = new LayerSpan();
            newSpan.start = this.getLeftBoundary(node);
            newSpan.end = this.getRightBoundary(node);
            newSpan.rightMostCenter = this.getCenter(newSpan.start, newSpan.end);
            newSpan.nodes.add(node);
            spans.add(newSpan);
        }
        return spans;
    }

    private void sortNodesByX(List<LNode> nodes) {
        Collections.sort(nodes, new Comparator<LNode>(){

            @Override
            public int compare(LNode n1, LNode n2) {
                if (n1.getPosition().x < n2.getPosition().x) {
                    return -1;
                }
                if (n1.getPosition().x > n2.getPosition().x) {
                    return 1;
                }
                return 0;
            }
        });
    }

    private boolean isNodeAssignedToSpan(LNode node, LayerSpan span) {
        return span.end >= this.getXCenter(node) || span.rightMostCenter >= this.getLeftBoundary(node);
    }

    private double getLeftBoundary(LNode node) {
        return this.getLeftOrRightBoundary(node, true);
    }

    private double getRightBoundary(LNode node) {
        return this.getLeftOrRightBoundary(node, false);
    }

    private double getLeftOrRightBoundary(LNode node, boolean left) {
        double layerSnappingDelta = node.getGraph().getProperty(LayeredOptions.LAYERING_SNAPPING_DELTA_FOR_SMALL_BLOCKS_FOR_INTERACTIVE_LAYERING_MES_MORE);
        boolean nodeSmallerThanLayerSnappingDelta = node.getSize().x < layerSnappingDelta;
        double leftBoundary = node.getPosition().x;
        double rightBoundary = leftBoundary + node.getSize().x;
        if (left) {
            return nodeSmallerThanLayerSnappingDelta ? this.getCenter(leftBoundary, rightBoundary) - layerSnappingDelta / 2.0 : leftBoundary;
        }
        return nodeSmallerThanLayerSnappingDelta ? this.getCenter(leftBoundary, rightBoundary) + layerSnappingDelta / 2.0 : rightBoundary;
    }

    private double getXCenter(LNode node) {
        return this.getCenter(this.getLeftBoundary(node), this.getRightBoundary(node));
    }

    private double getCenter(double start, double end) {
        return end - (end - start) / 2.0;
    }

    private void createLayersFromLayerSpans(LGraph graph, List<LayerSpan> layerSpans) {
        List<Layer> layers = graph.getLayers();
        int nextIndex = 0;
        for (LayerSpan span : layerSpans) {
            Layer layer = new Layer(graph);
            layer.id = nextIndex++;
            layers.add(layer);
            for (LNode node : span.nodes) {
                node.setLayer(layer);
                node.id = 0;
            }
        }
    }

    private void correctLayeringRespectingGraphTopology(LGraph graph) {
        for (LNode node : graph.getLayerlessNodes()) {
            if (node.id != 0) continue;
            this.checkNode(node, graph);
        }
        ListIterator<Layer> layerIterator = graph.getLayers().listIterator();
        while (layerIterator.hasNext()) {
            if (!layerIterator.next().getNodes().isEmpty()) continue;
            layerIterator.remove();
        }
    }

    private void checkNode(LNode node1, LGraph graph) {
        node1.id = 1;
        Layer layer1 = node1.getLayer();
        for (LPort port : node1.getPorts(PortType.OUTPUT)) {
            for (LEdge edge : port.getOutgoingEdges()) {
                Layer newLayer;
                LNode node2 = edge.getTarget().getNode();
                if (node1 == node2) continue;
                Layer layer2 = node2.getLayer();
                if (layer2.id > layer1.id) continue;
                int newIndex = layer1.id + 1;
                if (newIndex == graph.getLayers().size()) {
                    newLayer = new Layer(graph);
                    newLayer.id = newIndex;
                    graph.getLayers().add(newLayer);
                    node2.setLayer(newLayer);
                } else {
                    newLayer = graph.getLayers().get(newIndex);
                    node2.setLayer(newLayer);
                }
                this.checkNode(node2, graph);
            }
        }
    }

    private static class LayerSpan {
        private double start;
        private double end;
        private double rightMostCenter;
        private List<LNode> nodes = Lists.newArrayList();

        private LayerSpan() {
        }
    }
}

