/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.ortools;

import com.google.ortools.sat.CpSolver;
import java.io.File;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;

public final class OrToolsLibLoader {
    public static final String NAME_OF_DLL = "jniortools-9.7.2996.dll";
    private static boolean loaded = false;

    private OrToolsLibLoader() {
    }

    public static synchronized void loadLibrary() {
        OrToolsLibLoader.loadLibrary(OrToolsLibLoader.getLibraryPath());
    }

    public static synchronized void loadLibrary(String libPath) {
        if (!loaded) {
            block3: {
                try {
                    System.load(libPath);
                }
                catch (UnsatisfiedLinkError e) {
                    if (e.getMessage().contains("already loaded")) break block3;
                    throw e;
                }
            }
            loaded = true;
        }
    }

    private static String getLibraryPath() {
        Path dirWithOrToolsJar;
        try {
            dirWithOrToolsJar = Paths.get(CpSolver.class.getProtectionDomain().getCodeSource().getLocation().toURI()).getParent();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid URI: " + e.getInput(), e);
        }
        File dllFile = dirWithOrToolsJar.resolve(NAME_OF_DLL).toFile();
        return dllFile.getAbsolutePath();
    }
}

