/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.ortools;

import com.google.ortools.linearsolver.MPConstraint;
import com.google.ortools.linearsolver.MPSolver;
import com.google.ortools.linearsolver.MPVariable;
import com.modelengineers.MoRe_elk.alg.layered.mesutils.MesUtilMethods;
import com.modelengineers.MoRe_elk.alg.layered.ortools.OrToolsLibLoader;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MPSolverWrapperInt {
    private MPSolver solver;
    private MPSolver.ResultStatus resultStatus;

    public MPSolverWrapperInt() {
        OrToolsLibLoader.loadLibrary();
        this.solver = MPSolver.createSolver("SCIP");
    }

    public void setMinimization() {
        this.solver.objective().setMinimization();
    }

    public void solve() throws InterruptedException {
        MesUtilMethods.runAsThreadWithInterruptHandling(() -> this.solveAndSaveResultStatus(), () -> {
            boolean bl = this.solver.interruptSolve();
        });
    }

    public MPSolver.ResultStatus getResultStatus() {
        return this.resultStatus;
    }

    private void solveAndSaveResultStatus() {
        this.resultStatus = this.solver.solve();
    }

    public void printVariables() {
        MPVariable[] vars = this.solver.variables();
        MPVariable[] varsSorted = Arrays.copyOf(vars, vars.length);
        Arrays.sort(varsSorted, Comparator.comparing(MPVariable::name));
        int i = 0;
        while (i < varsSorted.length) {
            System.out.println(String.valueOf(varsSorted[i].name()) + " = " + varsSorted[i].solutionValue());
            ++i;
        }
    }

    public void setObjectiveCoeff(MPVariable var, double coeff) {
        this.solver.objective().setCoefficient(var, coeff);
    }

    public MPConstraint makeConstraint(double lb, double ub) {
        return this.solver.makeConstraint(lb, ub);
    }

    public MPConstraint makeConstraint() {
        return this.solver.makeConstraint();
    }

    public MPVariable makeIntVar(double lb, double ub, String name) {
        return this.solver.makeIntVar(lb, ub, name);
    }

    public void diffHasToBe(MPVariable a, MPVariable b, double d) {
        this.diffHasToBeInRange(a, b, d, d);
    }

    public void diffHasToBeInRange(MPVariable a, MPVariable b, double lowerBound, double upperBound) {
        MPConstraint c = this.solver.makeConstraint(lowerBound, upperBound);
        c.setCoefficient(a, 1.0);
        c.setCoefficient(b, -1.0);
    }

    public MPVariable makeDiffVar(MPVariable a, MPVariable b) {
        double lowerBound = a.lb() - b.ub();
        double upperBound = a.ub() - b.lb();
        MPVariable d = this.solver.makeIntVar(lowerBound, upperBound, String.valueOf(a.name()) + " - " + b.name());
        MPConstraint c = this.solver.makeConstraint(0.0, 0.0);
        c.setCoefficient(d, 1.0);
        c.setCoefficient(a, -1.0);
        c.setCoefficient(b, 1.0);
        return d;
    }

    public MPVariable makeDiffVar(MPVariable v, int c) {
        double lowerBound = v.lb() - (double)c;
        double upperBound = v.ub() - (double)c;
        MPVariable d = this.solver.makeIntVar(lowerBound, upperBound, String.valueOf(v.name()) + " - " + c);
        MPConstraint constr = this.solver.makeConstraint(c, c);
        constr.setCoefficient(v, 1.0);
        constr.setCoefficient(d, -1.0);
        return d;
    }

    public MPVariable makeSumVar(List<MPVariable> vars) {
        double lb = 0.0;
        double ub = 0.0;
        StringJoiner name = new StringJoiner(" + ");
        for (MPVariable v : vars) {
            lb += v.lb();
            ub += v.ub();
            name.add(v.name());
        }
        MPVariable sum = this.solver.makeIntVar(lb, ub, name.toString());
        MPConstraint c = this.solver.makeConstraint(0.0, 0.0);
        Map<MPVariable, Long> varCounts = vars.stream().collect(Collectors.groupingBy(e -> e, Collectors.counting()));
        for (MPVariable v : varCounts.keySet()) {
            c.setCoefficient(v, varCounts.get(v).longValue());
        }
        c.setCoefficient(sum, -1.0);
        return sum;
    }

    public MPVariable makePosVar(MPVariable v) {
        return this.makeAbsVarMap(v).get("vP");
    }

    public MPVariable makeAbsVar(MPVariable v) {
        return this.makeAbsVarMap(v).get("vAbs");
    }

    private Map<String, MPVariable> makeAbsVarMap(MPVariable v) {
        HashMap<String, MPVariable> varMap = new HashMap<String, MPVariable>();
        long maxAbs = (long)Math.max(Math.abs(v.lb()), Math.abs(v.ub()));
        MPVariable vAbs = this.solver.makeIntVar(0.0, maxAbs, String.format("|%s|", v.name()));
        MPVariable vP = this.solver.makeIntVar(0.0, maxAbs, String.format("(%s)+", v.name()));
        MPVariable vN = this.solver.makeIntVar(0.0, maxAbs, String.format("(%s)-", v.name()));
        MPVariable vIsPositiveOrZero = this.solver.makeIntVar(0.0, 1.0, String.valueOf(v.name()) + " >= 0");
        MPVariable vIsNegative = this.solver.makeIntVar(0.0, 1.0, String.valueOf(v.name()) + " < 0");
        MPConstraint cV = this.solver.makeConstraint(0.0, 0.0);
        cV.setCoefficient(v, -1.0);
        cV.setCoefficient(vP, 1.0);
        cV.setCoefficient(vN, -1.0);
        MPConstraint cVAbs = this.solver.makeConstraint(0.0, 0.0);
        cVAbs.setCoefficient(vAbs, -1.0);
        cVAbs.setCoefficient(vP, 1.0);
        cVAbs.setCoefficient(vN, 1.0);
        MPConstraint cVP = this.solver.makeConstraint(-maxAbs, 0.0);
        cVP.setCoefficient(vP, 1.0);
        cVP.setCoefficient(vIsPositiveOrZero, -maxAbs);
        MPConstraint cVN = this.solver.makeConstraint(0.0, maxAbs);
        cVN.setCoefficient(vN, 1.0);
        cVN.setCoefficient(vIsPositiveOrZero, maxAbs);
        MPConstraint cOR = this.solver.makeConstraint(1.0, 1.0);
        cOR.setCoefficient(vIsPositiveOrZero, 1.0);
        cOR.setCoefficient(vIsNegative, 1.0);
        varMap.put("vAbs", vAbs);
        varMap.put("vP", vP);
        return varMap;
    }

    public MPVariable makeAbsDiffVar(MPVariable a, MPVariable b) {
        MPVariable diff = this.makeDiffVar(a, b);
        return this.makeAbsVar(diff);
    }

    public MPVariable makeMaxVar(Stream<MPVariable> vars, String name) {
        return this.makeMaxVar(vars.collect(Collectors.toList()), name);
    }

    public MPVariable makeMaxVar(List<MPVariable> vars, String name) {
        if (vars.size() == 1) {
            return this.makeCopyOfIntVar(vars.get(0), name);
        }
        return this.makeMaxVarForMoreThan1Var(vars, name);
    }

    private MPVariable makeMaxVarForMoreThan1Var(List<MPVariable> vars, String name) {
        double lowerBoundOfMax = vars.stream().map(MPVariable::lb).max(Double::compareTo).get();
        double upperBoundOfMax = vars.stream().map(MPVariable::ub).max(Double::compareTo).get();
        MPVariable max = this.solver.makeIntVar(lowerBoundOfMax, upperBoundOfMax, name);
        MPVariable[] isMax = this.solver.makeIntVarArray(vars.size(), 0.0, 1.0);
        MPConstraint sumIs1 = this.solver.makeConstraint(1.0, 1.0);
        int i = 0;
        while (i < vars.size()) {
            sumIs1.setCoefficient(isMax[i], 1.0);
            ++i;
        }
        vars.forEach(v -> this.diffHasToBeInRange(max, (MPVariable)v, 0.0, 2.147483647E9));
        i = 0;
        while (i < vars.size()) {
            MPVariable var = vars.get(i);
            MPConstraint currentConstraint = this.solver.makeConstraint();
            currentConstraint.setUb(2.147483647E9);
            currentConstraint.setCoefficient(max, 1.0);
            currentConstraint.setCoefficient(var, -1.0);
            currentConstraint.setCoefficient(isMax[i], 2.147483647E9);
            ++i;
        }
        return max;
    }

    public MPVariable makeMinVar(Stream<MPVariable> vars, String name) {
        return this.makeMinVar(vars.collect(Collectors.toList()), name);
    }

    public MPVariable makeMinVar(List<MPVariable> vars, String name) {
        if (vars.size() == 1) {
            return this.makeCopyOfIntVar(vars.get(0), name);
        }
        return this.makeMinVarForMoreThan1Var(vars, name);
    }

    private MPVariable makeCopyOfIntVar(MPVariable var, String name) {
        MPVariable copy = this.solver.makeIntVar(var.lb(), var.ub(), name);
        MPConstraint c = this.solver.makeConstraint(0.0, 0.0);
        c.setCoefficient(var, 1.0);
        c.setCoefficient(copy, -1.0);
        return copy;
    }

    private MPVariable makeMinVarForMoreThan1Var(List<MPVariable> vars, String name) {
        double lowerBoundOfMin = vars.stream().map(MPVariable::lb).min(Double::compareTo).get();
        double upperBoundOfMin = vars.stream().map(MPVariable::ub).min(Double::compareTo).get();
        MPVariable min = this.solver.makeIntVar(lowerBoundOfMin, upperBoundOfMin, name);
        MPVariable[] isMin = this.solver.makeIntVarArray(vars.size(), 0.0, 1.0);
        MPConstraint sumIs1 = this.solver.makeConstraint(1.0, 1.0);
        int i = 0;
        while (i < vars.size()) {
            sumIs1.setCoefficient(isMin[i], 1.0);
            ++i;
        }
        vars.forEach(v -> this.diffHasToBeInRange((MPVariable)v, min, 0.0, 2.147483647E9));
        i = 0;
        while (i < vars.size()) {
            MPVariable var = vars.get(i);
            MPConstraint currentConstraint = this.solver.makeConstraint();
            currentConstraint.setLb(-2.147483647E9);
            currentConstraint.setCoefficient(min, 1.0);
            currentConstraint.setCoefficient(var, -1.0);
            currentConstraint.setCoefficient(isMin[i], -2.147483647E9);
            ++i;
        }
        return min;
    }

    public MPVariable makeIsLessThanOrEqualToVar(MPVariable a, MPVariable b) {
        MPVariable z = this.solver.makeIntVar(0.0, 1.0, String.format("%s <= %s", a.name(), b.name()));
        double m1 = a.ub() - b.lb();
        double m2 = b.ub() - a.lb() + 1.0;
        MPConstraint c1 = this.solver.makeConstraint();
        c1.setUb(m1);
        c1.setCoefficient(a, 1.0);
        c1.setCoefficient(b, -1.0);
        c1.setCoefficient(z, m1);
        MPConstraint c2 = this.solver.makeConstraint();
        c2.setLb(1.0);
        c2.setCoefficient(a, 1.0);
        c2.setCoefficient(b, -1.0);
        c2.setCoefficient(z, m2);
        return z;
    }

    public MPVariable makeIsLessThanVar(MPVariable a, MPVariable b) {
        MPVariable z = this.solver.makeIntVar(0.0, 1.0, String.format("%s < %s", a.name(), b.name()));
        double m1 = a.ub() - b.lb() + 1.0;
        double m2 = b.ub() - a.lb();
        MPConstraint c1 = this.solver.makeConstraint();
        c1.setUb(m1 - 1.0);
        c1.setCoefficient(a, 1.0);
        c1.setCoefficient(b, -1.0);
        c1.setCoefficient(z, m1);
        MPConstraint c2 = this.solver.makeConstraint();
        c2.setLb(0.0);
        c2.setCoefficient(a, 1.0);
        c2.setCoefficient(b, -1.0);
        c2.setCoefficient(z, m2);
        return z;
    }

    public MPVariable makeIsLessThanVar(double a, MPVariable b) {
        MPVariable z = this.solver.makeIntVar(0.0, 1.0, String.format("%s < %s", a, b.name()));
        double m1 = a - b.lb() + 1.0;
        double m2 = b.ub() - a;
        MPConstraint c1 = this.solver.makeConstraint();
        c1.setUb(-a + m1 - 1.0);
        c1.setCoefficient(b, -1.0);
        c1.setCoefficient(z, m1);
        MPConstraint c2 = this.solver.makeConstraint();
        c2.setLb(-a);
        c2.setCoefficient(b, -1.0);
        c2.setCoefficient(z, m2);
        return z;
    }

    public MPVariable makeIsEqualToVar(MPVariable a, MPVariable b) {
        MPVariable z = this.solver.makeIntVar(0.0, 1.0, String.valueOf(a.name()) + " == " + b.name());
        double m1 = a.ub() - b.lb();
        MPConstraint cAi = this.solver.makeConstraint();
        cAi.setUb(m1);
        cAi.setCoefficient(a, 1.0);
        cAi.setCoefficient(b, -1.0);
        cAi.setCoefficient(z, m1);
        double m2 = b.ub() - a.lb();
        MPConstraint cAii = this.solver.makeConstraint();
        cAii.setUb(m2);
        cAii.setCoefficient(b, 1.0);
        cAii.setCoefficient(a, -1.0);
        cAii.setCoefficient(z, m2);
        MPVariable y = this.solver.makeIntVar(0.0, 1.0, String.valueOf(a.name()) + " < " + b.name() + " OR " + a.name() + " > " + b.name());
        double m3 = a.ub() - b.lb() + 1.0;
        MPConstraint cBi = this.solver.makeConstraint();
        cBi.setUb(-1.0);
        cBi.setCoefficient(a, 1.0);
        cBi.setCoefficient(b, -1.0);
        cBi.setCoefficient(z, -m3);
        cBi.setCoefficient(y, -m3);
        double m4 = b.ub() - a.lb() + 1.0;
        MPConstraint cBii = this.solver.makeConstraint();
        cBii.setUb(m4 - 1.0);
        cBii.setCoefficient(a, -1.0);
        cBii.setCoefficient(b, 1.0);
        cBii.setCoefficient(z, -m4);
        cBii.setCoefficient(y, m4);
        return z;
    }

    public MPVariable makeIsNotEqualToVar(MPVariable a, MPVariable b) {
        MPVariable ab = this.makeIsLessThanVar(a, b);
        MPVariable ba = this.makeIsLessThanVar(b, a);
        MPVariable z = this.solver.makeIntVar(0.0, 1.0, String.format("%s != %s", a.name(), b.name()));
        MPConstraint c1 = this.solver.makeConstraint();
        c1.setUb(0.0);
        c1.setCoefficient(ab, 1.0);
        c1.setCoefficient(z, -1.0);
        MPConstraint c2 = this.solver.makeConstraint();
        c2.setUb(0.0);
        c2.setCoefficient(ba, 1.0);
        c2.setCoefficient(z, -1.0);
        MPConstraint c3 = this.solver.makeConstraint();
        c3.setUb(0.0);
        c3.setCoefficient(z, 1.0);
        c3.setCoefficient(ab, -1.0);
        c3.setCoefficient(ba, -1.0);
        return z;
    }
}

